/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Block.Dimension.Structure.Gravity.BlockGravityTile;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityLumaBurst
extends ParticleEntity {
    private CrystalElement color;
    private boolean outOfSpawnZone;
    private boolean outOfSpawnZoneLast;

    public EntityLumaBurst(World world) {
        super(world);
    }

    public EntityLumaBurst(World world, int x, int y, int z, ReikaDirectionHelper.CubeDirections dir, CrystalElement e) {
        super(world, x, y, z, dir);
        this.setColor(e);
    }

    public EntityLumaBurst(World world, int x, int y, int z, double ang, CrystalElement e) {
        super(world, x, y, z);
        this.setColor(e);
        this.setAngle(ang);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public void copyFrom(EntityLumaBurst e) {
        this.setColor(e.color);
        this.field_70159_w = e.field_70159_w;
        this.field_70181_x = e.field_70181_x;
        this.field_70179_y = e.field_70179_y;
    }

    public void setColor(CrystalElement e) {
        this.color = e;
        this.field_70180_af.func_75692_b(24, (Object)e.ordinal());
    }

    protected void setDirection(ReikaDirectionHelper.CubeDirections dir, boolean setPos) {
        if (setPos) {
            super.setDirection(dir, setPos);
        }
        double d = 10.0;
        double a = ReikaRandomHelper.getRandomPlusMinus((double)dir.angle, (double)d);
        this.setAngle(a);
    }

    private void setAngle(double a) {
        double[] vel = ReikaPhysicsHelper.polarToCartesian((double)this.getSpeed(), (double)0.0, (double)(-a));
        this.field_70159_w = vel[0];
        this.field_70179_y = vel[2];
        this.field_70181_x = vel[1];
    }

    public void resetSpawnTimer() {
        if (!this.outOfSpawnZoneLast) {
            this.outOfSpawnZone = false;
        }
    }

    public boolean isOutOfSpawnZone() {
        return this.outOfSpawnZone;
    }

    public double getHitboxSize() {
        return 0.0625;
    }

    public boolean despawnOverTime() {
        return false;
    }

    public boolean despawnOverDistance() {
        return true;
    }

    protected double getDespawnDistance() {
        return 25.0;
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    protected void onTick() {
        double dy;
        if (this.getSpawnLocation() != null && Math.abs(dy = this.field_70163_u - (double)this.getSpawnLocation().yCoord + 0.5) >= 0.4 && Math.signum(this.field_70181_x) == Math.signum(dy)) {
            this.field_70181_x = -this.field_70181_x;
        }
        if (this.field_70170_p.field_72995_K) {
            this.doParticles();
        }
        if (this.outOfSpawnZone) {
            this.outOfSpawnZoneLast = true;
        }
        this.outOfSpawnZone = true;
        this.color = CrystalElement.elements[this.field_70180_af.func_75679_c(24)];
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles() {
        for (double d = 0.0; d <= 1.0; d += 0.25) {
            double px = this.field_70165_t - (this.field_70165_t - this.field_70142_S) * d;
            double py = this.field_70163_u - (this.field_70163_u - this.field_70137_T) * d;
            double pz = this.field_70161_v - (this.field_70161_v - this.field_70136_U) * d;
            int c = ReikaColorAPI.mixColors((int)this.color.getColor(), (int)0, (float)0.5f);
            EntityBlurFX fx = new EntityBlurFX(this.field_70170_p, px, py, pz).setColor(c).setAlphaFading().setScale(0.5f).setLife(4).setAge((int)Math.round(d));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public double getSpeed() {
        return ReikaRandomHelper.getRandomPlusMinus((double)0.15, (double)0.025);
    }

    protected boolean onEnterBlock(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (b == ChromaBlocks.GRAVITY.getBlockInstance()) {
            int meta = world.func_72805_g(x, y, z);
            BlockGravityTile.GravityTiles g = BlockGravityTile.GravityTiles.list[meta];
            return g.onPulse(world, x, y, z, this);
        }
        return true;
    }

    public void func_70108_f(Entity e) {
    }

    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.color.ordinal());
    }

    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.color = CrystalElement.elements[data.readInt()];
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.color = CrystalElement.elements[tag.func_74762_e("color")];
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("color", this.color.ordinal());
    }

    public CrystalElement getColor() {
        return this.color;
    }

    public double getRenderRangeSquared() {
        return 4096.0;
    }

    public void setRandomDirection(boolean fullFreedom) {
        if (fullFreedom) {
            double ang = this.field_70146_Z.nextDouble() * 360.0;
            double slope = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)5);
            double[] vel = ReikaPhysicsHelper.polarToCartesian((double)this.getSpeed(), (double)slope, (double)ang);
            this.field_70159_w = vel[0];
            this.field_70181_x = vel[1];
            this.field_70179_y = vel[2];
            this.field_70133_I = true;
        } else {
            this.setDirection(ReikaDirectionHelper.CubeDirections.list[this.field_70146_Z.nextInt(ReikaDirectionHelper.CubeDirections.list.length)], false);
        }
    }
}

