/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.DragonAPI.Instantiable.Data.SphericalVector;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBallLightning
extends EntityLiving
implements IEntityAdditionalSpawnData {
    private SphericalVector velocity;
    private double targetTheta;
    private double targetPhi;
    private double targetVelocity;
    private CrystalElement color;
    private CrystalElement targetColor;
    private float colorTransitionFraction;
    private boolean isPylonSpawn;
    private boolean doDrops;

    public EntityBallLightning(World world, CrystalElement color, double x, double y, double z) {
        super(world);
        this.targetTheta = this.field_70146_Z.nextInt(360);
        this.targetPhi = this.field_70146_Z.nextInt(360);
        this.targetVelocity = ReikaRandomHelper.getRandomPlusMinus((double)0.1, (double)0.1);
        this.targetColor = null;
        this.colorTransitionFraction = 0.0f;
        this.isPylonSpawn = false;
        this.doDrops = true;
        this.color = color;
        this.func_70107_b(x, y, z);
        this.field_70131_O = 0.25f;
        this.field_70130_N = 0.25f;
    }

    public EntityBallLightning(World world) {
        super(world);
        this.targetTheta = this.field_70146_Z.nextInt(360);
        this.targetPhi = this.field_70146_Z.nextInt(360);
        this.targetVelocity = ReikaRandomHelper.getRandomPlusMinus((double)0.1, (double)0.1);
        this.targetColor = null;
        this.colorTransitionFraction = 0.0f;
        this.isPylonSpawn = false;
        this.doDrops = true;
    }

    public EntityBallLightning setNoDrops() {
        this.doDrops = false;
        return this;
    }

    public EntityBallLightning setPylon() {
        this.isPylonSpawn = true;
        return this;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70687_e(PotionEffect e) {
        return false;
    }

    protected String func_146067_o(int p_146067_1_) {
        return "";
    }

    protected void func_70069_a(float p_70069_1_) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public String func_70005_c_() {
        return this.color.displayName + " Ball Lightning";
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.velocity = new SphericalVector(0.15, (double)this.field_70146_Z.nextInt(360), (double)this.field_70146_Z.nextInt(360));
        if (this.color == null) {
            this.color = CrystalElement.randomElement();
        }
        this.field_70180_af.func_75682_a(30, (Object)0);
        if (this.field_70170_p != null) {
            // empty if block
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (ReikaMathLibrary.approxr((double)this.velocity.inclination, (double)this.targetTheta, (double)2.0)) {
                this.targetTheta = this.field_70146_Z.nextInt(360);
            } else {
                this.velocity.inclination = this.targetTheta > this.velocity.inclination ? (this.velocity.inclination += 1.0) : (this.velocity.inclination -= 1.0);
            }
            if (ReikaMathLibrary.approxr((double)this.velocity.rotation, (double)this.targetPhi, (double)2.0)) {
                this.targetPhi = this.field_70146_Z.nextInt(360);
            } else {
                this.velocity.rotation = this.targetPhi > this.velocity.rotation ? (this.velocity.rotation += 1.0) : (this.velocity.rotation -= 1.0);
            }
            if (ReikaMathLibrary.approxr((double)this.velocity.magnitude, (double)this.targetVelocity, (double)0.05)) {
                this.targetVelocity = ReikaRandomHelper.getRandomPlusMinus((double)0.1, (double)0.1);
            } else {
                this.velocity.magnitude = this.targetVelocity > this.velocity.magnitude ? (this.velocity.magnitude += 0.01) : (this.velocity.magnitude -= 0.01);
            }
            this.field_70133_I = true;
            double[] v = this.velocity.getCartesian();
            this.field_70159_w = v[0];
            this.field_70181_x = v[1];
            this.field_70179_y = v[2];
        }
        if (this.targetColor != null) {
            this.colorTransitionFraction += 0.1f;
            if (this.colorTransitionFraction >= 1.0f) {
                this.color = this.targetColor;
                this.targetColor = null;
                this.colorTransitionFraction = 0.0f;
            }
        }
        this.field_70180_af.func_75692_b(30, (Object)this.calcRenderColor());
        if (this.field_70170_p.field_72995_K) {
            this.lifeParticles();
        }
        this.field_70143_R = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void lifeParticles() {
        int p = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (this.field_70146_Z.nextInt(1 + p * 2) == 0) {
            double d = 0.25;
            double px = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70165_t, (double)d);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70163_u, (double)d);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)this.field_70161_v, (double)d);
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.05, (double)0.025);
            if (this.field_70146_Z.nextInt(4) == 0) {
                g = -g;
            }
            EntityLaserFX fx = new EntityLaserFX(this.color, this.field_70170_p, px, py, pz).setColor(this.getRenderColor()).setGravity(g);
            EntityLaserFX fx2 = new EntityLaserFX(this.color, this.field_70170_p, px, py, pz).setColor(0xFFFFFF).setScale(0.42f).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        int c = nbt.func_74762_e("color");
        this.color = c >= 0 ? CrystalElement.elements[c] : CrystalElement.randomElement();
        this.isPylonSpawn = nbt.func_74767_n("pylon");
        this.doDrops = nbt.func_74767_n("dodrops");
        if (nbt.func_74767_n("isdead")) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.color != null) {
            nbt.func_74768_a("color", this.color.ordinal());
        }
        nbt.func_74757_a("dodrops", this.doDrops);
        nbt.func_74757_a("pylon", this.isPylonSpawn);
        nbt.func_74757_a("isdead", this.field_70128_L);
    }

    private void die() {
        if (this.field_70170_p.field_72995_K) {
            EntityBallLightning.doDeathParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getRenderColor());
        } else {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.LIGHTNINGDIE.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)this, 32), (int[])new int[]{this.calcRenderColor()});
        }
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p != null) {
            // empty if block
        }
    }

    private void doBolt(EntityBallLightning other) {
        Vec3 vec = ReikaVectorHelper.getVec2Pt((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)other.field_70165_t, (double)other.field_70163_u, (double)other.field_70161_v);
        this.targetColor = other.color;
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.GLUON.ordinal(), (PacketTarget)new PacketTarget.DimensionTarget(this.field_70170_p), (int[])new int[]{this.func_145782_y(), other.func_145782_y()});
        double len = vec.func_72433_c();
        for (double i = 0.0; i < len; i += 0.0625) {
            double dx = this.field_70165_t - i * vec.field_72450_a / len;
            double dy = this.field_70163_u - i * vec.field_72448_b / len;
            double dz = this.field_70161_v - i * vec.field_72449_c / len;
            if (this.field_70170_p.field_72995_K) {
                this.gluonParticles(other, dx, dy, dz, (float)(i / len));
            }
            if (!ChromaOptions.HOSTILEFOREST.getState()) continue;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)dx, (double)dy, (double)dz, (double)dx, (double)dy, (double)dz).func_72314_b(0.5, 0.5, 0.5);
            List elb = this.field_70170_p.func_72872_a(EntityLivingBase.class, box);
            for (EntityLivingBase e : elb) {
                e.func_70097_a(DamageSource.field_76377_j, this.isPylonSpawn ? 4.0f : 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doBoltClient(EntityBallLightning other) {
        this.targetColor = other.color;
    }

    @SideOnly(value=Side.CLIENT)
    private void gluonParticles(EntityBallLightning other, double dx, double dy, double dz, float frac) {
        int c = ReikaColorAPI.mixColors((int)other.getRenderColor(), (int)this.getRenderColor(), (float)frac);
        EntityBlurFX fx = new EntityBlurFX(this.field_70170_p, dx, dy, dz);
        fx.setLife(5).setColor(c);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void onReceiveBolt(EntityBallLightning src) {
        this.targetColor = src.color;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityBallLightning) && !this.field_70170_p.field_72995_K) {
            boolean flag;
            boolean bl = flag = entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
            if (!flag) {
                if (ChromaOptions.HOSTILEFOREST.getState()) {
                    entity.func_70097_a(DamageSource.field_76377_j, 5.0f);
                }
                if (entity instanceof EntityPlayer) {
                    ProgressionManager.ProgressStage.BALLLIGHTNING.stepPlayerTo((EntityPlayer)entity);
                }
                this.die();
            }
        }
        return null;
    }

    public void func_70636_d() {
        EntityBallLightning e;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.colorTransitionFraction == 0.0f && this.field_70146_Z.nextInt(400) == 0 && (e = (EntityBallLightning)ReikaEntityHelper.getNearestEntityOfSameType((Entity)this, (int)24)) != null && e.colorTransitionFraction == 0.0f) {
            this.doBolt(e);
            e.onReceiveBolt(this);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(1600) == 0 && !CrystalNetworker.instance.getNearbyPylons(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.color, 24, false).isEmpty()) {
            this.func_70691_i(this.func_110138_aP());
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer ep = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (this.field_70163_u >= 128.0) {
                this.die();
            } else if (ep == null || this.field_70170_p.field_73010_i.isEmpty()) {
                this.die();
            } else if (this.field_70173_aa >= 12000 || this.field_70146_Z.nextInt(12000 - this.field_70173_aa) == 0) {
                this.die();
            } else if (this.field_70170_p.func_72896_J() && this.field_70146_Z.nextInt(80) == 0) {
                this.die();
            } else if (this.func_70090_H()) {
                this.die();
            } else if (this.func_70068_e((Entity)ep) >= 65536.0) {
                this.die();
            } else if (this.func_70068_e((Entity)ep) >= 1024.0 && this.field_70146_Z.nextInt(200) == 0) {
                this.die();
            } else if (this.field_70146_Z.nextInt(20) == 0) {
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_70165_t, (double)0.0, (double)this.field_70161_v, (double)this.field_70165_t, (double)1024.0, (double)this.field_70161_v).func_72314_b(24.0, 0.0, 24.0);
                List li = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), box);
                if (this.field_70146_Z.nextInt(1 + li.size() / 16) > 0) {
                    this.die();
                }
            }
        }
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(5) == 0 && this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) + 1, MathHelper.func_76128_c((double)this.field_70161_v));
    }

    public int func_70641_bl() {
        return 4;
    }

    public void func_70642_aH() {
        float p = CrystalMusicManager.instance.getRandomScaledDing(this.color);
        ChromaSounds.BALLLIGHTNING.playSound((Entity)this, 1.0f, p);
    }

    public final int func_70627_aG() {
        return 20;
    }

    protected final void func_145780_a(int par1, int par2, int par3, Block par4) {
    }

    protected String func_70621_aR() {
        return "";
    }

    protected String func_70673_aS() {
        return "";
    }

    public void func_70645_a(DamageSource src) {
        ChromaSounds.DISCHARGE.playSound((Entity)this, 1.0f, 2.0f);
        if (!this.field_70170_p.field_72995_K) {
            Entity e = src.func_76346_g();
            if (e instanceof EntityPlayer) {
                EntityPlayer ep = (EntityPlayer)e;
                if (this.doDrops && !ReikaPlayerAPI.isFakeOrNotInteractable((EntityPlayer)ep, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)8.0)) {
                    int looting = EnchantmentHelper.func_77519_f((EntityLivingBase)((EntityPlayer)src.func_76346_g()));
                    if (BlockTieredPlant.TieredPlants.DESERT.level.isPlayerAtStage(ep)) {
                        ReikaItemHelper.dropItem((Entity)this, (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.beaconDust, (int)this.field_70146_Z.nextInt(1 + looting * 2)));
                    }
                    if (looting > 1 && this.color.isPrimary()) {
                        if (BlockTieredPlant.TieredPlants.CAVE.level.isPlayerAtStage(ep)) {
                            ReikaItemHelper.dropItem((Entity)this, (ItemStack)ChromaStacks.purityDust);
                        } else if (BlockTieredPlant.TieredPlants.FLOWER.level.isPlayerAtStage(ep)) {
                            ReikaItemHelper.dropItem((Entity)this, (ItemStack)ChromaStacks.auraDust);
                        }
                    }
                }
                ProgressionManager.ProgressStage.BALLLIGHTNING.stepPlayerTo(ep);
            }
            this.sendDeathParticles();
        }
    }

    private void sendDeathParticles() {
        ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.LIGHTNINGDIE.ordinal(), (Entity)this, (PacketTarget)new PacketTarget.DimensionTarget(this.field_70170_p), (int[])new int[]{this.calcRenderColor()});
    }

    @SideOnly(value=Side.CLIENT)
    public static void receiveDeathParticles(World world, double dx, double dy, double dz, int color) {
        EntityBallLightning.doDeathParticles(world, dx, dy, dz, color);
    }

    @SideOnly(value=Side.CLIENT)
    private static void doDeathParticles(World world, double dx, double dy, double dz, int color) {
        int n = 32;
        for (int i = 0; i < n; ++i) {
            EntityCenterBlurFX fx = new EntityCenterBlurFX(world, dx, dy, dz).setColor(color).setScale(1.5f);
            fx.field_70159_w = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.2);
            fx.field_70181_x = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.2);
            fx.field_70179_y = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.2);
            EntityCenterBlurFX fx2 = new EntityCenterBlurFX(world, dx, dy, dz).setColor(0xFFFFFF).setScale(0.5f);
            fx2.field_70159_w = fx.field_70159_w;
            fx2.field_70181_x = fx.field_70181_x;
            fx2.field_70179_y = fx.field_70179_y;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.color != null ? this.color.ordinal() : -1);
    }

    public void readSpawnData(ByteBuf buf) {
        int c = buf.readInt();
        this.color = c >= 0 && c < 16 ? CrystalElement.elements[c] : CrystalElement.randomElement();
    }

    private int calcRenderColor() {
        return this.targetColor != null ? ReikaColorAPI.mixColors((int)this.targetColor.getColor(), (int)this.color.getColor(), (float)this.colorTransitionFraction) : this.color.getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        return this.field_70180_af.func_75679_c(30);
    }

    public boolean func_70097_a(DamageSource src, float dmg) {
        Entity e = src.func_76346_g();
        if (e instanceof EntityPlayer && !ReikaPlayerAPI.isFake((EntityPlayer)((EntityPlayer)e))) {
            boolean flag = super.func_70097_a(src, dmg);
            if (flag && this.func_110143_aJ() <= 0.0f) {
                this.die();
            }
            return flag;
        }
        return false;
    }

    public CrystalElement getElement() {
        return this.color;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    protected void func_70628_a(boolean recentHit, int looting) {
        if (recentHit) {
            // empty if block
        }
    }
}

