/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Entity;

import Reika.ChromatiCraft.World.Dimension.Rendering.Aurora;
import Reika.DragonAPI.Base.InertEntity;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityAurora
extends InertEntity
implements IEntityAdditionalSpawnData {
    private AuroraData data = new AuroraData();
    @SideOnly(value=Side.CLIENT)
    private Aurora aurora;

    public EntityAurora(World world, AuroraData dat) {
        this(world);
        this.data = dat;
        if (this.field_70170_p.field_72995_K) {
            this.initAurora();
        }
        double x = (dat.pos2X + dat.pos1X) / 2.0;
        double y = (dat.pos2Y + dat.pos1Y) / 2.0;
        double z = (dat.pos2Z + dat.pos1Z) / 2.0;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityAurora(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    private void initAurora() {
        this.aurora = this.data.createAurora();
    }

    @SideOnly(value=Side.CLIENT)
    public Aurora getAurora() {
        return this.aurora;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.aurora.update();
        }
    }

    protected void func_70037_a(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l("data");
        this.data.readFromNBT(tag);
        if (this.field_70170_p.field_72995_K) {
            this.initAurora();
        }
    }

    protected void func_70014_b(NBTTagCompound NBT) {
        NBTTagCompound tag = new NBTTagCompound();
        this.data.writeToNBT(tag);
        NBT.func_74782_a("data", (NBTBase)tag);
    }

    public void writeSpawnData(ByteBuf buf) {
        this.data.writeData(buf);
    }

    public void readSpawnData(ByteBuf buf) {
        this.data.readData(buf);
        if (this.field_70170_p.field_72995_K) {
            this.initAurora();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean func_70112_a(double dist) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double par2, double par4, double par6) {
        return true;
    }

    public static class AuroraData {
        private double pos1X;
        private double pos1Y;
        private double pos1Z;
        private double pos2X;
        private double pos2Y;
        private double pos2Z;
        private int color1;
        private int color2;
        private double variance;
        private double speed;
        private double segmentSize;

        private AuroraData() {
        }

        public AuroraData(double x1, double y1, double z1, double x2, double y2, double z2, int c1, int c2, double sp) {
            this.pos1X = x1;
            this.pos1Y = y1;
            this.pos1Z = z1;
            this.pos2X = x2;
            this.pos2Y = y2;
            this.pos2Z = z2;
            this.color1 = c1;
            this.color2 = c2;
            this.speed = sp;
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74780_a("p1x", this.pos1X);
            tag.func_74780_a("p1y", this.pos1Y);
            tag.func_74780_a("p1z", this.pos1Z);
            tag.func_74780_a("p2x", this.pos2X);
            tag.func_74780_a("p2y", this.pos2Y);
            tag.func_74780_a("p2z", this.pos2Z);
            tag.func_74780_a("speed", this.speed);
            tag.func_74768_a("c1", this.color1);
            tag.func_74768_a("c2", this.color2);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.pos1X = tag.func_74769_h("p1x");
            this.pos1Y = tag.func_74769_h("p1y");
            this.pos1Z = tag.func_74769_h("p1z");
            this.pos2X = tag.func_74769_h("p2x");
            this.pos2Y = tag.func_74769_h("p2y");
            this.pos2Z = tag.func_74769_h("p2z");
            this.speed = tag.func_74769_h("speed");
            this.color1 = tag.func_74762_e("c1");
            this.color2 = tag.func_74762_e("c2");
        }

        public void writeData(ByteBuf buf) {
            buf.writeDouble(this.pos1X);
            buf.writeDouble(this.pos1Y);
            buf.writeDouble(this.pos1Z);
            buf.writeDouble(this.pos2X);
            buf.writeDouble(this.pos2Y);
            buf.writeDouble(this.pos2Z);
            buf.writeDouble(this.speed);
            buf.writeInt(this.color1);
            buf.writeInt(this.color2);
        }

        public void readData(ByteBuf buf) {
            this.pos1X = buf.readDouble();
            this.pos1Y = buf.readDouble();
            this.pos1Z = buf.readDouble();
            this.pos2X = buf.readDouble();
            this.pos2Y = buf.readDouble();
            this.pos2Z = buf.readDouble();
            this.speed = buf.readDouble();
            this.color1 = buf.readInt();
            this.color2 = buf.readInt();
        }

        @SideOnly(value=Side.CLIENT)
        public Aurora createAurora() {
            return new Aurora(this.color1, this.color2, this.speed, this.pos1X, this.pos1Y, this.pos1Z, this.pos2X, this.pos2Y, this.pos2Z);
        }
    }
}

