/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ChromaConfig
extends ControlledConfig {
    private static final ArrayList<String> modTrees = ChromaConfig.getModTrees();
    private static final int treeLength = modTrees.size();
    private static final int vanillaTreeCount = ReikaTreeHelper.treeList.length;
    private final ControlledConfig.DataElement<Boolean>[] trees = new ControlledConfig.DataElement[treeLength + vanillaTreeCount];
    private ControlledConfig.DataElement<String[]> guardianExceptions;

    public ChromaConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        super(mod, option, id);
        String name;
        int i;
        for (i = 0; i < vanillaTreeCount; ++i) {
            name = ReikaTreeHelper.treeList[i].getName();
            this.trees[i] = this.registerAdditionalOption("Generate Vanilla Logs", name, true);
        }
        for (i = 0; i < treeLength; ++i) {
            name = modTrees.get(i);
            this.trees[i + ChromaConfig.vanillaTreeCount] = this.registerAdditionalOption("Generate Mod Logs", name, true);
        }
        this.guardianExceptions = this.registerAdditionalOption("Other Options", "Guardian Stone Exceptions", this.getDefaultGuardstoneExceptions());
    }

    private String[] getDefaultGuardstoneExceptions() {
        ArrayList<String> li = new ArrayList<String>();
        for (PlayerInteractEvent.Action a : PlayerInteractEvent.Action.values()) {
            li.add("none#" + a.name());
        }
        li.add(ModList.EXTRAUTILS.modLabel + ":dark_portal:2#" + PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK.name());
        return li.toArray(new String[li.size()]);
    }

    public ArrayList<String> getGuardianExceptions() {
        return ReikaJavaLibrary.makeListFromArray((Object[])((Object[])this.guardianExceptions.getData()));
    }

    private static ArrayList<String> getModTrees() {
        ArrayList base = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(ModWoodList.class);
        ArrayList<String> li = new ArrayList<String>();
        for (int i = 0; i < base.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            String sg = (String)base.get(i);
            if (sg.startsWith("BOP")) {
                sg = sg.substring(3);
                sb.append("Biomes O Plenty ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("BXL")) {
                sg = sg.substring(3);
                sb.append("ExtraBiomes XL ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("MFR")) {
                sg = sg.substring(3);
                sb.append("MineFactory Reloaded ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("IC2")) {
                sg = sg.substring(3);
                sb.append("IndustrialCraft ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else if (sg.startsWith("NATURA")) {
                sg = sg.substring(6);
                sb.append("Natura ");
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            } else {
                sb.append(ReikaStringParser.capFirstChar((String)sg));
            }
            li.add(sb.toString());
        }
        return li;
    }

    public boolean shouldGenerateLogType(ModWoodList tree) {
        return (Boolean)this.trees[tree.ordinal() + ReikaTreeHelper.treeList.length].getData();
    }

    public boolean shouldGenerateLogType(ReikaTreeHelper tree) {
        return (Boolean)this.trees[tree.ordinal()].getData();
    }
}

