/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.BlockChromaTiered;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Worldgen.ControllableOreVein;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.RotaryCraft.API.ItemFetcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTieredOre
extends BlockChromaTiered {
    public static final int ARR_LENGTH = 15;
    private final IIcon[] overlay = new IIcon[15];
    private final IIcon[] back = new IIcon[15];
    private final IIcon[] geode = new IIcon[15];
    private final IIcon[] geodestone = new IIcon[15];

    public BlockTieredOre(Material mat) {
        super(mat);
        this.func_149711_c(4.0f);
        this.func_149752_b(5.0f);
    }

    public void func_149666_a(Item item, CreativeTabs c, List li) {
        for (int i = 0; i < TieredOres.list.length; ++i) {
            li.add(new ItemStack(item, 1, i));
        }
    }

    public Collection<ItemStack> getHarvestResources(World world, int x, int y, int z, int fortune, EntityPlayer player) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        int n = 1;
        if (ItemFetcher.isPlayerHoldingBedrockPick((EntityPlayer)player)) {
            fortune = 5;
        }
        switch (TieredOres.list[world.func_72805_g(x, y, z)]) {
            case INFUSED: {
                n = Math.min(16, 1 + rand.nextInt(5) * (1 + rand.nextInt(1 + fortune)));
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.chromaDust.func_77946_l());
                }
                break;
            }
            case STONES: {
                n = Math.min(4, 1 + fortune / 2);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaItems.ELEMENTAL.getStackOfMetadata(rand.nextInt(16)));
                }
                break;
            }
            case BINDING: {
                n = Math.min(8, 1 + rand.nextInt(3) * (1 + rand.nextInt(1 + fortune / 2)));
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.bindingCrystal.func_77946_l());
                }
                break;
            }
            case FOCAL: {
                n = Math.min(32, 1 + rand.nextInt(6) * (1 + rand.nextInt(1 + fortune * 3 / 2)));
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.focusDust.func_77946_l());
                }
                break;
            }
            case TELEPORT: {
                n = Math.min(32, 1 + rand.nextInt(1 + fortune) + fortune * fortune / 2);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.enderDust.func_77946_l());
                }
                break;
            }
            case WATERY: {
                n = Math.min(32, 1 + rand.nextInt(6) + rand.nextInt(1 + 3 * fortune));
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.waterDust.func_77946_l());
                }
                break;
            }
            case FIRAXITE: {
                n = Math.min(32, 1 + rand.nextInt(8) + rand.nextInt(1 + fortune) * 4);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.firaxite.func_77946_l());
                }
                break;
            }
            case LUMA: {
                n = Math.min(32, (1 + fortune) * (1 + 4 * rand.nextInt(5)));
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.lumaDust.func_77946_l());
                }
                break;
            }
            case ECHO: {
                n = Math.min(32, (1 + fortune * fortune / 2) * (1 + rand.nextInt(8) + rand.nextInt(8)));
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.echoCrystal.func_77946_l());
                }
                break;
            }
            case FIRESTONE: {
                n = 1 + rand.nextInt(6) * (1 + fortune / 2);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.fireEssence.func_77946_l());
                }
                break;
            }
            case THERMITE: {
                n = 1 + rand.nextInt(1 + fortune * fortune);
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.thermiticCrystal.func_77946_l());
                }
                break;
            }
            case RESO: {
                n = 1 + fortune * 4;
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.resocrystal.func_77946_l());
                }
                break;
            }
            case SPACERIFT: {
                n = 1 + fortune + rand.nextInt(1 + fortune) * 3 / 2;
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.spaceDust.func_77946_l());
                }
                break;
            }
            case RAINBOW: {
                n = 1 + fortune + rand.nextInt(1 + fortune) / 2;
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.lumenGem.func_77946_l());
                }
                break;
            }
            case AVOLITE: {
                n = 1 + rand.nextInt(1 + fortune / 2) / 2;
                for (int i = 0; i < n; ++i) {
                    li.add(ChromaStacks.avolite.func_77946_l());
                }
                break;
            }
        }
        return li;
    }

    @Override
    public ProgressionManager.ProgressStage getProgressStage(int meta) {
        return TieredOres.list[meta].level;
    }

    public Collection<ItemStack> getNoHarvestResources(World world, int x, int y, int z, int fortune, EntityPlayer player) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        Block b = this.getDisguise(world.func_72805_g(x, y, z));
        ArrayList drops = b.getDrops(world, x, y, z, 0, fortune);
        if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            drops.clear();
            drops.add(new ItemStack(b));
        }
        li.addAll(drops);
        return li;
    }

    public void func_149651_a(IIconRegister ico) {
        int i;
        for (i = 0; i < 15; ++i) {
            String s = "chromaticraft:ore/tier_" + i;
            this.back[i] = ico.func_94245_a(s + "_underlay");
            this.overlay[i] = ico.func_94245_a(s + "_overlay");
            this.geode[i] = ico.func_94245_a(s + "_geode");
        }
        for (i = 0; i < this.geodestone.length; ++i) {
            this.geodestone[i] = ico.func_94245_a("chromaticraft:ore/geodestone/" + i);
        }
        this.field_149761_L = Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon getOverlay(int meta) {
        return this.overlay[meta];
    }

    public IIcon getBacking(int meta) {
        return TieredOres.list[meta].renderAsGeode() ? this.getGeodeIcon(meta) : this.back[meta];
    }

    public IIcon getGeodeIcon(int meta) {
        return this.geode[meta];
    }

    public IIcon getGeodeStoneIcon(int i) {
        return this.geodestone[i];
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.getBacking(meta);
    }

    public int func_149645_b() {
        return ChromaCommon.oreRender;
    }

    public Block getDisguise(int meta) {
        return TieredOres.list[meta].genBlock;
    }

    public boolean func_149646_a(IBlockAccess world, int dx, int dy, int dz, int s) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        Block b = world.func_147439_a(dx, dy, dz);
        if (b.func_149662_c()) {
            return false;
        }
        switch (dir) {
            default: 
        }
        return true;
    }

    @Override
    protected ItemStack getWailaDisguise(int meta) {
        return new ItemStack(TieredOres.list[meta].genBlock);
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer eff) {
        ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b, (int)0);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean addHitEffects(World world, MovingObjectPosition tg, EffectRenderer eff) {
        ReikaRenderHelper.spawnDropParticles((World)world, (int)tg.field_72311_b, (int)tg.field_72312_c, (int)tg.field_72309_d, (Block)Blocks.field_150348_b, (int)0, (int)1);
        return true;
    }

    public static enum TieredOres {
        INFUSED(Blocks.field_150348_b, ProgressionManager.ProgressStage.CRYSTALS, 1, 4, 12),
        STONES(Blocks.field_150348_b, ProgressionManager.ProgressStage.RUNEUSE, 1, 4, 8),
        BINDING(Blocks.field_150348_b, ProgressionManager.ProgressStage.CHARGE, 1, 4, 8),
        FOCAL(Blocks.field_150348_b, ProgressionManager.ProgressStage.MULTIBLOCK, 1, 4, 8),
        TELEPORT(Blocks.field_150348_b, ProgressionManager.ProgressStage.END, 1, 2, 8),
        WATERY(Blocks.field_150348_b, ProgressionManager.ProgressStage.OCEAN, 2, 2, 8),
        FIRAXITE(Blocks.field_150348_b, ProgressionManager.ProgressStage.NETHER, 1, 2, 8),
        LUMA(Blocks.field_150348_b, ProgressionManager.ProgressStage.STRUCTCOMPLETE, 1, 1, 8),
        ECHO(Blocks.field_150348_b, ProgressionManager.ProgressStage.CTM, 2, 1, 8),
        FIRESTONE(Blocks.field_150424_aL, ProgressionManager.ProgressStage.LINK, 1, 4, 16),
        THERMITE(Blocks.field_150424_aL, ProgressionManager.ProgressStage.END, 1, 4, 16),
        RESO(Blocks.field_150377_bs, ProgressionManager.ProgressStage.ABILITY, 1, 8, 8),
        SPACERIFT(Blocks.field_150377_bs, ProgressionManager.ProgressStage.KILLDRAGON, 1, 12, 8),
        RAINBOW(Blocks.field_150348_b, ProgressionManager.ProgressStage.USEENERGY, 1, 2, 8),
        AVOLITE(Blocks.field_150348_b, ProgressionManager.ProgressStage.POWERCRYSTAL, 2, 1, 18);

        public final ProgressionManager.ProgressStage level;
        public final Block genBlock;
        public final int veinSize;
        public final int veinCount;
        public final int genChance;
        public static final TieredOres[] list;

        private TieredOres(Block b, ProgressionManager.ProgressStage lvl, int gc, int vc, int vs) {
            this.level = lvl;
            this.genBlock = b;
            this.genChance = gc;
            this.veinCount = vc;
            this.veinSize = vs;
        }

        public boolean generate(World world, int x, int z, Random r) {
            int y;
            int n = this.ordinal() >= FIRESTONE.ordinal() ? r.nextInt(128) : (y = r.nextBoolean() ? r.nextInt(32) : r.nextInt(64));
            if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
                y = r.nextInt(200);
            }
            ControllableOreVein.BlockExcludingOreVein ore = new ControllableOreVein.BlockExcludingOreVein(ChromaBlocks.TIEREDORE.getBlockInstance(), this.ordinal(), this.veinSize, (BlockCheck)new BlockKey(ChromaBlocks.CLIFFSTONE.getBlockInstance()));
            ore.target = this.genBlock;
            return ore.func_76484_a(world, r, x, y, z);
        }

        public boolean renderAsGeode() {
            return this == BINDING || this == FOCAL || this == TELEPORT || this == FIRAXITE || this == THERMITE || this == SPACERIFT;
        }

        static {
            list = TieredOres.values();
        }
    }
}

