/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityChromaCrafter;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.Block.Submergeable;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockStructureShield
extends Block
implements SemiUnbreakable,
Submergeable {
    protected final IIcon[] icons = new IIcon[BlockType.list.length];
    public static IIcon upperConnectedIcon;
    public static IIcon centerConnectedIcon;
    public static IIcon lowerConnectedIcon;

    public BlockStructureShield(Material mat) {
        super(mat);
        this.func_149711_c(2.0f);
        this.func_149752_b(6000.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        this.field_149762_H = field_149769_e;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return BlockType.list[meta % 8].getLightValue();
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return BlockType.list[meta % 8].isTransparentToLight() ? 0 : 255;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149730_j() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta >= 8 && !BlockType.list[meta % 8].isMineable() ? -1.0f : super.func_149712_f(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (this.canBreakLitBlock(world, x, y, z, b)) {
            for (int i = 0; i < 6; ++i) {
                int dz;
                int dy;
                int dx;
                Block b2;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (this.isSideSolid((IBlockAccess)world, x, y, z, dir) || b != (b2 = world.func_147439_a(dx = x + dir.offsetX, dy = y + dir.offsetY, dz = z + dir.offsetZ)) || b.getLightValue((IBlockAccess)world, dx, dy, dz) <= 3) continue;
                ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)b2);
                ReikaWorldHelper.dropBlockAt((World)world, (int)dx, (int)dy, (int)dz, null);
                world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)dx, (int)dy, (int)dz, (String)"random.fizz");
            }
        }
    }

    private boolean canBreakLitBlock(World world, int x, int y, int z, Block b) {
        if (ReikaBlockHelper.isLiquid((Block)b)) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() || DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            int mz;
            if (b == ChromaBlocks.DOOR.getBlockInstance()) {
                return false;
            }
            if (b instanceof BlockStructureShield) {
                return false;
            }
            if (ChromaBlocks.getEntryByID(b) != null && ChromaBlocks.getEntryByID(b).isDimensionStructureBlock()) {
                return false;
            }
            if (b == ChromaBlocks.CRYSTAL.getBlockInstance()) {
                return false;
            }
            int mx = ChunkProviderChroma.getMonumentGenerator().getPosX();
            if (ReikaMathLibrary.py3d((double)(x - mx), (double)0.0, (double)(z - (mz = ChunkProviderChroma.getMonumentGenerator().getPosZ()))) < 100.0) {
                return false;
            }
        }
        return true;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta % 8];
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta % 8 == BlockType.GLASS.ordinal() && s > 1) {
            if (ChromaTiles.getTile(iba, x, y - 2, z) == ChromaTiles.CHROMACRAFTER && ((TileEntityChromaCrafter)iba.func_147438_o(x, y - 2, z)).hasStructure()) {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            if (ChromaTiles.getTile(iba, x, y - 1, z) == ChromaTiles.CHROMACRAFTER && ((TileEntityChromaCrafter)iba.func_147438_o(x, y - 1, z)).hasStructure()) {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
        }
        return this.func_149691_a(s, meta);
    }

    public int func_149692_a(int meta) {
        return meta % 8;
    }

    public Item func_149650_a(int meta, Random r, int fortune) {
        return super.func_149650_a(meta, r, fortune);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < BlockType.list.length; ++i) {
            this.icons[i] = ico.func_94245_a("chromaticraft:basic/shield_" + i);
        }
        upperConnectedIcon = ico.func_94245_a("chromaticraft:basic/shield_5b");
        centerConnectedIcon = ico.func_94245_a("chromaticraft:basic/shield_5c");
        lowerConnectedIcon = ico.func_94245_a("chromaticraft:basic/shield_5a");
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (BlockType.list[meta % 8].isOpaque(side)) {
            return true;
        }
        if (BlockType.list[meta % 8].isTransparent(side)) {
            return false;
        }
        return meta < 8;
    }

    public boolean func_149646_a(IBlockAccess world, int dx, int dy, int dz, int s) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        Block b = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx - dir.offsetX, dy - dir.offsetY, dz - dir.offsetZ);
        if (b.func_149662_c()) {
            return false;
        }
        if (b == this && world.func_72805_g(dx, dy, dz) == meta) {
            return false;
        }
        if (ChromaTiles.getTile(world, dx, dy, dz) == ChromaTiles.CHROMACRAFTER) {
            return false;
        }
        switch (dir) {
            default: 
        }
        return true;
    }

    public boolean isUnbreakable(World world, int x, int y, int z, int meta) {
        return meta >= 8 && !BlockType.list[meta % 8].isMineable();
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        super.func_149749_a(world, x, y, z, b, meta);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!(world.func_147439_a(dx, dy, dz) instanceof BlockTNT)) continue;
            world.func_147439_a(dx, dy, dz).func_149664_b(world, dx, dy, dz, 1);
            world.func_147468_f(dx, dy, dz);
        }
    }

    public boolean isSubmergeable(IBlockAccess iba, int x, int y, int z) {
        return true;
    }

    public static enum BlockType {
        CLOAK("Cloak"),
        STONE("Stone"),
        COBBLE("Cobble"),
        CRACK("Crack"),
        MOSS("Moss"),
        GLASS("Glass"),
        LIGHT("Light"),
        CRACKS("Cracks");

        public final String name;
        public final int metadata;
        public static final BlockType[] list;

        private BlockType(String s) {
            this.name = s;
            this.metadata = this.ordinal() + 8;
        }

        public boolean isOpaque(ForgeDirection side) {
            return this == STONE && side == ForgeDirection.UP;
        }

        public boolean isTransparent(ForgeDirection side) {
            return this == CRACK || this == GLASS || this == CRACKS;
        }

        public boolean isTransparentToLight() {
            return this == GLASS;
        }

        public int getLightValue() {
            return this == LIGHT ? 15 : 0;
        }

        public boolean isMineable() {
            return this == CRACK || this == CRACKS;
        }

        static {
            list = BlockType.values();
        }
    }
}

