/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.API.Event.StructureChestPopulationEvent;
import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.CarpenterBlockHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLootChest
extends BlockContainer {
    private static final Random rand = new Random();

    public BlockLootChest(Material mat) {
        super(mat);
        this.func_149711_c(6.0f);
        this.func_149752_b(60.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        float ret = super.func_149737_a(ep, world, x, y, z);
        return BlockLootChest.canOpen(world, x, y, z, ep) ? ret : -1.0f;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        ReikaItemHelper.dropInventory((World)world, (int)x, (int)y, (int)z);
        super.func_149749_a(world, x, y, z, b, meta);
    }

    public boolean removedByPlayer(World world, EntityPlayer ep, int x, int y, int z, boolean harvest) {
        BlockLootChest.onAccessed(world, x, y, z, ep, true);
        return super.removedByPlayer(world, ep, x, y, z, harvest);
    }

    private static void onAccessed(World world, int x, int y, int z, EntityPlayer ep, boolean b) {
        TileEntityLootChest te = (TileEntityLootChest)world.func_147438_o(x, y, z);
        if (BlockLootChest.canOpen(world, x, y, z, ep)) {
            for (ChromaResearchManager.ProgressElement e : te.triggers) {
                e.giveToPlayer(ep, true);
            }
        }
        te.opened = true;
        MinecraftForge.EVENT_BUS.post((Event)new LootChestAccessEvent(world, x, y, z, ep, b));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        if (world.field_72995_K) {
            return true;
        }
        if (DragonAPICore.debugtest && ep.field_71075_bZ.field_75098_d && ChromaItems.TOOL.matchWith(ep.func_71045_bC())) {
            int level = ep.func_70093_af() ? 2 : 0;
            String sg = level > 0 ? "pyramidJungleChest" : "dungeonChest";
            ChromaStructures.Structures str = level > 0 ? ChromaStructures.Structures.OCEAN : ChromaStructures.Structures.BURROW;
            ((TileEntityLootChest)world.func_147438_o(x, y, z)).populateChest(sg, str, level, rand);
            return true;
        }
        boolean open = BlockLootChest.canOpen(world, x, y, z, ep);
        BlockLootChest.onAccessed(world, x, y, z, ep, open);
        if (open) {
            ep.func_71007_a((IInventory)world.func_147438_o(x, y, z));
        } else {
            ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
        }
        return true;
    }

    public static boolean canOpen(World world, int x, int y, int z, EntityPlayer ep) {
        if (ep != null && ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityLootChest)) {
            return false;
        }
        if (world.func_72805_g(x, y, z) >= 8 || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) && !CarpenterBlockHandler.getInstance().isCarpenterBlock(world.func_147439_a(x, y + 1, z))) {
            return ep == null || ep.func_110124_au().equals(((TileEntityLootChest)te).placer);
        }
        return ep == null || ((TileEntityLootChest)te).func_70300_a(ep);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLootChest();
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess iba, int x, int y, int z, int p_149709_5_) {
        return ((TileEntityLootChest)iba.func_147438_o(x, y, z)).numPlayersUsing > 0 ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess iba, int x, int y, int z, int s) {
        return s == 1 ? this.func_149709_b(iba, x, y, z, s) : 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int s) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int meta) {
        return ChromaBlocks.STRUCTSHIELD.getBlockInstance().func_149691_a(s, BlockStructureShield.BlockType.STONE.metadata);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        world.func_72921_c(x, y, z, ChromaAux.get4SidedMetadataFromPlayerLook(e), 3);
        ((TileEntityLootChest)world.func_147438_o(x, y, z)).placer = e.func_110124_au();
    }

    public static void setMaxReach(World world, int x, int y, int z, double max) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityLootChest) {
            ((TileEntityLootChest)te).maxReachAccess = max;
        }
    }

    public static int getMeta(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 0;
            }
        }
        return -1;
    }

    public static final class TileEntityLootChest
    extends TileEntity
    implements ISidedInventory {
        protected ItemStack[] inv = new ItemStack[this.func_70302_i_()];
        private int numPlayersUsing = 0;
        public float prevLidAngle;
        public float lidAngle;
        private int ticksSinceSync;
        private double maxReachAccess = 8.0;
        private UUID placer;
        private boolean opened;
        private final Collection<ChromaResearchManager.ProgressElement> triggers = new HashSet<ChromaResearchManager.ProgressElement>();

        public void func_145845_h() {
            double d2;
            super.func_145845_h();
            ++this.ticksSinceSync;
            if (!this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
                this.numPlayersUsing = 0;
                double r = 5.0;
                List list = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - r), (double)((double)this.field_145848_d - r), (double)((double)this.field_145849_e - r), (double)((double)(this.field_145851_c + 1) + r), (double)((double)(this.field_145848_d + 1) + r), (double)((double)(this.field_145849_e + 1) + r)));
                for (EntityPlayer entityplayer : list) {
                    IInventory iinventory;
                    if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this) continue;
                    ++this.numPlayersUsing;
                }
            }
            this.prevLidAngle = this.lidAngle;
            float f = 0.1f;
            if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
                double d1 = (double)this.field_145851_c + 0.5;
                d2 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d2, "random.chestopen", 0.5f, 0.25f);
            }
            if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
                float f2;
                float f1 = this.lidAngle;
                this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                    d2 = (double)this.field_145851_c + 0.5;
                    double d0 = (double)this.field_145849_e + 0.5;
                    this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d0, "random.chestclosed", 0.5f, 0.25f);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        }

        public final ItemStack func_70301_a(int par1) {
            return this.inv[par1];
        }

        public final void func_70299_a(int par1, ItemStack is) {
            this.inv[par1] = is;
        }

        public void func_70295_k_() {
            ++this.numPlayersUsing;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        }

        public void func_70305_f() {
            --this.numPlayersUsing;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numPlayersUsing);
        }

        public final boolean func_145818_k_() {
            return true;
        }

        public final String func_145825_b() {
            return "Loot Chest";
        }

        public void func_70296_d() {
            this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            if (this.func_145838_q() != Blocks.field_150350_a) {
                this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }

        public boolean func_70300_a(EntityPlayer ep) {
            return ep.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= this.maxReachAccess;
        }

        public final ItemStack func_70298_a(int par1, int par2) {
            return ReikaInventoryHelper.decrStackSize((IInventory)this, (int)par1, (int)par2);
        }

        public final ItemStack func_70304_b(int par1) {
            return ReikaInventoryHelper.getStackInSlotOnClosing((IInventory)this, (int)par1);
        }

        public int func_70302_i_() {
            return 54;
        }

        public int func_70297_j_() {
            return 64;
        }

        public boolean func_94041_b(int slot, ItemStack is) {
            return true;
        }

        private boolean isUsable() {
            return BlockLootChest.canOpen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, null);
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBTTagList li = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                this.inv[i].func_77955_b(nbttagcompound);
                li.func_74742_a((NBTBase)nbttagcompound);
            }
            NBT.func_74782_a("Items", (NBTBase)li);
            NBT.func_74780_a("maxreach", this.maxReachAccess);
            li = new NBTTagList();
            for (ChromaResearchManager.ProgressElement e : this.triggers) {
                li.func_74742_a((NBTBase)new NBTTagInt(ChromaResearchManager.instance.getID(e)));
            }
            NBT.func_74782_a("flags", (NBTBase)li);
            if (this.placer != null) {
                NBT.func_74778_a("placer", this.placer.toString());
            }
            NBT.func_74757_a("opened", this.opened);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            NBTTagList li = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            this.inv = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < li.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = li.func_150305_b(i);
                byte byte0 = nbttagcompound.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.inv.length) continue;
                this.inv[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            }
            this.maxReachAccess = NBT.func_74769_h("maxreach");
            this.triggers.clear();
            li = NBT.func_150295_c("flags", ReikaNBTHelper.NBTTypes.INT.ID);
            for (NBTTagInt tag : li.field_74747_a) {
                this.triggers.add(ChromaResearchManager.instance.getProgressForID(tag.func_150287_d()));
            }
            if (NBT.func_74764_b("placer")) {
                this.placer = UUID.fromString(NBT.func_74779_i("placer"));
            }
            this.opened = NBT.func_74767_n("opened");
        }

        public boolean isUntouchedWorldgen() {
            return this.placer == null && !this.opened;
        }

        public boolean func_145842_c(int id, int data) {
            if (id == 1) {
                this.numPlayersUsing = data;
                return true;
            }
            return super.func_145842_c(id, data);
        }

        public void populateChest(String s, ChromaStructures.Structures struct, int bonus, Random r) {
            ReikaInventoryHelper.clearInventory((IInventory)this);
            WeightedRandomChestContent[] loot = ChestGenHooks.getItems((String)s, (Random)r);
            int count = 1 + ChestGenHooks.getCount((String)s, (Random)r);
            if (struct == ChromaStructures.Structures.BURROW) {
                count /= 2;
            }
            WeightedRandomChestContent.func_76293_a((Random)r, (WeightedRandomChestContent[])loot, (IInventory)this, (int)count);
            if (bonus > 0) {
                ReikaInventoryHelper.generateMultipliedLoot((int)bonus, (Random)r, (String)s, (IInventory)this);
            }
            int n1 = struct == ChromaStructures.Structures.BURROW ? 3 : 5;
            int n2 = 2;
            if (r.nextInt(n1) > 0) {
                ReikaInventoryHelper.addToIInv((Item)ChromaItems.FRAGMENT.getItemInstance(), (IInventory)this);
                if (r.nextInt(n2) == 0) {
                    ReikaInventoryHelper.addToIInv((Item)ChromaItems.FRAGMENT.getItemInstance(), (IInventory)this);
                }
            }
            StructureChestPopulationEvent evt = new StructureChestPopulationEvent(struct != null ? struct.name() : "No structure", s, r);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            for (ItemStack is : evt.getItems()) {
                ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)this);
            }
        }

        public void addProgress(ChromaResearchManager.ProgressElement e) {
            this.triggers.add(e);
        }

        public int[] func_94128_d(int side) {
            return this.isUsable() ? ReikaInventoryHelper.getWholeInventoryForISided((ISidedInventory)this) : new int[]{};
        }

        public boolean func_102007_a(int i, ItemStack is, int side) {
            return this.func_94041_b(i, is);
        }

        public boolean func_102008_b(int i, ItemStack is, int side) {
            return this.isUsable();
        }
    }

    public static final class LootChestAccessEvent
    extends Event {
        public final World world;
        public final int x;
        public final int y;
        public final int z;
        public final EntityPlayer player;
        public final boolean success;

        private LootChestAccessEvent(World world, int x, int y, int z, EntityPlayer ep, boolean b) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.player = ep;
            this.success = b;
        }
    }
}

