/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.LoadRegistry;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PlantDropManager;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockDecoFlower
extends Block
implements IShearable,
LoadRegistry {
    private final IIcon[] icons = new IIcon[Flowers.list.length];

    public BlockDecoFlower() {
        super(Material.field_151585_k);
        this.field_149762_H = field_149779_h;
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        this.func_149675_a(true);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return world.field_73012_v.nextInt(Flowers.list[meta].getDropChance()) == 0 ? ReikaJavaLibrary.makeListFrom((Object)Flowers.list[meta].getDrop()) : new ArrayList();
    }

    public int func_149645_b() {
        return ChromaCommon.flowerRender;
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ico.func_94245_a("chromaticraft:plant/flower_" + i);
        }
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta];
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        Flowers f = Flowers.list[iba.func_72805_g(x, y, z)];
        return f.isBiomeColored() ? iba.func_72807_a(x, z).func_150558_b(x, y, z) : 0xFFFFFF;
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        Flowers f = Flowers.list[iba.func_72805_g(x, y, z)];
        return f.getLightValue(iba, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        this.checkAndDropBlock(world, x, y, z);
    }

    private boolean checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return Flowers.list[world.func_72805_g(x, y, z)].canPlantAt(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        Flowers f = Flowers.list[world.func_72805_g(x, y, z)];
        switch (f) {
            case ENDERFLOWER: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.875f, 1.0f);
                break;
            }
            case RESOCLOVER: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
                break;
            }
            case SANOBLOOM: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            }
            case GLOWDAISY: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
                break;
            }
            case FLOWIVY: {
                float nx = 0.9375f;
                float nz = 0.9375f;
                float px = 0.0625f;
                float pz = 0.0625f;
                if (BlockDecoFlower.isIvySolid(world, x + 1, y, z, ForgeDirection.WEST)) {
                    px = 1.0f;
                    nz = 0.0f;
                    pz = 1.0f;
                }
                if (BlockDecoFlower.isIvySolid(world, x - 1, y, z, ForgeDirection.EAST)) {
                    nx = 0.0f;
                    nz = 0.0f;
                    pz = 1.0f;
                }
                if (BlockDecoFlower.isIvySolid(world, x, y, z + 1, ForgeDirection.NORTH)) {
                    pz = 1.0f;
                    nx = 0.0f;
                    px = 1.0f;
                }
                if (BlockDecoFlower.isIvySolid(world, x, y, z - 1, ForgeDirection.SOUTH)) {
                    nz = 0.0f;
                    nx = 0.0f;
                    px = 1.0f;
                }
                this.func_149676_a(nx, 0.0f, nz, px, 1.0f, pz);
                break;
            }
            case GLOWROOT: {
                this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isIvySolid(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        Block b = world.func_147439_a(x, y, z);
        return (b.func_149688_o() == Material.field_151576_e || ReikaBlockHelper.isFacade((Block)b)) && b.isSideSolid(world, x, y, z, dir);
    }

    public int func_149741_i(int meta) {
        Flowers f = Flowers.list[meta];
        return f.isBiomeColored() ? ColorizerGrass.func_77480_a((double)0.75, (double)1.0) : 0xFFFFFF;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!this.checkAndDropBlock(world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            Flowers f = Flowers.list[meta];
            Coordinate c = f.grow(world, x, y, z, this, rand);
            if (c != null) {
                c.setBlock(world, (Block)this, meta);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this, (float)1.0f, (float)1.0f);
                ReikaSoundHelper.playBreakSound((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (Block)this, (float)1.0f, (float)1.0f);
                ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)Block.func_149682_b((Block)this), (int)meta);
                ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (int)Block.func_149682_b((Block)this), (int)meta);
            } else {
                f.tick(world, x, y, z, rand);
            }
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random r) {
        Flowers.list[world.func_72805_g(x, y, z)].doParticles(world, x, y, z, r);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        int meta = world.func_72805_g(x, y, z);
        Flowers f = Flowers.list[meta];
        ItemStack is = new ItemStack((Block)this, 1, meta);
        if (world instanceof World && f == Flowers.VOIDREED) {
            int dy = y + 1;
            while (world.func_147439_a(x, dy, z) == this && world.func_72805_g(x, dy, z) == meta) {
                ++dy;
            }
            for (int i = dy - 1; i > y; --i) {
                ((World)world).func_147449_b(x, i, z, Blocks.field_150350_a);
                ReikaItemHelper.dropItem((World)((World)world), (double)((double)x + 0.5), (double)((double)i + 0.5), (double)((double)z + 0.5), (ItemStack)is);
            }
        }
        return ReikaJavaLibrary.makeListFrom((Object)is.func_77946_l());
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        ItemStack is = ep.func_71045_bC();
        if (is != null && is.func_77973_b() instanceof ItemShears) {
            return;
        }
        super.func_149636_a(world, ep, x, y, z, meta);
    }

    public int func_149692_a(int dmg) {
        return dmg;
    }

    @Override
    public void onLoad() {
        for (int i = 0; i < Flowers.list.length; ++i) {
            Flowers.list[i].registerDrops(this);
        }
    }

    public static enum Flowers {
        ENDERFLOWER,
        LUMALILY,
        RESOCLOVER,
        SANOBLOOM,
        VOIDREED,
        FLOWIVY,
        GLOWDAISY,
        GLOWROOT;

        public static final Flowers[] list;

        public int getLightValue(IBlockAccess iba, int x, int y, int z) {
            switch (this) {
                case GLOWDAISY: {
                    return ReikaWorldHelper.isAdjacentToCrop((IBlockAccess)iba, (int)x, (int)y, (int)z) ? 12 : 10;
                }
                case GLOWROOT: {
                    return 6;
                }
            }
            return 0;
        }

        private void registerDrops(BlockDecoFlower b) {
            PlantDropManager.instance.registerDrops(b, this.ordinal(), this.getDrop());
        }

        public boolean canGenerateIn(BiomeGenBase b) {
            switch (this) {
                case ENDERFLOWER: 
                case RESOCLOVER: {
                    return b == ChromatiCraft.enderforest;
                }
                case LUMALILY: {
                    return ReikaBiomeHelper.isSnowBiome((BiomeGenBase)b) && !(b instanceof BiomeGenHills) && b.field_76752_A == Blocks.field_150349_c;
                }
                case SANOBLOOM: {
                    return BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
                }
                case VOIDREED: {
                    return b.field_76756_M == ThaumIDHandler.Biomes.EERIE.getID() || b instanceof BiomeGenSwamp || b.getClass().getName().contains("BiomeGenBOPSwamp");
                }
                case FLOWIVY: {
                    return b instanceof BiomeGenHills || b.field_76748_D >= 1.0f && b.field_76752_A == Blocks.field_150349_c && !BiomeGlowingCliffs.isGlowingCliffs(b);
                }
                case GLOWDAISY: 
                case GLOWROOT: {
                    return BiomeGlowingCliffs.isGlowingCliffs(b);
                }
            }
            return false;
        }

        public boolean isBiomeColored() {
            switch (this) {
                case FLOWIVY: {
                    return true;
                }
            }
            return false;
        }

        public void tick(World world, int x, int y, int z, Random rand) {
            switch (this) {
                case ENDERFLOWER: {
                    break;
                }
                case FLOWIVY: {
                    break;
                }
                case GLOWDAISY: {
                    break;
                }
                case GLOWROOT: {
                    if (rand.nextInt(4) == 0) {
                        if (!world.func_72904_c(x - 16, y, z - 16, x + 16, y, z + 16)) break;
                        int meta = 0;
                        switch (rand.nextInt(20)) {
                            case 20: {
                                meta = 5;
                                break;
                            }
                            case 18: 
                            case 19: {
                                meta = 4;
                                break;
                            }
                            case 15: 
                            case 16: 
                            case 17: {
                                meta = 3;
                                break;
                            }
                            case 12: 
                            case 13: 
                            case 14: {
                                meta = 2;
                                break;
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                meta = 1;
                            }
                        }
                        ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)ChromaItems.FERTILITYSEED.getStackOfMetadata(meta));
                        break;
                    }
                }
                case LUMALILY: {
                    break;
                }
                case RESOCLOVER: {
                    break;
                }
                case SANOBLOOM: {
                    break;
                }
            }
        }

        public Coordinate grow(World world, int x, int y, int z, Block b, Random rand) {
            switch (this) {
                case ENDERFLOWER: 
                case SANOBLOOM: {
                    int ry;
                    int n;
                    int n2 = n = this.onActiveGrass(world, x, y, z) ? 8 : 32;
                    if (rand.nextInt(n) > 0) {
                        return null;
                    }
                    if (this == ENDERFLOWER && rand.nextInt(12) > 0) {
                        return null;
                    }
                    for (int i = 2; i < 6; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                        int dx = x + dir.offsetX;
                        int dz = z + dir.offsetZ;
                        if (!this.matchAt(world, dx, y, dz)) continue;
                        return null;
                    }
                    int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)4);
                    int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)4);
                    int oy = y;
                    for (ry = y; world.func_147439_a(rx, ry - 1, rz).isAir((IBlockAccess)world, rx, ry, rz) && ry > 0; --ry) {
                    }
                    if (Math.abs(oy - ry) <= 12 && world.func_147439_a(rx, ry, rz).isAir((IBlockAccess)world, rx, ry, rz) && this.canPlantAt(world, rx, ry, rz)) {
                        return new Coordinate(rx, ry, rz);
                    }
                    return null;
                }
                case RESOCLOVER: 
                case GLOWDAISY: 
                case LUMALILY: {
                    int n;
                    int n3 = n = this.onActiveGrass(world, x, y, z) ? 5 : 20;
                    if (this == LUMALILY) {
                        n *= 4;
                    }
                    if (this == GLOWDAISY) {
                        n *= 12;
                    }
                    int c = 0;
                    for (int i = 2; i < 6; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                        int dx = x + dir.offsetX;
                        int dz = z + dir.offsetZ;
                        if (!this.matchAt(world, dx, y, dz)) continue;
                        ++c;
                    }
                    if (c >= 2) {
                        return null;
                    }
                    if (c == 1 && rand.nextBoolean()) {
                        return null;
                    }
                    if (rand.nextInt(n) == 0) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[2 + rand.nextInt(4)];
                        int dx = x + dir.offsetX;
                        int dz = z + dir.offsetZ;
                        Block idb = world.func_147439_a(dx, y - 1, dz);
                        if (world.func_147439_a(dx, y, dz).isAir((IBlockAccess)world, dx, y, dz) && (idb == Blocks.field_150349_c || idb == Blocks.field_150346_d)) {
                            if (this == GLOWDAISY && world.func_72972_b(EnumSkyBlock.Sky, dx, y, dz) > 8) {
                                return null;
                            }
                            return new Coordinate(dx, y, dz);
                        }
                    }
                    return null;
                }
                case FLOWIVY: {
                    if (rand.nextInt(3) == 0) {
                        int dz;
                        int dy;
                        int dx;
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)];
                        if (dir == ForgeDirection.UP && rand.nextBoolean()) {
                            dir = ForgeDirection.VALID_DIRECTIONS[rand.nextInt(6)];
                        }
                        if (rand.nextInt(4) == 0) {
                            dir = ForgeDirection.DOWN;
                        }
                        if (world.func_147439_a(dx = x + dir.offsetX, dy = y + dir.offsetY, dz = z + dir.offsetZ).isAir((IBlockAccess)world, dx, dy, dz) && this.canPlantAt(world, dx, dy, dz)) {
                            return new Coordinate(dx, dy, dz);
                        }
                    }
                    return null;
                }
                case VOIDREED: {
                    int n;
                    int n4 = n = this.isChromaPool(world, x, y, z) ? 20 : 40;
                    if (this.onActiveGrass(world, x, y, z)) {
                        n = n * 3 / 4;
                    }
                    if (rand.nextInt(n) == 0 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z)) {
                        int h = 1;
                        int y2 = y - 1;
                        while (this.matchAt(world, x, y2, z)) {
                            --y2;
                            ++h;
                        }
                        if (h < rand.nextInt(7)) {
                            return new Coordinate(x, y + 1, z);
                        }
                    }
                    return null;
                }
                case GLOWROOT: {
                    if (rand.nextInt(36) == 0 && world.func_147439_a(x, y - 1, z).isAir((IBlockAccess)world, x, y - 1, z) && this.canPlantAt(world, x, y - 1, z) && world.func_147439_a(x, y - 2, z).isAir((IBlockAccess)world, x, y - 2, z)) {
                        return new Coordinate(x, y - 1, z);
                    }
                    return null;
                }
            }
            return null;
        }

        public boolean canPlantAt(World world, int x, int y, int z) {
            switch (this) {
                case FLOWIVY: {
                    for (int i = 2; i < 6; ++i) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                        Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                        if (b.func_149662_c() && b.func_149688_o() == Material.field_151576_e) {
                            return true;
                        }
                        if (!BlockDecoFlower.isIvySolid((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite())) continue;
                        return true;
                    }
                    return false;
                }
                case VOIDREED: {
                    return this.matchAt(world, x, y - 1, z) || this.isChromaPool(world, x, y, z) || ReikaPlantHelper.SUGARCANE.canPlantAt(world, x, y, z);
                }
                case ENDERFLOWER: 
                case RESOCLOVER: 
                case GLOWDAISY: 
                case LUMALILY: {
                    Block b = world.func_147439_a(x, y - 1, z);
                    return b == Blocks.field_150346_d || b == Blocks.field_150349_c;
                }
                case SANOBLOOM: {
                    return world.func_147439_a(x, y - 1, z) == Blocks.field_150362_t && world.func_72805_g(x, y - 1, z) % 4 == 3;
                }
                case GLOWROOT: {
                    return (this.matchAt(world, x, y + 1, z) || ReikaBlockHelper.isNaturalStone((World)world, (int)x, (int)(y + 1), (int)z) || ReikaBlockHelper.isDirtType((Block)world.func_147439_a(x, y + 1, z), (int)world.func_72805_g(x, y + 1, z))) && !this.isRootTooLong(world, x, y, z);
                }
            }
            return false;
        }

        private boolean isRootTooLong(World world, int x, int y, int z) {
            while (this.matchAt(world, x, y - 1, z)) {
                --y;
            }
            int l = 1;
            int dy = y;
            while (this.matchAt(world, x, dy + 1, z)) {
                ++dy;
                ++l;
            }
            if (l < 4) {
                return false;
            }
            dy = y;
            int sp = l;
            while (world.func_147439_a(x, dy - 1, z).isAir((IBlockAccess)world, x, dy - 1, z)) {
                --dy;
                ++sp;
            }
            return (double)l > (double)sp * 0.33;
        }

        private boolean isChromaPool(World world, int x, int y, int z) {
            Block idbelow = world.func_147439_a(x, y - 1, z);
            int metabelow = world.func_72805_g(x, y - 1, z);
            Material matbelow = ReikaWorldHelper.getMaterial((World)world, (int)x, (int)(y - 1), (int)z);
            if (idbelow != Blocks.field_150354_m && !ReikaBlockHelper.isDirtType((Block)idbelow, (int)metabelow)) {
                return false;
            }
            ForgeDirection liq = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)(y - 1), (int)z, (Block)ChromaBlocks.CHROMA.getBlockInstance(), (int)0);
            return liq != null && liq.offsetY == 0;
        }

        private boolean onActiveGrass(World world, int x, int y, int z) {
            while (world.func_147439_a(x, y, z) == ChromaBlocks.DECOFLOWER.getBlockInstance()) {
                --y;
            }
            if (world.func_147439_a(x, y, z) != Blocks.field_150349_c && world.func_147439_a(x, y, z) != Blocks.field_150362_t) {
                return false;
            }
            Block b = world.func_147439_a(x, y - 1, z);
            return b instanceof IFluidBlock && ((IFluidBlock)b).getFluid() == FluidRegistry.getFluid((String)"ender");
        }

        private boolean matchAt(World world, int x, int y, int z) {
            return world.func_147439_a(x, y, z) == ChromaBlocks.DECOFLOWER.getBlockInstance() && world.func_72805_g(x, y, z) == this.ordinal();
        }

        @SideOnly(value=Side.CLIENT)
        public void doParticles(World world, int x, int y, int z, Random r) {
            switch (this) {
                case ENDERFLOWER: {
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.25);
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.25);
                    double dy = (double)y + r.nextDouble();
                    int l = 20 + r.nextInt(60);
                    float s = 1.5f + r.nextFloat() * 2.0f;
                    float f = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.75, (double)0.125);
                    int c1 = 255;
                    int c2 = 2162592;
                    EntityBlurFX fx1 = new EntityBlurFX(world, dx, dy, dz).setLife(l).setScale(s * f).setColor(c1);
                    EntityBlurFX fx2 = new EntityBlurFX(world, dx, dy, dz).setLife(l).setScale(s).setColor(c2);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                    break;
                }
                case FLOWIVY: {
                    boolean flag;
                    boolean bl = flag = (x + y + z) % 6 == 0 && Minecraft.func_71410_x().field_71441_e.field_73012_v.nextBoolean();
                    if (!flag) {
                        ForgeDirection dir;
                        int i;
                        HashSet<ForgeDirection> solid = new HashSet<ForgeDirection>();
                        for (i = 0; i < 6; ++i) {
                            dir = ForgeDirection.VALID_DIRECTIONS[i];
                            if (world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).func_149688_o() != Material.field_151576_e) continue;
                            solid.add(dir);
                            solid.add(dir.getOpposite());
                        }
                        if (solid.size() < 6) {
                            for (i = 0; i < 6; ++i) {
                                dir = ForgeDirection.VALID_DIRECTIONS[i];
                                if (solid.contains(dir) || this.matchAt(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
                                flag = true;
                                break;
                            }
                        }
                    }
                    if (!flag) break;
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.5);
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.5);
                    double dy = (double)y + 0.5 + (double)(r.nextFloat() * 0.25f);
                    int l = 60 + r.nextInt(120);
                    float s = 1.0f + r.nextFloat() * 1.5f;
                    int c = ReikaColorAPI.mixColors((int)65280, (int)0xA0FFA0, (float)r.nextFloat());
                    EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(world, dx, dy, dz, 0.0, -90.0).setLife(l).setScale(s).setColor(c).setIcon(ChromaIcons.CENTER);
                    fx.angleVelocity = 0.25;
                    fx.freedom = 70.0;
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case LUMALILY: {
                    double dx = (double)x + 0.5;
                    double dz = (double)z + 0.5;
                    double dy = (double)y + 0.75;
                    int l = 30 + r.nextInt(30);
                    float s = 2.0f + r.nextFloat() * 2.0f;
                    int c = ReikaColorAPI.mixColors((int)255, (int)0xFFFFFF, (float)(0.5f + (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 1000.0))));
                    EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0).setLife(l).setScale(s).setColor(c).setGravity(-0.125f).setRapidExpand().setIcon(ChromaIcons.CENTER);
                    fx.angleVelocity = 0.5;
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case RESOCLOVER: {
                    int n = 1 + r.nextInt(2);
                    for (int i = 0; i < n; ++i) {
                        double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.5);
                        double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.5);
                        double dy = (double)y + 0.0625 * (double)r.nextFloat();
                        int l = 5;
                        float s = 0.75f;
                        int c = ReikaColorAPI.mixColors((int)255, (int)65280, (float)r.nextFloat());
                        EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz).setLife(l).setScale(s).setColor(c).setRapidExpand().setIcon(ChromaIcons.BIGFLARE);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case SANOBLOOM: {
                    double dx = (double)x + 0.5;
                    double dz = (double)z + 0.5;
                    double dy = (double)y + 0.125;
                    int l = 60 + r.nextInt(80);
                    float s = 2.0f + r.nextFloat() * 2.0f;
                    double[] v = ReikaPhysicsHelper.polarToCartesian((double)0.0625, (double)(r.nextDouble() * 70.0), (double)(r.nextDouble() * 360.0));
                    EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz, v[0], v[1], v[2]).setLife(l).setScale(s).setColor(0xFF0000).setRapidExpand().setNoSlowdown();
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
                case VOIDREED: {
                    float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
                    int l = 10 + r.nextInt(30);
                    float s = 1.0f + r.nextFloat() * 0.5f;
                    int c1 = 0xDF3FFF;
                    int c2 = 0x202020;
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.25);
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.25);
                    double dy = (double)y + r.nextDouble();
                    float f = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.6, (double)0.2);
                    EntityBlurFX fx1 = new EntityFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0).setScale(s).setLife(l).setColor(c1).setGravity(g).setBasicBlend().setIcon(ChromaIcons.TRANSFADE);
                    EntityBlurFX fx2 = new EntityFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0).setScale(s * f).setLife(l).setColor(c2).setGravity(g).setBasicBlend().setIcon(ChromaIcons.TRANSFADE).lockTo(fx1);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                    break;
                }
                case GLOWDAISY: {
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.625);
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.625);
                    double dy = (double)y + 0.125;
                    int c = ReikaColorAPI.mixColors((int)0x22AAFF, (int)255, (float)world.field_73012_v.nextFloat());
                    EntityBlurFX fx1 = new EntityFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0).setColor(c).setRapidExpand().setScale(1.5f).setIcon(ChromaIcons.FADE);
                    EntityBlurFX fx2 = new EntityFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0).setScale(0.875f).setRapidExpand().setColor(0xFFFFFF).setIcon(ChromaIcons.FADE).lockTo(fx1);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                    break;
                }
                case GLOWROOT: {
                    if (r.nextInt(3) != 0) break;
                    if (this.matchAt(world, x, y - 1, z) && y % 8 != 0) {
                        return;
                    }
                    double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.25);
                    double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.25);
                    double dy = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)0.5);
                    int c = 0xFFFFFF;
                    int rc = r.nextInt(3);
                    switch (rc) {
                        case 0: {
                            c = 13147380;
                            break;
                        }
                        case 1: {
                            c = 15899634;
                        }
                    }
                    EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz).setColor(c).setAlphaFading().setRapidExpand().setLife(120).setGravity(0.25f).setColliding();
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
            }
        }

        public int getGenerationChance() {
            switch (this) {
                case VOIDREED: {
                    return 4;
                }
                case ENDERFLOWER: {
                    return 4;
                }
                case RESOCLOVER: 
                case LUMALILY: {
                    return 2;
                }
                case SANOBLOOM: {
                    return 6;
                }
                case GLOWDAISY: {
                    return 2;
                }
                case GLOWROOT: {
                    return 1;
                }
            }
            return 1;
        }

        @SideOnly(value=Side.CLIENT)
        public void render(IBlockAccess world, int x, int y, int z, Block b, RenderBlocks rb, Tessellator v5) {
            IIcon ico = ((BlockDecoFlower)b).icons[this.ordinal()];
            v5.func_78378_d(b.func_149720_d(world, x, y, z));
            v5.func_78380_c(b.func_149677_c(world, x, y, z));
            switch (this) {
                case SANOBLOOM: 
                case LUMALILY: 
                case VOIDREED: {
                    ReikaRenderHelper.renderCrossTex((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (double)1.0);
                    break;
                }
                case RESOCLOVER: {
                    double d = 0.03125 + 0.015625 * Math.sin(x + y + z);
                    ReikaRenderHelper.renderFlatInnerTextureOnSide((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (ForgeDirection)ForgeDirection.DOWN, (double)d, (boolean)false);
                    break;
                }
                case FLOWIVY: {
                    double d = 0.03125 + 0.015625 * Math.sin(x + y + z);
                    for (int i = 1; i < 6; ++i) {
                        ReikaRenderHelper.renderFlatInnerTextureOnSide((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i], (double)0.03125, (boolean)true);
                    }
                    break;
                }
                case ENDERFLOWER: {
                    ReikaRenderHelper.renderCropTypeTex((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (double)0.1875, (double)1.0);
                    break;
                }
                case GLOWDAISY: {
                    ReikaRenderHelper.renderCropTypeTex((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (double)0.25, (double)1.0);
                    break;
                }
                case GLOWROOT: {
                    ReikaRenderHelper.renderCropTypeTex((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (double)0.1875, (double)1.0);
                }
            }
        }

        public ItemStack getDrop() {
            switch (this) {
                case ENDERFLOWER: {
                    return ChromaStacks.teleDust.func_77946_l();
                }
                case LUMALILY: {
                    return ChromaStacks.icyDust.func_77946_l();
                }
                case RESOCLOVER: {
                    return ChromaStacks.energyPowder.func_77946_l();
                }
                case SANOBLOOM: {
                    return ChromaStacks.etherBerries.func_77946_l();
                }
                case VOIDREED: {
                    return ChromaStacks.voidDust.func_77946_l();
                }
                case FLOWIVY: {
                    return ChromaStacks.livingEssence.func_77946_l();
                }
                case GLOWDAISY: {
                    return new ItemStack(Items.field_151114_aO);
                }
                case GLOWROOT: {
                    return new ItemStack(Items.field_151114_aO);
                }
            }
            return null;
        }

        public int getDropChance() {
            switch (this) {
                case ENDERFLOWER: 
                case RESOCLOVER: 
                case SANOBLOOM: 
                case FLOWIVY: 
                case LUMALILY: 
                case VOIDREED: {
                    return 1;
                }
                case GLOWDAISY: {
                    return 2;
                }
                case GLOWROOT: {
                    return 4;
                }
            }
            return 1;
        }

        public int getColor() {
            switch (this) {
                case ENDERFLOWER: {
                    return 16711900;
                }
                case LUMALILY: {
                    return 8697305;
                }
                case RESOCLOVER: {
                    return 15106047;
                }
                case SANOBLOOM: {
                    return 0xFF3F3F;
                }
                case VOIDREED: {
                    return 6312806;
                }
                case FLOWIVY: {
                    return 6732397;
                }
                case GLOWDAISY: {
                    return 5355263;
                }
                case GLOWROOT: {
                    return 12750837;
                }
            }
            return 0;
        }

        static {
            list = Flowers.values();
        }
    }
}

