/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Relay;

import Reika.ChromatiCraft.Block.Relay.BlockRelayBase;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockLumenRelay
extends BlockRelayBase
implements IWailaDataProvider {
    private final IIcon[][] icons = new IIcon[6][6];

    public BlockLumenRelay(Material mat) {
        super(mat);
    }

    public boolean canPlaceOn(World world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z).isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.VALID_DIRECTIONS[side]);
    }

    public void setSide(World world, int x, int y, int z, int side) {
        world.func_72921_c(x, y, z, side, 3);
    }

    public final void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:basic/relay");
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[meta];
        if (!this.canPlaceOn(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, meta)) {
            ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this);
            TileEntityLumenRelay te = (TileEntityLumenRelay)world.func_147438_o(x, y, z);
            ItemStack is = ChromaBlocks.RELAY.getStackOfMetadata(te.isMulti ? 16 : te.color.ordinal());
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        float xmin = 0.0f;
        float ymin = 0.0f;
        float zmin = 0.0f;
        float xmax = 1.0f;
        float ymax = 1.0f;
        float zmax = 1.0f;
        float h = 0.875f;
        float w = 0.125f;
        switch (ForgeDirection.VALID_DIRECTIONS[iba.func_72805_g(x, y, z)]) {
            case WEST: {
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                xmin = 1.0f - h;
                break;
            }
            case EAST: {
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                xmax = h;
                break;
            }
            case NORTH: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                zmin = 1.0f - h;
                break;
            }
            case SOUTH: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                zmax = h;
                break;
            }
            case UP: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymax = h;
                break;
            }
            case DOWN: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 1.0f - h;
                break;
            }
        }
        this.func_149676_a(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        TileEntityLumenRelay te = (TileEntityLumenRelay)world.func_147438_o(x, y, z);
        te.isMulti = is.func_77960_j() == 16;
        te.color = te.isMulti ? CrystalElement.WHITE : CrystalElement.elements[is.func_77960_j()];
        te.setInput(ForgeDirection.VALID_DIRECTIONS[world.func_72805_g(x, y, z)].getOpposite());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[meta];
        TileEntityLumenRelay te = (TileEntityLumenRelay)world.func_147438_o(x, y, z);
        CrystalElement e = te.isMulti() ? CrystalElement.randomElement() : te.getColor();
        double h = 0.25;
        if (dir.offsetX + dir.offsetY + dir.offsetZ < 0) {
            h -= 0.125;
        }
        double dx = (double)x + 0.5 + (double)dir.offsetX * h;
        double dy = (double)y + 0.5 + (double)dir.offsetY * h;
        double dz = (double)z + 0.5 + (double)dir.offsetZ * h;
        EntityCenterBlurFX fx = new EntityCenterBlurFX(e, world, dx, dy, dz, 0.0, 0.0, 0.0).setScale(2.0f + r.nextFloat() * 2.0f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityLumenRelay();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return !ep.field_71075_bZ.field_75098_d;
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityLumenRelay te = (TileEntityLumenRelay)world.func_147438_o(x, y, z);
        if (te != null) {
            ItemStack is = ChromaBlocks.RELAY.getStackOfMetadata(te.isMulti ? 16 : te.color.ordinal());
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
        }
    }

    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        TileEntityLumenRelay te = (TileEntityLumenRelay)acc.getTileEntity();
        int meta = te.isMulti ? 16 : te.color.ordinal();
        return ChromaBlocks.RELAY.getStackOfMetadata(meta);
    }

    public List<String> getWailaHead(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return tip;
    }

    public List<String> getWailaTail(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return tip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP ep, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public static class TileEntityLumenRelay
    extends BlockRelayBase.TileRelayBase {
        private CrystalElement color = CrystalElement.WHITE;
        private boolean isMulti = false;

        @Override
        public boolean canTransmit(CrystalElement e) {
            return this.isMulti || e == this.color;
        }

        public boolean isMulti() {
            return this.isMulti;
        }

        public CrystalElement getColor() {
            return this.color;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("multi", this.isMulti);
            NBT.func_74768_a("color", this.color.ordinal());
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.isMulti = NBT.func_74767_n("multi");
            this.color = CrystalElement.elements[NBT.func_74762_e("color")];
        }
    }
}

