/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Water;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.Lock;
import Reika.ChromatiCraft.World.Dimension.Structure.Water.WaterFloor;
import Reika.ChromatiCraft.World.Dimension.Structure.WaterPuzzleGenerator;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRotatingLock
extends Block {
    public BlockRotatingLock(Material mat) {
        super(mat);
        this.func_149752_b(6000.0f);
        this.func_149722_s();
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
    }

    public boolean hasTileEntity(int meta) {
        return meta == 0;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityRotatingLock();
    }

    public IIcon func_149691_a(int s, int meta) {
        return meta == 0 ? this.field_149761_L : ChromaIcons.TRANSPARENT.getIcon();
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:dimstruct/waterlock");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        if (this.hasTileEntity(world.func_72805_g(x, y, z))) {
            ((TileEntityRotatingLock)world.func_147438_o(x, y, z)).startRotating();
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block other) {
        super.func_149695_a(world, x, y, z, other);
        if (this.hasTileEntity(world.func_72805_g(x, y, z))) {
            ((TileEntityRotatingLock)world.func_147438_o(x, y, z)).updateHasFluidState();
        }
    }

    public static class TileEntityRotatingLock
    extends StructureBlockTile<WaterPuzzleGenerator> {
        private ForgeDirection direction = ForgeDirection.EAST;
        private int level;
        private int lockX;
        private int lockY;
        private boolean isCheckpoint;
        private Collection<ForgeDirection> openEndsAtZero = new HashSet<ForgeDirection>();
        private FilledBlockArray lockState;
        private int rotatingAmount;

        public void func_145845_h() {
            if (this.rotatingAmount > 0) {
                this.rotatingAmount = Math.min(this.rotatingAmount + 3, 90);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.rotatingAmount == 90) {
                    this.rotatingAmount = 0;
                    this.finishRotating();
                }
            }
        }

        private void updateHasFluidState() {
            WaterFloor f;
            WaterPuzzleGenerator gen = (WaterPuzzleGenerator)this.getGenerator();
            if (gen != null && (f = gen.getLevel(this.level)) != null) {
                boolean fluid = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == ChromaBlocks.EVERFLUID.getBlockInstance();
                f.updateFluid(this.field_145850_b, this.lockX, this.lockY, fluid);
            }
        }

        public ForgeDirection getDirection() {
            return this.direction != null ? this.direction : ForgeDirection.EAST;
        }

        public void setData(ForgeDirection dir, int lvl, int x, int y, boolean check, Collection<ForgeDirection> c) {
            this.direction = dir;
            this.level = lvl;
            this.lockX = x;
            this.lockY = y;
            this.openEndsAtZero = c;
            this.isCheckpoint = check;
        }

        public int getRotationProgress() {
            return this.rotatingAmount;
        }

        public boolean isCheckpoint() {
            return this.isCheckpoint;
        }

        private void startRotating() {
            int k;
            int i;
            if (this.rotatingAmount > 0) {
                return;
            }
            this.rotatingAmount = 1;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ChromaSounds.WATERLOCK.playSoundAtBlock(this, 2.0f, 1.0f);
            this.lockState = new FilledBlockArray(this.field_145850_b);
            for (i = -2; i <= 2; ++i) {
                for (k = -2; k <= 2; ++k) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + k) == ChromaBlocks.EVERFLUID.getBlockInstance()) {
                        this.field_145850_b.func_147449_b(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + k, Blocks.field_150350_a);
                    }
                    if (i == 0 && k == 0) continue;
                    this.lockState.addBlockCoordinate(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + k);
                }
            }
            for (i = -2; i <= 2; ++i) {
                for (k = -2; k <= 2; ++k) {
                    if (i == 0 && k == 0) continue;
                    Block b = this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + k);
                    if (b == Blocks.field_150350_a || b == ChromaBlocks.EVERFLUID.getBlockInstance()) {
                        this.field_145850_b.func_147465_d(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + k, this.func_145838_q(), 1, 3);
                    }
                    this.lockState.addBlockCoordinate(this.field_145851_c + i, this.field_145848_d + 1, this.field_145849_e + k);
                }
            }
            ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }

        private void finishRotating() {
            WaterFloor f;
            this.direction = ReikaDirectionHelper.getRightBy90((ForgeDirection)this.direction);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)Blocks.field_150348_b, (float)2.0f, (float)0.0f);
            WaterPuzzleGenerator gen = (WaterPuzzleGenerator)this.getGenerator();
            if (gen != null && (f = gen.getLevel(this.level)) != null) {
                f.rotateLock(this.lockX, this.lockY);
            }
            this.lockState = (FilledBlockArray)this.lockState.rotate90Degrees(this.field_145851_c, this.field_145849_e, false);
            this.lockState.place();
            ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }

        public HashSet<ForgeDirection> getSidesOfState(boolean open) {
            WaterFloor f;
            HashSet<ForgeDirection> set = new HashSet<ForgeDirection>();
            WaterPuzzleGenerator gen = (WaterPuzzleGenerator)this.getGenerator();
            if (gen != null && (f = gen.getLevel(this.level)) != null) {
                Lock l = f.getLock(this.lockX, this.lockY);
                for (int i = 2; i < 6; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    if (l.isDirectionOpen(dir) != open) continue;
                    set.add(dir);
                }
            }
            return set;
        }

        @SideOnly(value=Side.CLIENT)
        public Collection<ForgeDirection> getOpenEndsForRender() {
            ArrayList<ForgeDirection> ret = new ArrayList<ForgeDirection>();
            for (ForgeDirection dir : this.openEndsAtZero) {
                ForgeDirection ref = this.direction;
                while (ref != ForgeDirection.EAST) {
                    dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
                    ref = ReikaDirectionHelper.getRightBy90((ForgeDirection)ref);
                }
                ret.add(dir);
            }
            return ret;
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.WATER;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("dir", this.getDirection().ordinal());
            NBT.func_74768_a("lvl", this.level);
            NBT.func_74768_a("lockX", this.lockX);
            NBT.func_74768_a("lockY", this.lockY);
            NBT.func_74757_a("check", this.isCheckpoint);
            NBTTagList li = new NBTTagList();
            for (ForgeDirection dir : this.openEndsAtZero) {
                li.func_74742_a((NBTBase)new NBTTagInt(dir.ordinal()));
            }
            NBT.func_74782_a("ends", (NBTBase)li);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.direction = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("dir")];
            this.level = NBT.func_74762_e("lvl");
            this.lockX = NBT.func_74762_e("lockX");
            this.lockY = NBT.func_74762_e("lockY");
            this.isCheckpoint = NBT.func_74767_n("check");
            this.openEndsAtZero.clear();
            NBTTagList li = NBT.func_150295_c("ends", ReikaNBTHelper.NBTTypes.INT.ID);
            for (Object o : li.field_74747_a) {
                this.openEndsAtZero.add(ForgeDirection.VALID_DIRECTIONS[((NBTTagInt)o).func_150287_d()]);
            }
        }

        public double func_145833_n() {
            return super.func_145833_n() * 4.0;
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(2.0, 3.0, 2.0);
        }

        public boolean shouldRenderInPass(int pass) {
            return true;
        }
    }
}

