/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Water;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.WaterPuzzleGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEverFluid
extends BlockContainer {
    private int tickRate = 4;

    public BlockEverFluid(Material mat) {
        super(mat);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149675_a(true);
        this.func_149752_b(60000.0f);
        this.func_149649_H();
        if (DragonAPICore.isReikasComputer()) {
            this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        }
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = Blocks.field_150355_j.func_149691_a(0, 0);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityEverFluid();
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileEntityEverFluid te = (TileEntityEverFluid)world.func_147438_o(x, y, z);
        if (te != null && te.sourceLocation != null) {
            BlockArray b = new BlockArray();
            b.recursiveAdd(world, x, y, z, (Block)this);
            if (!b.hasBlock(((TileEntityEverFluid)te).sourceLocation.xCoord, ((TileEntityEverFluid)te).sourceLocation.yCoord, ((TileEntityEverFluid)te).sourceLocation.zCoord)) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
                if (world.func_147439_a(x, y - 1, z) == ChromaBlocks.WATERLOCK.getBlockInstance() && world.func_147439_a(x, y - 2, z) == this) {
                    world.func_147449_b(x, y - 2, z, Blocks.field_150350_a);
                }
            } else if (this.isSourceBlock((IBlockAccess)world, x, y, z) || this.isSourceBlock((IBlockAccess)world, te.sourceLocation)) {
                this.trySpread(world, x, y, z, te, rand);
            } else if (te.sourceLocation.getBlock(world) != this) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
        } else {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    private void trySpread(World world, int x, int y, int z, TileEntityEverFluid te, Random rand) {
        if (!this.flowIntoBlock(world, x, y, z, te, ForgeDirection.DOWN) && world.func_147439_a(x, y - 1, z) != this) {
            for (int i = 2; i < 6; ++i) {
                this.flowIntoBlock(world, x, y, z, te, ForgeDirection.VALID_DIRECTIONS[i]);
            }
        }
    }

    private boolean isSourceBlock(IBlockAccess world, Coordinate c) {
        return this.isSourceBlock(world, c.xCoord, c.yCoord, c.zCoord);
    }

    public boolean isSourceBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this && world.func_72805_g(x, y, z) == 0;
    }

    private boolean flowIntoBlock(World world, int x, int y, int z, TileEntityEverFluid src, ForgeDirection dir) {
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        this.tickRate = 3;
        boolean placeSource = false;
        if (dy > 0 && y > 0 && dir == ForgeDirection.DOWN && world.func_147439_a(x, y - 1, z) == ChromaBlocks.WATERLOCK.getBlockInstance()) {
            --dy;
            placeSource = true;
        }
        if (this.canFlowInto((IBlockAccess)world, dx, dy, dz, src)) {
            if (placeSource) {
                BlockEverFluid.placeSource(world, dx, dy, dz);
            } else {
                world.func_147465_d(dx, dy, dz, (Block)this, 1, 3);
                this.func_149726_b(world, dx, dy, dz);
            }
            TileEntityEverFluid te = (TileEntityEverFluid)world.func_147438_o(dx, dy, dz);
            if (!placeSource) {
                te.sourceLocation = src.sourceLocation;
            }
            te.uid = src.uid;
            te.level = placeSource ? src.level + 1 : src.level;
            return true;
        }
        return false;
    }

    private boolean canFlowInto(IBlockAccess world, int x, int y, int z, TileEntityEverFluid te) {
        if (y < 0) {
            return false;
        }
        if (world.func_147439_a(x, y, z).isAir(world, x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == this) {
            return false;
        }
        Material material = block.func_149688_o();
        return !material.func_76230_c() && material != Material.field_151586_h && material != Material.field_151587_i && material != Material.field_151567_E;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.tickRate);
        if (!(world.func_147438_o(x, y, z) instanceof TileEntityEverFluid)) {
            world.func_147455_a(x, y, z, (TileEntity)new TileEntityEverFluid());
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        world.func_147464_a(x, y, z, (Block)this, this.tickRate);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.canFlowInto((IBlockAccess)world, x, y, z, null);
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149738_a(World world) {
        return this.tickRate;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    public boolean func_149678_a(int meta, boolean fullHit) {
        return fullHit && meta == 0;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 10;
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return !block.func_149662_c();
        }
        return block.func_149688_o() == this.func_149688_o() ? false : super.func_149646_a(world, x, y, z, side);
    }

    public int func_149645_b() {
        return ChromaCommon.everfluidRender;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        super.func_149689_a(world, x, y, z, e, is);
        BlockEverFluid.placeSource(world, x, y, z);
    }

    public static void placeSource(World world, int x, int y, int z) {
        Block b = ChromaBlocks.EVERFLUID.getBlockInstance();
        if (world.func_147439_a(x, y, z) != b) {
            world.func_147449_b(x, y, z, b);
        }
        b.func_149726_b(world, x, y, z);
        ((TileEntityEverFluid)world.func_147438_o(x, y, z)).sourceLocation = new Coordinate(x, y, z);
    }

    public static class TileEntityEverFluid
    extends StructureBlockTile<WaterPuzzleGenerator> {
        private Coordinate sourceLocation;
        private int level;

        public boolean canUpdate() {
            return false;
        }

        public void setData(UUID id, int lvl) {
            this.uid = id;
            this.level = lvl;
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.sourceLocation != null) {
                this.sourceLocation.writeToNBT("loc", NBT);
            }
            NBT.func_74768_a("lvl", this.level);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.sourceLocation = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)NBT);
            this.level = NBT.func_74762_e("lvl");
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.WATER;
        }
    }
}

