/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Pinball;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Entity.EntityTNTPinball;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.World.Dimension.Structure.PinballGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPinballTile
extends BlockDimensionStructureTile {
    public BlockPinballTile(Material mat) {
        super(mat);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        PinballRerouteType e = PinballRerouteType.list[world.func_72805_g(x, y, z)];
        e.onInteract(world, x, y, z, ep);
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (PinballRerouteType.list[meta]) {
            case TARGET: {
                return new PinballTargetTile();
            }
            case FLIPFLOP: {
                return new FlipFlopTile();
            }
            case PAD: {
                return new TileBouncePad();
            }
        }
        return new PinballTile();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        PinballTile te = (PinballTile)iba.func_147438_o(x, y, z);
        return 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() && world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == PinballRerouteType.EMITTER.ordinal()) {
            PinballTile te = (PinballTile)world.func_147438_o(x, y, z);
            te.fire();
            return;
        }
    }

    public static class PinballTile
    extends StructureBlockTile<PinballGenerator> {
        protected ForgeDirection facing = ForgeDirection.NORTH;
        private boolean rotateable = true;
        protected String level = "none";

        public boolean canUpdate() {
            return false;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.facing = ForgeDirection.VALID_DIRECTIONS[tag.func_74762_e("dir")];
            this.rotateable = tag.func_74767_n("free");
            this.level = tag.func_74779_i("level");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("dir", this.facing.ordinal());
            tag.func_74757_a("free", this.rotateable);
            tag.func_74778_a("level", this.level);
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.PINBALL;
        }

        public ForgeDirection getFacing() {
            return this.facing;
        }

        public void rotate() {
            if (this.isRotateable() && !this.arePinballsInPlay()) {
                this.facing = ReikaDirectionHelper.getRightBy90((ForgeDirection)this.facing);
                ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.click", (float)0.4f, (float)0.5f);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        private boolean arePinballsInPlay() {
            PinballGenerator gen = (PinballGenerator)this.getGenerator();
            if (gen == null) {
                return false;
            }
            return gen.areBallsInPlay(this.level);
        }

        public boolean isRotateable() {
            return this.rotateable;
        }

        public void fire() {
            if (!this.field_145850_b.field_72995_K) {
                EntityTNTPinball ea = new EntityTNTPinball(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing, 0.125);
                this.field_145850_b.func_72838_d((Entity)ea);
            }
        }
    }

    public static class PinballTargetTile
    extends PinballTile {
        private boolean triggered = false;

        public boolean isTriggered() {
            return this.triggered;
        }

        public void trigger(boolean set, boolean doFX, boolean triggerCompletion) {
            PinballGenerator gen;
            this.triggered = set;
            if (doFX) {
                // empty if block
            }
            if (triggerCompletion && !this.field_145850_b.field_72995_K && (gen = (PinballGenerator)this.getGenerator()) != null) {
                gen.completeTrigger(this.level, this.field_145850_b, new Coordinate((TileEntity)this), set);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.triggered = tag.func_74767_n("trigger");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74757_a("trigger", this.triggered);
        }
    }

    public static class FlipFlopTile
    extends PinballTile {
        private boolean state;

        public boolean getState() {
            return this.state;
        }

        public void flip() {
            this.state = !this.state;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.click", (float)0.4f, (float)0.5f);
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.state = tag.func_74767_n("state");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74757_a("state", this.state);
        }
    }

    public static class TileBouncePad
    extends PinballTile {
        public int lightTick;

        @Override
        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (this.lightTick > 0) {
                --this.lightTick;
            }
        }

        public void onImpact(EntityTNTPinball e) {
            ChromaSounds.BOUNCE.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.lightTick = 8;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.lightTick = tag.func_74762_e("light");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("light", this.lightTick);
        }
    }

    public static enum PinballRerouteType {
        EMITTER,
        TARGET,
        PAD,
        FLIPFLOP,
        BRAKE,
        BOOSTER;

        public static final PinballRerouteType[] list;

        public boolean affectPulse(World world, int x, int y, int z, EntityTNTPinball e) {
            PinballTile te = (PinballTile)world.func_147438_o(x, y, z);
            if (te instanceof PinballTargetTile && (e.getDirection() == te.facing || this.isOmniDirectional())) {
                ((PinballTargetTile)te).trigger(true, true, true);
            }
            switch (this) {
                case EMITTER: {
                    return true;
                }
                case TARGET: {
                    return true;
                }
                case BOOSTER: {
                    e.setSpeed(0.5);
                    return false;
                }
                case BRAKE: {
                    return false;
                }
                case FLIPFLOP: {
                    FlipFlopTile f = (FlipFlopTile)te;
                    e.bounce(f.state);
                    f.flip();
                    return false;
                }
                case PAD: {
                    ((TileBouncePad)te).onImpact(e);
                    e.bounce(true);
                    return false;
                }
            }
            return false;
        }

        public boolean isOmniDirectional() {
            return false;
        }

        public void onInteract(World world, int x, int y, int z, EntityPlayer ep) {
            PinballTile te = (PinballTile)world.func_147438_o(x, y, z);
            if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
                ItemStack is = ep.func_71045_bC();
                if (!this.isOmniDirectional() && is != null && is.func_77973_b() == Items.field_151045_i) {
                    te.rotateable = !te.rotateable;
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (te instanceof PinballTargetTile && is != null && is.func_77973_b() == Items.field_151114_aO) {
                    ((PinballTargetTile)te).trigger(!((PinballTargetTile)te).isTriggered(), true, false);
                    return;
                }
                if (this == EMITTER && !ep.func_70093_af()) {
                    te.fire();
                    return;
                }
            }
            if (!this.isOmniDirectional()) {
                te.rotate();
            }
        }

        static {
            list = PinballRerouteType.values();
        }
    }
}

