/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.NonEuclid;

import Reika.ChromatiCraft.Base.BlockDimensionStructure;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclideanGenerator;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockTeleport
extends BlockDimensionStructure
implements IWailaDataProvider {
    private static boolean debug = ReikaObfuscationHelper.isDeObfEnvironment() && DragonAPICore.isReikasComputer();

    public BlockTeleport(Material mat) {
        super(mat);
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta == 0 ? new TileEntityTeleport() : null;
    }

    public boolean hasTileEntity(int meta) {
        return meta == 0;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149678_a(int meta, boolean boat) {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityTeleport te = this.getTileEntity(world, x, y, z);
        if (te instanceof TileEntityTeleport) {
            te.teleport(e);
        } else {
            ChromatiCraft.logger.logError((Object)("Teleport at " + x + "," + y + "," + z + " is null?!"));
        }
    }

    private TileEntityTeleport getTileEntity(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            return (TileEntityTeleport)world.func_147438_o(x, y, z);
        }
        StructuredBlockArray arr = new StructuredBlockArray(world);
        arr.recursiveAddWithBounds(world, x, y, z, (Block)this, x - 4, y - 4, z - 4, x + 4, y + 4, z + 4);
        int mx = arr.getMidX();
        int my = arr.getMinY();
        int mz = arr.getMidZ();
        Block b = world.func_147439_a(mx, my, mz);
        if (b == this) {
            return (TileEntityTeleport)world.func_147438_o(mx, my, mz);
        }
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return new ItemStack(Blocks.field_150350_a);
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaHead(ItemStack itemStack, List<String> tip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaBody(ItemStack itemStack, List<String> tip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaTail(ItemStack itemStack, List<String> tip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    private static void onTeleport(EntityPlayer ep, TileEntityTeleport te) {
        NonEuclideanGenerator g = (NonEuclideanGenerator)te.getGenerator();
        if (g == null) {
            ChromatiCraft.logger.logError((Object)("Teleport block @ " + te.field_145851_c + ", " + te.field_145848_d + ", " + te.field_145849_e + " has no strucure with ID=" + te.uid));
            ChromatiCraft.logger.log((Object)("Available Structures: " + DimensionStructureGenerator.DimensionStructureType.NONEUCLID.getUUIDs()));
            return;
        }
        for (Coordinate c : g.getPortalLocations()) {
            TileEntity tile = c.getTileEntity(te.field_145850_b);
            if (!(tile instanceof TileEntityTeleport) || tile.func_145837_r()) continue;
            ((TileEntityTeleport)tile).onPlayerTeleported(ep, te);
        }
    }

    public static class SameFacing
    implements TriggerCriteria {
        public static final SameFacing instance = new SameFacing();

        private SameFacing() {
        }

        @Override
        public boolean isValid(Entity e, TileEntityTeleport te) {
            if (e instanceof EntityLivingBase) {
                return ReikaEntityHelper.getDirectionFromEntityLook((EntityLivingBase)((EntityLivingBase)e), (boolean)false) == te.facing;
            }
            return true;
        }
    }

    public static interface TriggerCriteria {
        public boolean isValid(Entity var1, TileEntityTeleport var2);
    }

    public static class RerouteIf
    implements TeleportTriggerAction {
        private final BlockVector newDestination;

        public RerouteIf(BlockVector vec) {
            this.newDestination = vec;
        }

        @Override
        public void trigger(Coordinate c, TileEntityTeleport te) {
            te.removeAction(c);
            if (this.shouldReroute(te)) {
                te.destination = this.newDestination;
            }
        }

        private boolean shouldReroute(TileEntityTeleport te) {
            Collection c = te.getAllActions();
            if (c != null) {
                for (TeleportTriggerAction a : c) {
                    if (!(a instanceof RerouteIf)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class Reroute
    implements TeleportTriggerAction {
        private final BlockVector newDestination;

        public Reroute(BlockVector vec) {
            this.newDestination = vec;
        }

        @Override
        public void trigger(Coordinate c, TileEntityTeleport te) {
            te.destination = this.newDestination;
        }
    }

    public static class DeactivateOneOf
    implements TeleportTriggerAction {
        public static final DeactivateOneOf instance = new DeactivateOneOf();

        private DeactivateOneOf() {
        }

        @Override
        public void trigger(Coordinate c, TileEntityTeleport te) {
            te.removeAction(c);
            if (this.shouldDeactivate(te)) {
                te.isActive = false;
            }
        }

        private boolean shouldDeactivate(TileEntityTeleport te) {
            Collection c = te.getAllActions();
            if (c != null) {
                for (TeleportTriggerAction a : c) {
                    if (!(a instanceof DeactivateOneOf)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class Deactivate
    implements TeleportTriggerAction {
        public static final Deactivate instance = new Deactivate();

        private Deactivate() {
        }

        @Override
        public void trigger(Coordinate c, TileEntityTeleport te) {
            te.isActive = false;
        }
    }

    public static class Activate
    implements TeleportTriggerAction {
        public static final Activate instance = new Activate();

        private Activate() {
        }

        @Override
        public void trigger(Coordinate c, TileEntityTeleport te) {
            te.isActive = true;
        }
    }

    public static interface TeleportTriggerAction {
        public void trigger(Coordinate var1, TileEntityTeleport var2);
    }

    public static class TileEntityTeleport
    extends StructureBlockTile<NonEuclideanGenerator> {
        public BlockVector destination;
        public ForgeDirection facing;
        private long lastActiveTick = -1L;
        public boolean isActive = true;

        public boolean canUpdate() {
            return false;
        }

        private void teleport(Entity e) {
            long time;
            Collection<TriggerCriteria> criteria;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (!this.isActive) {
                return;
            }
            if (this.destination == null) {
                if (debug) {
                    ChromatiCraft.logger.logError((Object)("Could not teleport " + e + "; null destination!"));
                }
                return;
            }
            NonEuclideanGenerator g = (NonEuclideanGenerator)this.getGenerator();
            if (g != null && (criteria = g.getCriteria(this.field_145851_c, this.field_145848_d, this.field_145849_e)) != null) {
                for (TriggerCriteria c : criteria) {
                    if (c.isValid(e, this)) continue;
                    return;
                }
            }
            if ((time = this.field_145850_b.func_82737_E()) <= this.lastActiveTick) {
                return;
            }
            this.lastActiveTick = time;
            if (this.destination.xCoord != 0 || this.destination.yCoord != 0 || this.destination.zCoord != 0) {
                ReikaEntityHelper.seamlessTeleport((Entity)e, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)(this.field_145851_c + this.destination.xCoord), (int)(this.field_145848_d + this.destination.yCoord), (int)(this.field_145849_e + this.destination.zCoord), (ForgeDirection)this.facing, (ForgeDirection)this.destination.direction);
            }
            if (e instanceof EntityPlayer) {
                BlockTeleport.onTeleport((EntityPlayer)e, this);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void setRenderPos(EntityPlayer ep) {
            RenderManager rm = RenderManager.field_78727_a;
            if (ep.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                rm.func_147938_a(rm.field_78722_g, rm.field_78724_e, Minecraft.func_71410_x().field_71466_p, (EntityLivingBase)ep, rm.field_147941_i, rm.field_78733_k, 0.0f);
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.facing != null) {
                NBT.func_74768_a("face", this.facing.ordinal());
            }
            if (this.destination != null) {
                NBTTagCompound tag = new NBTTagCompound();
                this.destination.writeToNBT(tag);
                NBT.func_74782_a("pos", (NBTBase)tag);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.facing = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("face")];
            NBTTagCompound tag = NBT.func_74775_l("pos");
            this.destination = BlockVector.readFromNBT((NBTTagCompound)tag);
        }

        private void onPlayerTeleported(EntityPlayer ep, TileEntityTeleport te) {
            Coordinate rel;
            TeleportTriggerAction a;
            HashMap<Coordinate, TeleportTriggerAction> actions = ((NonEuclideanGenerator)this.getGenerator()).getActions(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (actions != null && !actions.isEmpty() && (a = actions.get(rel = new Coordinate((TileEntity)te).offset(-this.field_145851_c, -this.field_145848_d, -this.field_145849_e))) != null) {
                a.trigger(rel, this);
            }
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.NONEUCLID;
        }

        private void removeAction(Coordinate c) {
            ((NonEuclideanGenerator)this.getGenerator()).removeAction(this.field_145851_c, this.field_145848_d, this.field_145849_e, c);
        }

        private Collection<TeleportTriggerAction> getAllActions() {
            HashMap<Coordinate, TeleportTriggerAction> actions = ((NonEuclideanGenerator)this.getGenerator()).getActions(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return actions != null ? actions.values() : null;
        }
    }
}

