/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Laser;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.Entity.EntityLaserPulse;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.ISBRH.LaserEffectorRenderer;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.World.Dimension.Structure.LaserPuzzleGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaserEffector
extends BlockDimensionStructureTile {
    public BlockLaserEffector(Material mat) {
        super(mat);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        LaserEffectType e = LaserEffectType.list[world.func_72805_g(x, y, z)];
        e.onInteract(world, x, y, z, ep);
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (LaserEffectType.list[meta]) {
            case PRISM: {
                return new PrismTile();
            }
            case TARGET: 
            case TARGET_THRU: {
                return new TargetTile();
            }
        }
        return new LaserEffectTile();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        LaserEffectorRenderer.renderPass = pass;
        return pass <= 1;
    }

    public int func_149645_b() {
        return ChromaCommon.lasereffectRender;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        LaserEffectTile te = (LaserEffectTile)iba.func_147438_o(x, y, z);
        return te instanceof TargetTile && ((TargetTile)te).isTriggered() ? (ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)te.getRenderColor(), (int)15) : 15) : 2;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() && world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == LaserEffectType.EMITTER.ordinal()) {
            LaserEffectTile te = (LaserEffectTile)world.func_147438_o(x, y, z);
            te.fire();
            return;
        }
    }

    public static class ColorData {
        public boolean red;
        public boolean green;
        public boolean blue;

        public ColorData(boolean on) {
            this(on, on, on);
        }

        public ColorData(boolean red, boolean green, boolean blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void intersect(ColorData dat) {
            this.red = this.red && dat.red;
            this.green = this.green && dat.green;
            this.blue = this.blue && dat.blue;
        }

        public void add(ColorData dat) {
            this.red = this.red || dat.red;
            this.green = this.green || dat.green;
            this.blue = this.blue || dat.blue;
        }

        public boolean isBlack() {
            return !this.red && !this.green && !this.blue;
        }

        public boolean matchColor(ColorData o) {
            return o.red == this.red && o.green == this.green && o.blue == this.blue;
        }

        public int getRenderColor() {
            return ReikaColorAPI.RGBtoHex((int)(this.red ? 255 : 0), (int)(this.green ? 255 : 0), (int)(this.blue ? 255 : 0));
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.red = tag.func_74767_n("red");
            this.green = tag.func_74767_n("green");
            this.blue = tag.func_74767_n("blue");
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74757_a("red", this.red);
            tag.func_74757_a("green", this.green);
            tag.func_74757_a("blue", this.blue);
        }

        public void writeBuf(ByteBuf data) {
            data.writeBoolean(this.red);
            data.writeBoolean(this.green);
            data.writeBoolean(this.blue);
        }

        public void readBuf(ByteBuf data) {
            this.red = data.readBoolean();
            this.green = data.readBoolean();
            this.blue = data.readBoolean();
        }

        public boolean equals(Object o) {
            return o instanceof ColorData && this.matchColor((ColorData)o);
        }

        public int hashCode() {
            return this.getRenderColor();
        }

        public ColorData copy() {
            return new ColorData(this.red, this.green, this.blue);
        }

        public String toString() {
            return this.red + "/" + this.green + "/" + this.blue + " : " + Integer.toHexString(this.getRenderColor() & 0xFFFFFF);
        }
    }

    public static class LaserEffectTile
    extends StructureBlockTile<LaserPuzzleGenerator> {
        protected ReikaDirectionHelper.CubeDirections facing = ReikaDirectionHelper.CubeDirections.NORTH;
        protected ColorData color = new ColorData(true);
        private boolean rotateable = true;
        private boolean fixed = false;
        private int rotateableDifficulty = 0;
        protected String level = "none";
        public static final boolean PARTIAL_ROTATEABILITY = false;

        public boolean canUpdate() {
            return false;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.color = new ColorData(true);
            this.color.readFromNBT(tag);
            this.facing = ReikaDirectionHelper.CubeDirections.list[tag.func_74762_e("dir")];
            this.rotateable = tag.func_74767_n("free");
            this.fixed = tag.func_74767_n("fixed");
            this.rotateableDifficulty = tag.func_74762_e("mindiff");
            this.level = tag.func_74779_i("level");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            this.color.writeToNBT(tag);
            tag.func_74768_a("dir", this.facing.ordinal());
            tag.func_74757_a("free", this.rotateable);
            tag.func_74757_a("fixed", this.fixed);
            tag.func_74768_a("mindiff", this.rotateableDifficulty);
            tag.func_74778_a("level", this.level);
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.LASER;
        }

        public ReikaDirectionHelper.CubeDirections getFacing() {
            return this.facing;
        }

        public int getRenderColor() {
            return this.color.getRenderColor();
        }

        public void rotate() {
            if (this.isRotateable() && !this.areLasersInPlay()) {
                this.facing = this.facing.getRotation(true);
                ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.click", (float)0.4f, (float)0.5f);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        private boolean areLasersInPlay() {
            LaserPuzzleGenerator gen = (LaserPuzzleGenerator)this.getGenerator();
            if (gen == null) {
                return false;
            }
            return gen.areLasersInPlay(this.level);
        }

        public boolean isRotateable() {
            if (this.rotateableDifficulty > 0 && ChromaOptions.getStructureDifficulty() < this.rotateableDifficulty) {
                return false;
            }
            return !(this instanceof TargetTile) && this.func_145832_p() != LaserEffectType.EMITTER.ordinal() && !this.fixed;
        }

        public void fire() {
            if (!this.field_145850_b.field_72995_K) {
                EntityLaserPulse ea = new EntityLaserPulse(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing, this.color, this.level);
                this.field_145850_b.func_72838_d((Entity)ea);
            }
        }
    }

    public static class PrismTile
    extends LaserEffectTile {
        private ColorData nextPulse = new ColorData(false);
        private int timer;
        private int timerLength = 2;

        public void addPulse(ColorData dat) {
            this.nextPulse.add(dat);
            this.timer = this.timerLength;
        }

        public void func_145845_h() {
            --this.timer;
            if (this.timer == 0 && !this.nextPulse.isBlack()) {
                EntityLaserPulse e = new EntityLaserPulse(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing, this.nextPulse, this.level);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)e);
                }
                this.nextPulse = new ColorData(false);
            }
        }

        @Override
        public boolean canUpdate() {
            return true;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.timerLength = tag.func_74762_e("timer");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("timer", this.timerLength);
        }
    }

    public static class TargetTile
    extends LaserEffectTile {
        private boolean triggered = false;

        public boolean isTriggered() {
            return this.triggered;
        }

        public void trigger(boolean set, boolean doFX, boolean triggerCompletion) {
            LaserPuzzleGenerator gen;
            this.triggered = set;
            if (doFX) {
                if (set) {
                    ChromaSounds.CAST.playSoundAtBlock(this);
                    if (this.field_145850_b.field_72995_K) {
                        this.doFXClient();
                    }
                } else {
                    ChromaSounds.ERROR.playSoundAtBlock(this);
                }
            }
            if (triggerCompletion && !this.field_145850_b.field_72995_K && (gen = (LaserPuzzleGenerator)this.getGenerator()) != null) {
                gen.completeTrigger(this.level, this.field_145850_b, new Coordinate((TileEntity)this), set);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @SideOnly(value=Side.CLIENT)
        private void doFXClient() {
            for (int i = 0; i < 32; ++i) {
                double x = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145851_c + 0.5), (double)0.75);
                double y = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145848_d + 0.5), (double)0.5);
                double z = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145849_e + 0.5), (double)0.75);
                int l = ReikaRandomHelper.getRandomBetween((int)8, (int)30);
                EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, x, y, z).setColor(this.getRenderColor()).setLife(l);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.triggered = tag.func_74767_n("trigger");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74757_a("trigger", this.triggered);
        }
    }

    public static enum LaserEffectType {
        EMITTER,
        TARGET,
        TARGET_THRU,
        MIRROR,
        DOUBLEMIRROR,
        SLITMIRROR,
        REFRACTOR,
        ONEWAY,
        SPLITTER,
        PRISM,
        COLORIZER,
        POLARIZER;

        public static final LaserEffectType[] list;

        public boolean affectPulse(World world, int x, int y, int z, EntityLaserPulse e) {
            LaserEffectTile te = (LaserEffectTile)world.func_147438_o(x, y, z);
            if (te instanceof TargetTile && e.color.matchColor(te.color) && (e.direction == te.facing || this.isOmniDirectional())) {
                ((TargetTile)te).trigger(true, true, true);
            }
            switch (this) {
                case COLORIZER: {
                    e.color.intersect(te.color);
                    return e.color.isBlack();
                }
                case EMITTER: {
                    return true;
                }
                case MIRROR: {
                    if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)3, (int)5, (int)Math.abs(e.direction.ordinal() - te.facing.ordinal()))) {
                        return true;
                    }
                    e.reflect(te.facing);
                    EntityLaserPulse eb = new EntityLaserPulse(world, x, y, z, e.direction, e.color, e.getLevel());
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)eb);
                    }
                    return true;
                }
                case DOUBLEMIRROR: {
                    ReikaDirectionHelper.CubeDirections dir1 = e.direction.getRotation(true, 2);
                    if (dir1 == te.facing || dir1 == te.facing.getOpposite()) {
                        return true;
                    }
                    ReikaDirectionHelper.CubeDirections dir = te.facing;
                    if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)2, (int)6, (int)Math.abs(e.direction.ordinal() - te.facing.ordinal()))) {
                        dir = dir.getOpposite();
                    }
                    e.reflect(dir);
                    EntityLaserPulse eb = new EntityLaserPulse(world, x, y, z, e.direction, e.color, e.getLevel());
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)eb);
                    }
                    return true;
                }
                case SLITMIRROR: {
                    ReikaDirectionHelper.CubeDirections dir = e.direction.getRotation(true, 2);
                    if (dir != te.facing && dir != te.facing.getOpposite()) {
                        return DOUBLEMIRROR.affectPulse(world, x, y, z, e);
                    }
                    return false;
                }
                case ONEWAY: {
                    return e.direction != te.facing;
                }
                case POLARIZER: {
                    return e.direction != te.facing && e.direction != te.facing.getOpposite();
                }
                case PRISM: {
                    EntityLaserPulse e3;
                    if (e.direction != te.facing.getOpposite()) {
                        boolean b1 = e.direction == te.facing.getRotation(true, 2);
                        boolean b2 = e.direction == te.facing;
                        boolean b3 = e.direction == te.facing.getRotation(false, 2);
                        ColorData dat = new ColorData(e.color.red && b1, e.color.green && b2, e.color.blue && b3);
                        ((PrismTile)te).addPulse(dat);
                        return true;
                    }
                    EntityLaserPulse e1 = e.color.red ? new EntityLaserPulse(world, x, y, z, e.direction.getRotation(true, 2), new ColorData(true, false, false), e.getLevel()) : null;
                    EntityLaserPulse e2 = e.color.green ? new EntityLaserPulse(world, x, y, z, e.direction, new ColorData(false, true, false), e.getLevel()) : null;
                    EntityLaserPulse entityLaserPulse = e3 = e.color.blue ? new EntityLaserPulse(world, x, y, z, e.direction.getRotation(false, 2), new ColorData(false, false, true), e.getLevel()) : null;
                    if (!world.field_72995_K) {
                        if (e1 != null) {
                            world.func_72838_d((Entity)e1);
                        }
                        if (e2 != null) {
                            world.func_72838_d((Entity)e2);
                        }
                        if (e3 != null) {
                            world.func_72838_d((Entity)e3);
                        }
                    }
                    return true;
                }
                case REFRACTOR: {
                    int d = (int)MathHelper.func_76138_g((double)(e.direction.angle - te.facing.angle));
                    if (d == 90) {
                        e.refract(false);
                    } else if (d == -45) {
                        e.refract(true);
                    } else {
                        return true;
                    }
                    return false;
                }
                case SPLITTER: {
                    if (e.direction == te.facing) {
                        EntityLaserPulse e1 = new EntityLaserPulse(world, x, y, z, e.direction.getRotation(true), e.color, e.getLevel());
                        EntityLaserPulse e2 = new EntityLaserPulse(world, x, y, z, e.direction.getRotation(false), e.color, e.getLevel());
                        if (!world.field_72995_K) {
                            world.func_72838_d((Entity)e1);
                            world.func_72838_d((Entity)e2);
                        }
                    } else if (e.direction == te.facing.getOpposite().getRotation(true) || e.direction == te.facing.getOpposite().getRotation(false)) {
                        e.setDirection(te.facing.getOpposite(), true);
                        return false;
                    }
                    return true;
                }
                case TARGET: {
                    return true;
                }
                case TARGET_THRU: {
                    return false;
                }
            }
            return false;
        }

        public boolean isOmniDirectional() {
            return this == TARGET_THRU || this == COLORIZER;
        }

        public void onInteract(World world, int x, int y, int z, EntityPlayer ep) {
            LaserEffectTile te = (LaserEffectTile)world.func_147438_o(x, y, z);
            if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
                ItemStack is = ep.func_71045_bC();
                if (ChromaItems.SHARD.matchWith(is)) {
                    int dmg = is.func_77960_j() % 16;
                    if (dmg == CrystalElement.RED.ordinal()) {
                        te.color.red = !te.color.red;
                    } else if (dmg == CrystalElement.GREEN.ordinal()) {
                        te.color.green = !te.color.green;
                    } else if (dmg == CrystalElement.BLUE.ordinal()) {
                        te.color.blue = !te.color.blue;
                    }
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (!this.isOmniDirectional() && is != null && is.func_77973_b() == Items.field_151045_i) {
                    te.rotateable = !te.rotateable;
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (te instanceof TargetTile && is != null && is.func_77973_b() == Items.field_151114_aO) {
                    ((TargetTile)te).trigger(!((TargetTile)te).isTriggered(), true, false);
                    return;
                }
                if (te instanceof PrismTile && is != null && is.func_77973_b() == Items.field_151166_bC) {
                    ((PrismTile)te).timer++;
                    return;
                }
                if (this == EMITTER && !ep.func_70093_af()) {
                    te.fire();
                    return;
                }
            }
            if (!this.isOmniDirectional() && !world.field_72995_K) {
                te.rotate();
            }
        }

        static {
            list = LaserEffectType.values();
        }
    }
}

