/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Gravity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.Linkable;
import Reika.ChromatiCraft.Auxiliary.Recharger;
import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Entity.EntityLumaBurst;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.PulsingRadius;
import Reika.ChromatiCraft.World.Dimension.Structure.GravityPuzzleGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGravityTile
extends BlockDimensionStructureTile {
    private static IIcon overlay;
    private static IIcon underlay;

    public BlockGravityTile(Material mat) {
        super(mat);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IIcon func_149691_a(int s, int meta) {
        return s == 1 ? this.field_149761_L : Blocks.field_150339_S.func_149691_a(s, meta);
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return s == 1 ? underlay : Blocks.field_150339_S.func_149691_a(s, iba.func_72805_g(x, y, z));
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:dimstruct/gravity_sum");
        underlay = ico.func_94245_a("chromaticraft:dimstruct/gravity_underlay");
        overlay = ico.func_94245_a("chromaticraft:dimstruct/gravity_overlay");
    }

    public static IIcon getOverlay() {
        return overlay;
    }

    public int func_149701_w() {
        return 0;
    }

    public boolean canRenderInPass(int pass) {
        return pass <= 0;
    }

    public int func_149645_b() {
        return 0;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.4f, 1.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (GravityTiles.list[meta]) {
            case TARGET: {
                return new GravityTarget();
            }
            case RIFT: {
                return new GravityWarp();
            }
            case REROUTE: 
            case SPLITTER: {
                return new RerouteTile();
            }
            case EMITTER: {
                return new GravityEmitter();
            }
        }
        return new GravityTile();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s].getOpposite();
        if (!BlockGravityTile.tryMove(world, x, y, z, dir) && DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            GravityTile te = (GravityTile)world.func_147438_o(x, y, z);
            GravityTiles type = GravityTiles.list[world.func_72805_g(x, y, z)];
            ItemStack is = ep.func_71045_bC();
            if (ChromaItems.SHARD.matchWith(is)) {
                te.color = CrystalElement.elements[is.func_77960_j() % 16];
            } else if (is != null && is.func_77973_b() == Items.field_151079_bi && te instanceof GravityTarget) {
                ((GravityTarget)te).isDormant = false;
            } else if (is != null && is.func_77973_b() == Items.field_151114_aO && te instanceof GravityTarget) {
                ((GravityTarget)te).collectedBursts = 0;
            } else if (is != null && is.func_77973_b() == Items.field_151082_bd) {
                te.gravityFactor -= 0.03125;
            } else if (is != null && is.func_77973_b() == Items.field_151083_be) {
                te.gravityFactor += 0.03125;
            } else if (is != null && is.func_77973_b() == Items.field_151147_al) {
                te.gravityRangeFactor -= 0.03125;
                double r = te.gravityRangeFactor * te.getTileType().gravityRange;
                if (r > 0.0) {
                    te.gravityDisplay = new PulsingRadius(r, 0.125);
                }
            } else if (is != null && is.func_77973_b() == Items.field_151157_am) {
                te.gravityRangeFactor += 0.03125;
                double r = te.gravityRangeFactor * te.getTileType().gravityRange;
                if (r > 0.0) {
                    te.gravityDisplay = new PulsingRadius(r, 0.125);
                }
            } else if (is != null && is.func_77973_b() == Items.field_151137_ax && te instanceof GravityEmitter) {
                ((GravityEmitter)te).fireDuration += 10;
            } else if (is != null && is.func_77973_b() == Items.field_151016_H && te instanceof GravityEmitter) {
                ((GravityEmitter)te).fireDuration -= 10;
            } else {
                if (ChromaItems.LINKTOOL.matchWith(is)) {
                    return false;
                }
                if (!type.isOmniDirectional()) {
                    te.facing = te.facing.getRotation(true);
                }
            }
            world.func_147471_g(x, y, z);
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.click", (float)0.75f, (float)1.25f);
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        GravityTile te = (GravityTile)world.func_147438_o(x, y, z);
        if (te instanceof GravityEmitter && world.func_72864_z(x, y, z)) {
            ((GravityEmitter)te).startFiring();
        }
    }

    public static boolean tryMove(World world, int x, int y, int z, ForgeDirection dir) {
        if (BlockGravityTile.canMove(world, x, y, z, dir)) {
            BlockGravityTile.move(world, x, y, z, dir);
            return true;
        }
        return false;
    }

    private static boolean canMove(World world, int x, int y, int z, ForgeDirection dir) {
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY - 1;
        int dz = z + dir.offsetZ;
        return world.func_147439_a(dx, dy, dz) instanceof BlockStructureShield && world.func_72805_g(dx, dy, dz) % 8 == BlockStructureShield.BlockType.CLOAK.ordinal();
    }

    private static void move(World world, int x, int y, int z, ForgeDirection dir) {
        int meta = world.func_72805_g(x, y, z);
        GravityTile g1 = (GravityTile)world.func_147438_o(x, y, z);
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        world.func_147465_d(dx, dy, dz, ChromaBlocks.GRAVITY.getBlockInstance(), meta, 3);
        GravityTile g2 = (GravityTile)world.func_147438_o(dx, dy, dz);
        g2.copyFrom(g1);
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    public static class GravityTile
    extends StructureBlockTile<GravityPuzzleGenerator> {
        protected String level = "none";
        protected CrystalElement color = CrystalElement.WHITE;
        protected ReikaDirectionHelper.CubeDirections facing = ReikaDirectionHelper.CubeDirections.NORTH;
        public int renderAlpha = 255;
        private double gravityFactor = 1.0;
        private double gravityRangeFactor = 1.0;
        public PulsingRadius gravityDisplay;

        public void func_145845_h() {
            GravityTiles type = this.getTileType();
            double r = type.gravityRange * this.gravityRangeFactor;
            if (this.gravityDisplay == null && r > 0.0 && this.field_145850_b.field_72995_K) {
                this.gravityDisplay = new PulsingRadius(r, 0.125);
            }
            if (this.field_145850_b.field_72995_K) {
                // empty if block
            }
            if (r > 0.0) {
                Coordinate c = new Coordinate((TileEntity)this);
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(r, r, r);
                List li = this.field_145850_b.func_72872_a(EntityLumaBurst.class, box);
                for (EntityLumaBurst e : li) {
                    if (c.equals((Object)e.getSpawnLocation())) {
                        e.resetSpawnTimer();
                    }
                    double d = e.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    this.onImpact(type, c, e, r, d);
                }
            }
        }

        protected void onImpact(GravityTiles type, Coordinate c, EntityLumaBurst e, double r, double d) {
            if (d <= r * r && this.canAttract(type, c, e)) {
                double dx = e.field_70165_t - (double)this.field_145851_c - 0.5;
                double dy = e.field_70163_u - (double)this.field_145848_d - 0.5;
                double dz = e.field_70161_v - (double)this.field_145849_e - 0.5;
                double v = 0.125 * type.gravityStrength * this.gravityFactor;
                e.field_70159_w -= dx * v / d;
                e.field_70181_x -= dy * v / d;
                e.field_70179_y -= dz * v / d;
                e.field_70133_I = true;
            }
        }

        private boolean canAttract(GravityTiles type, Coordinate c, EntityLumaBurst e) {
            if (!type.isOmniColor() && e.getColor() != this.color) {
                return false;
            }
            return !this.isSpawnLocked(c, e);
        }

        protected final boolean isSpawnLocked(Coordinate c, EntityLumaBurst e) {
            return !e.isOutOfSpawnZone() && c.equals((Object)e.getSpawnLocation());
        }

        protected EntityLumaBurst fire(CrystalElement c) {
            ReikaDirectionHelper.CubeDirections dir = this.facing;
            if (this.getTileType() == GravityTiles.SPLITTER && this.field_145850_b.field_73012_v.nextBoolean()) {
                dir = dir.getOpposite();
            }
            EntityLumaBurst e = new EntityLumaBurst(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir, c);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)e);
            }
            return e;
        }

        protected EntityLumaBurst fireFree(CrystalElement c, double ang) {
            EntityLumaBurst e = new EntityLumaBurst(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ang, c);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)e);
            }
            return e;
        }

        protected EntityLumaBurst fireCopy(CrystalElement c, EntityLumaBurst e2) {
            EntityLumaBurst e = new EntityLumaBurst(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.0, c);
            e.copyFrom(e2);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)e);
            }
            return e;
        }

        public GravityTiles getTileType() {
            return GravityTiles.list[this.func_145832_p()];
        }

        protected void copyFrom(GravityTile g) {
            super.copyFrom(g);
            this.level = g.level;
            this.color = g.color;
            this.facing = g.facing;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.color = CrystalElement.elements[tag.func_74762_e("color")];
            this.facing = ReikaDirectionHelper.CubeDirections.list[tag.func_74762_e("dir")];
            this.level = tag.func_74779_i("level");
            this.renderAlpha = 255;
            if (tag.func_74764_b("gfactor")) {
                this.gravityFactor = tag.func_74769_h("gfactor");
            }
            if (tag.func_74764_b("rfactor")) {
                this.gravityRangeFactor = tag.func_74769_h("rfactor");
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("color", this.color.ordinal());
            tag.func_74768_a("dir", this.facing.ordinal());
            tag.func_74778_a("level", this.level);
            tag.func_74768_a("alpha", this.renderAlpha);
            tag.func_74780_a("gfactor", this.gravityFactor);
            tag.func_74780_a("rfactor", this.gravityRangeFactor);
        }

        public ReikaDirectionHelper.CubeDirections getFacing() {
            return this.facing;
        }

        public CrystalElement getColor() {
            return this.color;
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.GRAVITY;
        }
    }

    public static class GravityEmitter
    extends GravityTile {
        private int fireDuration = 180;
        private int firePower = 1;
        private int fireTimer;

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (this.fireTimer > 0) {
                for (int i = 0; i < this.firePower; ++i) {
                    EntityLumaBurst entityLumaBurst = this.fire(this.color);
                }
                --this.fireTimer;
            }
        }

        public void startFiring() {
            if (this.fireTimer == 0) {
                this.fireTimer = this.fireDuration;
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.firePower = tag.func_74762_e("pwr");
            this.fireDuration = tag.func_74762_e("dur");
            this.fireTimer = tag.func_74762_e("timer");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("pwr", this.firePower);
            tag.func_74768_a("dur", this.fireDuration);
            tag.func_74768_a("timer", this.fireTimer);
        }
    }

    public static class GravityTarget
    extends GravityTile
    implements Recharger.RechargeWaiter {
        public static final int DORMANT_DURATION = 40;
        public Recharger timer;
        private int requiredBursts = 100;
        private int collectedBursts;
        private boolean isDormant;

        public float getFillFraction() {
            return (float)this.collectedBursts / (float)this.requiredBursts;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.collectedBursts = tag.func_74762_e("num");
            this.requiredBursts = tag.func_74762_e("req");
            this.isDormant = tag.func_74767_n("dormant");
            if (this.timer != null) {
                this.timer.readFromNBT(tag.func_74775_l("timer"), this);
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("num", this.collectedBursts);
            tag.func_74768_a("req", this.requiredBursts);
            tag.func_74757_a("dormant", this.isDormant);
            if (this.timer != null) {
                NBTTagCompound dat = new NBTTagCompound();
                this.timer.writeToNBT(dat);
                tag.func_74782_a("timer", (NBTBase)dat);
            }
        }

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (this.timer != null) {
                this.timer.tick();
                this.renderAlpha = Math.max(0, this.renderAlpha - 32);
            } else {
                this.renderAlpha = Math.min(255, this.renderAlpha + 32);
            }
        }

        @Override
        protected void onImpact(GravityTiles type, Coordinate c, EntityLumaBurst e, double r, double d) {
            if (this.isDormant) {
                return;
            }
            if (d <= 0.390625) {
                if (e.getColor() == this.color) {
                    ++this.collectedBursts;
                    if (this.collectedBursts >= this.requiredBursts) {
                        if (this.collectedBursts == this.requiredBursts) {
                            this.trigger(true);
                        }
                        if ((double)this.getFillFraction() > 1.5 && !this.field_145850_b.field_72995_K) {
                            this.overload();
                        }
                    }
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else {
                    ReikaPhysicsHelper.reflectEntitySpherical((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (Entity)e);
                }
            } else {
                super.onImpact(type, c, e, r, d);
            }
        }

        private void trigger(boolean set) {
            if (set) {
                if (this.field_145850_b.field_72995_K) {
                    this.doTriggerClientside();
                }
                ChromaSounds.CAST.playSoundAtBlock(this);
            } else {
                ChromaSounds.POWERDOWN.playSoundAtBlock(this, 1.0f, 0.67f);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void doTriggerClientside() {
            for (int i = 0; i < 16; ++i) {
                double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145851_c + 0.5), (double)0.4375);
                double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145849_e + 0.5), (double)0.4375);
                double py = (double)this.field_145848_d + 0.25;
                int l = ReikaRandomHelper.getRandomBetween((int)20, (int)40);
                float s = 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.67f;
                float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125));
                EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, px, py, pz).setColor(this.color.getColor()).setGravity(g).setScale(s).setLife(l);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }

        private void overload() {
            this.timer = new Recharger(8, 16, this);
            this.isDormant = true;
            while (this.collectedBursts > 0) {
                EntityLumaBurst e = this.fire(this.color);
                e.setRandomDirection(true);
                --this.collectedBursts;
                if (this.collectedBursts >= 0) continue;
                this.collectedBursts = 0;
            }
            this.trigger(false);
        }

        @Override
        public void onSegmentComplete() {
            ChromaSounds.ITEMSTAND.playSoundAtBlock(this, 0.4f, 1.8f);
        }

        @Override
        public void onChargingComplete() {
            this.isDormant = false;
            ChromaSounds.ITEMSTAND.playSoundAtBlock(this, 0.8f, 2.0f);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.timer = null;
        }
    }

    public static class GravityWarp
    extends GravityTile
    implements Linkable {
        private Coordinate otherLocation;
        public LightningBolt linkRender;

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.otherLocation = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)tag);
            if (this.otherLocation != null) {
                DecimalPosition p2 = new DecimalPosition(this.otherLocation.offset(new Coordinate((TileEntity)this).negate())).offset(-0.5, -0.5, -0.5);
                this.linkRender = new LightningBolt(new DecimalPosition(0.0, 0.0, 0.0), p2, 8);
                this.linkRender.variance *= 0.375;
                this.linkRender.velocity *= 0.09375;
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            if (this.otherLocation != null) {
                this.otherLocation.writeToNBT("loc", tag);
            }
        }

        @Override
        protected void onImpact(GravityTiles type, Coordinate c, EntityLumaBurst e, double r, double d) {
            if (this.otherLocation != null && d <= 0.25 && !this.isSpawnLocked(c, e)) {
                ((GravityWarp)this.otherLocation.getTileEntity(this.field_145850_b)).fireCopy(e.getColor(), e);
            } else {
                super.onImpact(type, c, e, r, d);
            }
        }

        public void linkTo(GravityWarp w) {
            this.otherLocation = new Coordinate((TileEntity)w);
            w.otherLocation = new Coordinate((TileEntity)this);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            w.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @Override
        public void reset() {
            this.otherLocation = null;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @Override
        public void resetOther() {
            TileEntity te;
            if (this.otherLocation != null && (te = this.otherLocation.getTileEntity(this.field_145850_b)) instanceof GravityWarp) {
                ((GravityWarp)te).otherLocation = null;
                te.field_145850_b.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
        }

        public Coordinate getLink() {
            return this.otherLocation;
        }

        @Override
        public boolean connectTo(World world, int x, int y, int z) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof GravityWarp) {
                this.linkTo((GravityWarp)te);
                return true;
            }
            return false;
        }
    }

    public static class RerouteTile
    extends GravityTile {
        private final EnumMap<CrystalElement, Integer> collection = new EnumMap(CrystalElement.class);
        private int cooldown;

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (this.cooldown > 0) {
                --this.cooldown;
                if (this.cooldown == 0) {
                    for (CrystalElement e : this.collection.keySet()) {
                        int num = this.collection.get((Object)e);
                        for (int i = 0; i < num; ++i) {
                            this.fire(e);
                        }
                    }
                    this.collection.clear();
                }
            }
        }

        private void collect(EntityLumaBurst b) {
            ArrayList<CrystalElement> li = new ArrayList<CrystalElement>(this.collection.keySet());
            if (li.isEmpty()) {
                ReikaJavaLibrary.addToIntMap(this.collection, (Object)((Object)b.getColor()), (int)1);
            } else {
                for (CrystalElement e : li) {
                    CrystalElement mix = ElementMixer.instance.getMix(e, b.getColor());
                    if (mix != null) {
                        ReikaJavaLibrary.subtractFromIntMap(this.collection, (Object)((Object)e), (int)1);
                        ReikaJavaLibrary.addToIntMap(this.collection, (Object)((Object)mix), (int)1);
                        continue;
                    }
                    ReikaJavaLibrary.addToIntMap(this.collection, (Object)((Object)b.getColor()), (int)1);
                }
            }
            this.cooldown = 1;
        }
    }

    public static enum GravityTiles {
        EMITTER(0.0, 0.0, ChromaIcons.FAN),
        TARGET(1.0, 0.125, null),
        REROUTE(1.0, 0.5, ChromaIcons.SIDEDFLOW),
        SPLITTER(1.0, 0.5, ChromaIcons.SIDEDFLOWBI),
        TINTER(0.0, 0.0, null),
        ATTRACTOR(1.5, 0.125, ChromaIcons.BLACKHOLE),
        REPULSOR(1.5, -0.125, ChromaIcons.CONCENTRIC2),
        RIFT(0.0, 0.0, ChromaIcons.HOLE);

        public static final GravityTiles[] list;
        public final double gravityRange;
        public final double gravityStrength;
        public final ChromaIcons icon;

        private GravityTiles(double r, double g, ChromaIcons ico) {
            this.gravityRange = r;
            this.gravityStrength = g;
            this.icon = ico;
        }

        public boolean onPulse(World world, int x, int y, int z, EntityLumaBurst e) {
            GravityTile te = (GravityTile)world.func_147438_o(x, y, z);
            switch (this) {
                case EMITTER: {
                    return true;
                }
                case REROUTE: 
                case SPLITTER: {
                    ((RerouteTile)te).collect(e);
                    return true;
                }
                case TARGET: {
                    return e.getColor() == te.color && !((GravityTarget)te).isDormant;
                }
                case TINTER: {
                    if (world.field_72995_K) {
                        return false;
                    }
                    ForgeDirection dir = ReikaDirectionHelper.getImpactedSide((World)world, (int)x, (int)y, (int)z, (Entity)e);
                    if (dir != null) {
                        int dx = Math.abs(dir.offsetX) != 0 ? -1 : 1;
                        int dz = Math.abs(dir.offsetZ) != 0 ? -1 : 1;
                        e.field_70159_w *= (double)dx;
                        e.field_70179_y *= (double)dz;
                    } else {
                        return true;
                    }
                    e.field_70133_I = true;
                    e.setColor(te.color);
                    return false;
                }
                case ATTRACTOR: 
                case REPULSOR: {
                    return false;
                }
                case RIFT: {
                    te.onImpact(this, new Coordinate((TileEntity)te), e, 0.0, e.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                    return true;
                }
            }
            return false;
        }

        public boolean isOmniDirectional() {
            return this != EMITTER && this != REROUTE && this != SPLITTER;
        }

        public boolean isOmniColor() {
            return this != EMITTER && this != TARGET;
        }

        static {
            list = GravityTiles.values();
        }
    }
}

