/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.GOL;

import Reika.ChromatiCraft.Base.BlockDimensionStructure;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.World.Dimension.Structure.GOLGenerator;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGOLTile
extends BlockDimensionStructure {
    private final IIcon[] icons = new IIcon[4];

    public BlockGOLTile(Material mat) {
        super(mat);
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        if (iba.func_72805_g(x, y, z) == 3) {
            return 15;
        }
        TileEntity te = iba.func_147438_o(x, y, z);
        return te instanceof GOLTile && ((GOLTile)te).isActive() ? 15 : 6;
    }

    public boolean hasTileEntity(int meta) {
        return meta < 2;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta < 2 ? new GOLTile() : null;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer ep) {
        if (!world.field_72995_K) {
            this.toggle(world, x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        if (!world.field_72995_K) {
            this.toggle(world, x, y, z);
        }
        return true;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity e, float d) {
        if (!world.field_72995_K && e instanceof EntityPlayer && d > 1.0f) {
            this.toggle(world, x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        ((GOLTile)world.func_147438_o(x, y, z)).recalculate();
    }

    private void activate(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) >= 2) {
            return;
        }
        GOLTile te = (GOLTile)world.func_147438_o(x, y, z);
        te.setActive(true);
    }

    private void toggle(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) >= 2) {
            return;
        }
        GOLTile te = (GOLTile)world.func_147438_o(x, y, z);
        if (te.getGenerator() == null) {
            ChromatiCraft.logger.logError((Object)("No structure for tile at " + x + ", " + y + ", " + z + ", UID=" + te.uid + "!?!"));
            return;
        }
        boolean flag = true;
        if (te.isActive()) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.click", (float)0.75f, (float)0.65f);
            ((GOLGenerator)te.getGenerator()).deactivateTile(world, x, y, z);
            world.func_72921_c(x, y + 12, z, 2, 3);
        } else {
            flag = ((GOLGenerator)te.getGenerator()).activateTile(world, x, y, z);
            if (flag) {
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.click", (float)0.75f, (float)0.75f);
            } else {
                ChromaSounds.ERROR.playSoundAtBlock(world, x, y, z);
            }
        }
        if (flag) {
            te.setActive(!te.isActive());
        }
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:dimstruct/gol_off");
        this.icons[1] = ico.func_94245_a("chromaticraft:dimstruct/gol_on");
        this.icons[2] = ico.func_94245_a("chromaticraft:dimstruct/gol_mem_off");
        this.icons[3] = ico.func_94245_a("chromaticraft:dimstruct/gol_mem_on");
    }

    public IIcon func_149691_a(int s, int meta) {
        if (meta >= 2) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta >= 2) {
            return this.icons[meta];
        }
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof GOLTile) {
            return ((GOLTile)te).isActive() ? this.icons[1] : this.icons[0];
        }
        return ChromaBlocks.STRUCTSHIELD.getBlockInstance().func_149691_a(BlockStructureShield.BlockType.STONE.ordinal(), 0);
    }

    public static class GOLTile
    extends StructureBlockTile<GOLGenerator> {
        private boolean defaultActive;
        private boolean isActive;
        private int numberNeighbors;
        private boolean isTicking;
        private static final int OFFSET = 1;
        private static final int RATE = 5;

        public boolean canUpdate() {
            return true;
        }

        public void activate() {
            this.isTicking = true;
        }

        public void reset() {
            if (this.defaultActive) {
                // empty if block
            }
            this.setActive(false);
            this.isTicking = false;
        }

        public void func_145845_h() {
            if (this.isTicking) {
                int mod = (int)(this.field_145850_b.func_82737_E() % 5L);
                if (mod == 0) {
                    this.numberNeighbors = this.countNeighbors();
                } else if (mod == 1) {
                    this.recalculate();
                }
            }
        }

        private void recalculate() {
            if (this.isActive) {
                if (this.numberNeighbors < 2 || this.numberNeighbors > 3) {
                    this.setActive(false);
                }
            } else if (this.numberNeighbors == 3) {
                this.setActive(true);
            }
        }

        public void initialize(boolean active) {
            this.defaultActive = active;
            this.isActive = active;
        }

        public boolean isActive() {
            return this.isActive;
        }

        private void setActive(boolean ac) {
            this.isActive = ac;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (ac) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d + 12, this.field_145849_e, 3, 3);
            }
        }

        private int countNeighbors() {
            int c = 0;
            boolean flag = this.field_145851_c == -1 && this.field_145849_e == 0;
            for (int a1 = -1; a1 <= 1; ++a1) {
                for (int a2 = -1; a2 <= 1; ++a2) {
                    GOLTile te;
                    int dz;
                    int dx;
                    Block b;
                    if (a1 == 0 && a2 == 0 || (b = this.field_145850_b.func_147439_a(dx = this.field_145851_c + a1, this.field_145848_d, dz = this.field_145849_e + a2)) != ChromaBlocks.GOL.getBlockInstance() || !(te = (GOLTile)this.field_145850_b.func_147438_o(dx, this.field_145848_d, dz)).isActive()) continue;
                    ++c;
                }
            }
            return c;
        }

        private void updateNeighbors() {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dz = this.field_145849_e + dir.offsetY;
                Block b = this.field_145850_b.func_147439_a(dx, this.field_145848_d, dz);
                if (b != ChromaBlocks.GOL.getBlockInstance()) continue;
                GOLTile te = (GOLTile)this.field_145850_b.func_147438_o(dx, this.field_145848_d, dz);
                te.recalculate();
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("active", this.isActive);
            NBT.func_74757_a("def", this.defaultActive);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.isActive = NBT.func_74767_n("active");
            this.defaultActive = NBT.func_74767_n("def");
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.GOL;
        }
    }
}

