/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockStructureDataStorage
extends BlockDimensionStructureTile {
    private final IIcon[] icons = new IIcon[2];

    public BlockStructureDataStorage(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityStructureDataStorage();
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:dimstruct/dimdata");
        this.icons[1] = ico.func_94245_a("chromaticraft:dimstruct/dimdata_side");
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[1];
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        if (!world.field_72995_K) {
            ((TileEntityStructureDataStorage)world.func_147438_o(x, y, z)).onRightClick(ep, s);
        }
        return true;
    }

    public static class TileEntityStructureDataStorage
    extends TileEntity {
        private StructureData data;
        private HashMap<String, Object> extraData;

        public void loadData(DimensionStructureGenerator gen, HashMap<String, Object> map) {
            this.data = gen.createDataStorage();
            if (this.data != null) {
                this.data.load(map);
            }
            this.extraData = map;
        }

        protected void onRightClick(EntityPlayer ep, int s) {
            if (this.data != null) {
                this.data.onInteract(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ep, s, this.extraData);
            }
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            NBTTagCompound dat = NBT.func_74775_l("extra");
            HashMap<String, Object> hashMap = this.extraData = dat != null && !dat.func_82582_d() ? (HashMap<String, Object>)ReikaNBTHelper.getValue((NBTBase)dat) : null;
            if (NBT.func_74764_b("uid")) {
                UUID uid = UUID.fromString(NBT.func_74779_i("uid"));
                this.loadData(DimensionStructureGenerator.getGeneratorByID(uid), this.extraData);
            }
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.data != null) {
                NBT.func_74778_a("uid", this.data.getUUID().toString());
            }
            if (this.extraData != null && !this.extraData.isEmpty()) {
                NBT.func_74782_a("extra", ReikaNBTHelper.getTagForObject(this.extraData));
            }
        }
    }
}

