/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension;

import Reika.ChromatiCraft.Auxiliary.Interfaces.DecoType;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBounds;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDimensionDecoTile
extends BlockDimensionDeco {
    private static final IIcon[][] icons = new IIcon[2][16];

    public BlockDimensionDecoTile(Material mat) {
        super(mat);
        this.func_149752_b(50000.0f);
        this.func_149711_c(10.0f);
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        return ProgressionManager.ProgressStage.CTM.isPlayerAtStage(ep) ? super.func_149737_a(ep, world, x, y, z) : -1.0f;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta == DimDecoTileTypes.GLOWCRACKS.ordinal() ? new TileGlowingCracks() : new DimensionDecoTile();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (DimDecoTileTypes.list[world.func_72805_g(x, y, z)].needsRandomTick()) {
            DimensionDecoTile te = (DimensionDecoTile)world.func_147438_o(x, y, z);
            te.activate();
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + rand.nextInt(1 + this.func_149738_a(world)));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, 1);
    }

    public void func_149695_a(World world, int x, int y, int z, Block id) {
        world.func_147464_a(x, y, z, (Block)this, 1);
    }

    public int func_149738_a(World world) {
        return 400;
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        return icons[0][meta];
    }

    @Override
    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < DimDecoTileTypes.list.length; ++i) {
            BlockDimensionDecoTile.icons[0][i] = ico.func_94245_a("chromaticraft:dimgen2/underlay_" + i);
            BlockDimensionDecoTile.icons[1][i] = ico.func_94245_a("chromaticraft:dimgen2/overlay_" + i);
            DimDecoTileTypes.list[i].icon = ico.func_94245_a("chromaticraft:" + DimDecoTileTypes.list[i].itemTex);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (DimDecoTileTypes.list[meta].isCollideable()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            DimDecoTileTypes.list[meta].getBounds().copyToBlock((Block)this);
        }
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return DimDecoTileTypes.list[meta].isCollideable() ? ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z) : null;
    }

    public static class DimensionDecoTile
    extends TileEntity {
        private static final Random rand = new Random();
        private int tick = 0;

        public void activate() {
            this.tick = 100 + rand.nextInt(1200);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"fire.ignite");
        }

        public void func_145845_h() {
            if (this.tick > 0) {
                int meta = this.func_145832_p();
                switch (DimDecoTileTypes.list[meta]) {
                    case FIREJET: {
                        break;
                    }
                }
                if (this.field_145850_b.field_72995_K) {
                    this.spawnParticles(DimDecoTileTypes.list[meta]);
                }
                --this.tick;
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void spawnParticles(DimDecoTileTypes t) {
            switch (t) {
                case FIREJET: {
                    if (!this.field_145850_b.field_73012_v.nextBoolean()) break;
                    double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.01);
                    int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)((DragonAPICore.getLaunchTime() + (long)((this.field_145851_c + this.field_145848_d + this.field_145849_e) * 8)) % 360L)));
                    ChromaIcons ico = ChromaIcons.FADE;
                    switch (Math.abs(System.identityHashCode((Object)this) % 6)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            ico = ChromaIcons.FADE_RAY;
                            break;
                        }
                        case 2: {
                            ico = ChromaIcons.CLOUDGROUP;
                            break;
                        }
                        case 3: {
                            ico = ChromaIcons.TRIDOT;
                            break;
                        }
                        case 4: {
                            ico = ChromaIcons.BIGFLARE;
                            break;
                        }
                        case 5: {
                            ico = ChromaIcons.NODE2;
                        }
                    }
                    EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.9, (double)this.field_145849_e + 0.5, 0.0, vy, 0.0).setRapidExpand().setScale(4.0f).setColor(c).setIcon(ico);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    break;
                }
            }
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("tick", this.tick);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.tick = NBT.func_74762_e("tick");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
        }
    }

    public static class TileGlowingCracks
    extends DimensionDecoTile {
        public boolean canUpdate() {
            return false;
        }

        public boolean shouldRenderInPass(int pass) {
            return pass <= 1;
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(4.0, 0.0, 4.0);
        }

        public double func_145833_n() {
            return 65536.0;
        }
    }

    public static enum DimDecoTileTypes implements DecoType
    {
        FIREJET("aurajet"),
        GLOWCRACKS("glowcracks");

        public static DimDecoTileTypes[] list;
        private final String itemTex;
        private IIcon icon;

        private DimDecoTileTypes(String s) {
            this.itemTex = s;
        }

        public ItemStack getItem() {
            return new ItemStack(ChromaBlocks.DIMGENTILE.getBlockInstance(), 1, this.ordinal());
        }

        @Override
        public boolean hasBlockRender() {
            return false;
        }

        public boolean needsRandomTick() {
            switch (this) {
                case FIREJET: {
                    return true;
                }
            }
            return false;
        }

        public boolean isCollideable() {
            switch (this) {
                case FIREJET: {
                    return true;
                }
            }
            return false;
        }

        public IIcon getItemIcon() {
            return this.icon;
        }

        @Override
        public List<IIcon> getIcons(int pass) {
            return pass == 0 ? ReikaJavaLibrary.makeListFrom((Object)icons[1][this.ordinal()]) : new ArrayList();
        }

        public BlockBounds getBounds() {
            switch (this) {
                case GLOWCRACKS: {
                    return BlockBounds.block().cut(ForgeDirection.UP, 0.999);
                }
            }
            return BlockBounds.block();
        }

        static {
            list = DimDecoTileTypes.values();
        }
    }
}

