/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.Auxiliary.Interfaces.DecoType;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Render.ISBRH.DimensionDecoRenderer;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDimensionDeco
extends Block
implements MinerBlock {
    private static final ArrayList<IIcon>[] icons = new ArrayList[16];
    private static final Random rand = new Random();

    public BlockDimensionDeco(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        this.func_149752_b(5.0f);
        this.func_149711_c(0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int s) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        return iba.func_147439_a(x, y, z) != this || iba.func_72805_g(x, y, z) != iba.func_72805_g(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (meta == DimDecoTypes.GEMSTONE.ordinal() && Minecraft.func_71410_x().field_71441_e != null) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            return BlockDimensionDeco.getGemStoneColor((IBlockAccess)Minecraft.func_71410_x().field_71441_e, MathHelper.func_76128_c((double)ep.field_70165_t), MathHelper.func_76128_c((double)ep.field_70163_u), MathHelper.func_76128_c((double)ep.field_70161_v));
        }
        return 0xFFFFFF;
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal() || meta == DimDecoTypes.CRYSTALLEAF.ordinal()) {
            return BlockDimensionDeco.getGemStoneColor(iba, x, y, z);
        }
        return 0xFFFFFF;
    }

    public static int getGemStoneColor(IBlockAccess iba, int x, int y, int z) {
        return ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((x + z * 3 / 2) * 4));
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            return 0;
        }
        if (meta == DimDecoTypes.CRYSTALLEAF.ordinal()) {
            return 0;
        }
        if (meta == DimDecoTypes.CLIFFGLASS.ordinal()) {
            return 12;
        }
        return 0;
    }

    public int func_149677_c(IBlockAccess iba, int x, int y, int z) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal() || meta == DimDecoTypes.OCEANSTONE.ordinal()) {
            return iba.func_72802_i(x, y, z, 15);
        }
        return super.func_149677_c(iba, x, y, z);
    }

    public IIcon func_149691_a(int s, int meta) {
        return icons[meta].get(0);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < DimDecoTypes.list.length; ++i) {
            int n = DimDecoTypes.list[i].numIcons;
            BlockDimensionDeco.icons[i] = new ArrayList();
            for (int k = 0; k < n; ++k) {
                icons[i].add(ico.func_94245_a("chromaticraft:dimgen/" + i + "_layer_" + k));
            }
        }
    }

    public final int func_149645_b() {
        return ChromaCommon.dimgenRender;
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public final int func_149701_w() {
        return 1;
    }

    public Item func_149650_a(int meta, Random r, int fortune) {
        return ChromaItems.DIMGEN.getItemInstance();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return DimDecoTypes.list[metadata].canSilkTouch();
    }

    public final boolean canRenderInPass(int pass) {
        DimensionDecoRenderer.renderPass = pass;
        return pass <= 1;
    }

    public boolean canHarvestBlock(EntityPlayer ep, int meta) {
        return DimDecoTypes.list[meta].requiresPickaxe() ? super.canHarvestBlock(ep, meta) : true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return DimDecoTypes.list[meta].hasBlockRender() ? ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z) : null;
    }

    @Override
    public boolean isMineable(int meta) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getHarvestItems(World world, int x, int y, int z, int meta, int fortune) {
        return this.getDrops(world, x, y, z, meta, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            int n = r.nextInt(5);
            int c = BlockDimensionDeco.getGemStoneColor((IBlockAccess)world, x, y, z);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
            double o = 0.03125;
            for (int i = 0; i < n; ++i) {
                double px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
                double py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
                double pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
                while (new DecimalPosition(px, py, pz).sharesBlock((double)x, (double)y, (double)z)) {
                    px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
                    py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
                    pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
                }
                float s = 1.0f + r.nextFloat();
                EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setColor(c).setLife(l).setRapidExpand().setIcon(ChromaIcons.FLARE).setScale(s);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int s, float a, float b, float c, int meta) {
        if (meta == DimDecoTypes.GEMSTONE.ordinal() && world.field_72995_K) {
            this.doBreakFX(world, x, y, z);
        }
        return meta;
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        if (oldmeta == DimDecoTypes.GEMSTONE.ordinal() && world.field_72995_K) {
            this.doBreakFX(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer f) {
        int meta = world.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            this.doBreakFX(world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer f) {
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            this.doBreakFX(world, x, y, z);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void doBreakFX(World world, int x, int y, int z) {
        int n = 16 + rand.nextInt(32);
        int c = BlockDimensionDeco.getGemStoneColor((IBlockAccess)world, x, y, z);
        int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
        double o = 0.03125;
        for (int i = 0; i < n; ++i) {
            double px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
            double py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
            double pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
            while (new DecimalPosition(px, py, pz).sharesBlock((double)x, (double)y, (double)z)) {
                px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
                py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
                pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
            }
            float s = 1.0f + rand.nextFloat();
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setColor(c).setLife(l).setRapidExpand().setIcon(ChromaIcons.FLARE).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            return false;
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public static enum DimDecoTypes implements DecoType
    {
        MIASMA(1),
        FLOATSTONE(2),
        AQUA(1),
        LIFEWATER(1),
        LATTICE(1),
        GEMSTONE(3),
        CRYSTALLEAF(3),
        OCEANSTONE(2),
        CLIFFGLASS(2);

        public final int numIcons;
        public static DimDecoTypes[] list;

        private DimDecoTypes(int n2) {
            this.numIcons = n2;
        }

        public ItemStack getItem() {
            return new ItemStack(ChromaBlocks.DIMGEN.getBlockInstance(), 1, this.ordinal());
        }

        @Override
        public boolean hasBlockRender() {
            return this == FLOATSTONE || this == GEMSTONE || this == CRYSTALLEAF || this == OCEANSTONE || this == CLIFFGLASS;
        }

        @Override
        public List<IIcon> getIcons(int pass) {
            ArrayList<IIcon> li = new ArrayList<IIcon>();
            int idx = 0;
            for (IIcon ico : icons[this.ordinal()]) {
                if (this.renderIconInPass(idx, pass)) {
                    li.add(ico);
                }
                ++idx;
            }
            return li;
        }

        private boolean renderIconInPass(int idx, int pass) {
            if (this == CRYSTALLEAF || this == CLIFFGLASS) {
                return idx >= 1 ? pass == 1 : pass == 0;
            }
            if (this == MIASMA || this == LIFEWATER) {
                return pass == 1;
            }
            return pass == 0;
        }

        public boolean requiresPickaxe() {
            return this == FLOATSTONE || this == GEMSTONE || this == OCEANSTONE || this == CLIFFGLASS;
        }

        public boolean canSilkTouch() {
            switch (this) {
                case FLOATSTONE: 
                case MIASMA: 
                case LATTICE: 
                case LIFEWATER: 
                case AQUA: {
                    return false;
                }
            }
            return true;
        }

        static {
            list = DimDecoTypes.values();
        }
    }
}

