/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Decoration;

import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.ISBRH.LampRenderer;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityLampController;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.ModList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRangeLamp
extends Block {
    private IIcon dark;
    private IIcon light;

    public BlockRangeLamp(Material mat) {
        super(mat);
        this.field_149782_v = 5.0f;
        this.field_149781_w = 10.0f;
        this.field_149762_H = new Block.SoundType("stone", 1.0f, 0.5f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaDeco);
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        boolean lit = ((TileEntityRangedLamp)iba.func_147438_o(x, y, z)).isLit();
        if (lit) {
            if (ModList.COLORLIGHT.isLoaded()) {
                int color = this.func_149720_d(iba, x, y, z);
                return ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)15) | 0xF;
            }
            return 15;
        }
        return 0;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityRangedLamp();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        LampRenderer.renderPass = pass;
        return pass <= 1;
    }

    public int func_149645_b() {
        return ChromaCommon.lampRender;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityRangedLamp te = new TileEntityRangedLamp();
        world.func_147455_a(x, y, z, (TileEntity)te);
        TileEntityLampController.addLight(te);
        te.setLit(TileEntityLampController.activeSourceInRange(te));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        TileEntityRangedLamp te = (TileEntityRangedLamp)world.func_147438_o(x, y, z);
        ItemStack is = ep.func_71045_bC();
        if (is != null) {
            int dmg = -1;
            if (ReikaDyeHelper.isDyeItem((ItemStack)is)) {
                dmg = ReikaDyeHelper.getColorFromItem((ItemStack)is).ordinal();
            } else if (ChromaItems.SHARD.matchWith(is)) {
                dmg = is.func_77960_j() % 16;
            }
            if (dmg >= 0 && dmg != world.func_72805_g(x, y, z)) {
                world.func_72921_c(x, y, z, dmg, 3);
                return true;
            }
        }
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldm) {
        TileEntityRangedLamp te = (TileEntityRangedLamp)world.func_147438_o(x, y, z);
        TileEntityLampController.removeLight(te);
        super.func_149749_a(world, x, y, z, old, oldm);
    }

    public int func_149741_i(int meta) {
        return ReikaColorAPI.getModifiedSat((int)CrystalElement.elements[meta].getColor(), (float)0.7f);
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return this.func_149741_i(iba.func_72805_g(x, y, z));
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:lamp");
        this.dark = ico.func_94245_a("chromaticraft:lamp_off");
        this.light = this.field_149761_L;
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.getLightValue(iba, x, y, z) > 0 ? this.light : this.dark;
    }

    public static class TileEntityRangedLamp
    extends TileEntity
    implements GuiController {
        private boolean lit;
        private int channel;

        public boolean isLit() {
            return this.lit;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int ch) {
            TileEntityLampController.removeLight(this);
            this.channel = ch;
            TileEntityLampController.addLight(this);
            this.setLit(TileEntityLampController.activeSourceInRange(this));
        }

        public void setLit(boolean on) {
            this.lit = on;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean canUpdate() {
            return false;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("on", this.lit);
            NBT.func_74768_a("ch", this.channel);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.lit = NBT.func_74767_n("on");
            this.channel = NBT.func_74762_e("ch");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

