/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.Interfaces.SidedBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityRouterHub;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRouterNode
extends Block
implements SidedBlock {
    private final IIcon[] icons = new IIcon[2];

    public BlockRouterNode(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.func_149711_c(0.0f);
        this.func_149752_b(6000.0f);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityRouterExtraction();
            }
            case 1: {
                return new TileEntityRouterInsertion();
            }
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = ico.func_94245_a("chromaticraft:basic/routernode-" + i);
        }
    }

    @Override
    public boolean canPlaceOn(World world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z).func_149688_o().func_76220_a();
    }

    @Override
    public void setSide(World world, int x, int y, int z, int side) {
        ((TileEntityRouterNode)world.func_147438_o(x, y, z)).place(world, x, y, z, side);
    }

    public void setConnection(World world, int x, int y, int z, Coordinate hub) {
        ((TileEntityRouterNode)world.func_147438_o(x, y, z)).setHub(hub);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        return true;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        float xmin = 0.0f;
        float ymin = 0.0f;
        float zmin = 0.0f;
        float xmax = 1.0f;
        float ymax = 1.0f;
        float zmax = 1.0f;
        float h = 0.125f;
        float w = 0.1875f;
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof TileEntityRouterNode) {
            ForgeDirection dir = ((TileEntityRouterNode)te).getSide();
            switch (dir) {
                case WEST: {
                    zmin = 0.5f - w;
                    zmax = 0.5f + w;
                    ymin = 0.5f - w;
                    ymax = 0.5f + w;
                    xmin = 1.0f - h;
                    break;
                }
                case EAST: {
                    zmin = 0.5f - w;
                    zmax = 0.5f + w;
                    ymin = 0.5f - w;
                    ymax = 0.5f + w;
                    xmax = h;
                    break;
                }
                case NORTH: {
                    xmin = 0.5f - w;
                    xmax = 0.5f + w;
                    ymin = 0.5f - w;
                    ymax = 0.5f + w;
                    zmin = 1.0f - h;
                    break;
                }
                case SOUTH: {
                    xmin = 0.5f - w;
                    xmax = 0.5f + w;
                    ymin = 0.5f - w;
                    ymax = 0.5f + w;
                    zmax = h;
                    break;
                }
                case UP: {
                    xmin = 0.5f - w;
                    xmax = 0.5f + w;
                    zmin = 0.5f - w;
                    zmax = 0.5f + w;
                    ymax = h;
                    break;
                }
                case DOWN: {
                    xmin = 0.5f - w;
                    xmax = 0.5f + w;
                    zmin = 0.5f - w;
                    zmax = 0.5f + w;
                    ymin = 1.0f - h;
                    break;
                }
            }
            this.func_149676_a(xmin, ymin, zmin, xmax, ymax, zmax);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRouterNode) {
            ForgeDirection dir = ((TileEntityRouterNode)te).getSide();
            if (!this.canPlaceOn(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, world.func_72805_g(x, y, z))) {
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this);
                BlockRouterNode.drop(world, x, y, z);
            }
        }
    }

    private static void drop(World world, int x, int y, int z) {
        ItemStack is = new ItemStack(ChromaBlocks.ROUTERNODE.getBlockInstance(), 1, world.func_72805_g(x, y, z));
        ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRouterNode) {
            ((TileEntityRouterNode)te).onBreak();
        }
    }

    public static class TileEntityRouterExtraction
    extends TileEntityRouterNode {
        @Override
        protected void addConnection(TileEntityRouterHub te) {
            te.addExtractor(this);
        }
    }

    public static class TileEntityRouterInsertion
    extends TileEntityRouterNode {
        @Override
        protected void addConnection(TileEntityRouterHub te) {
            te.addInserter(this);
        }
    }

    public static abstract class TileEntityRouterNode
    extends TileEntity
    implements RouterFilter {
        private ForgeDirection side;
        public boolean isBlacklist;
        private Coordinate hub;
        private TileEntityRouterHub.ItemRule[] filter = new TileEntityRouterHub.ItemRule[9];

        public final boolean canUpdate() {
            return false;
        }

        public final ForgeDirection getSide() {
            return this.side != null ? this.side : ForgeDirection.UP;
        }

        public final void onBreak() {
            TileEntity te;
            if (this.hub != null && (te = this.hub.getTileEntity(this.field_145850_b)) instanceof TileEntityRouterHub) {
                ((TileEntityRouterHub)te).removeConnection(this);
            }
        }

        public final void setHub(Coordinate c) {
            TileEntity te;
            if (this.hub != null && !this.hub.equals((Object)c) && (te = this.hub.getTileEntity(this.field_145850_b)) instanceof TileEntityRouterHub) {
                ((TileEntityRouterHub)te).removeConnection(this);
            }
            this.hub = c;
            if (this.hub == null) {
                return;
            }
            te = this.hub.getTileEntity(this.field_145850_b);
            if (te instanceof TileEntityRouterHub) {
                this.addConnection((TileEntityRouterHub)te);
            }
        }

        public Coordinate getHub() {
            return this.hub;
        }

        private final void place(World world, int x, int y, int z, int side) {
            this.side = ForgeDirection.VALID_DIRECTIONS[side];
        }

        protected abstract void addConnection(TileEntityRouterHub var1);

        @Override
        public void setFilterItem(int slot, ItemStack is) {
            MESystemReader.MatchMode mode = this.filter[slot] != null ? this.filter[slot].mode : MESystemReader.MatchMode.EXACT;
            this.filter[slot] = is != null ? new TileEntityRouterHub.ItemRule(is.func_77946_l(), mode) : null;
            this.update();
        }

        @Override
        public void setFilterMode(int slot, MESystemReader.MatchMode mode) {
            if (this.filter[slot] == null) {
                return;
            }
            this.filter[slot] = new TileEntityRouterHub.ItemRule(this.filter[slot].getItem(), mode);
            this.update();
        }

        public void update() {
            this.setHub(this.hub);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public final Collection<TileEntityRouterHub.ItemRule> getFilter() {
            HashSet<TileEntityRouterHub.ItemRule> li = new HashSet<TileEntityRouterHub.ItemRule>();
            for (int i = 0; i < this.filter.length; ++i) {
                if (this.filter[i] == null) continue;
                li.add(this.filter[i]);
            }
            return li;
        }

        @Override
        public TileEntityRouterHub.ItemRule getFilter(int slot) {
            return this.filter[slot];
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.filter = new TileEntityRouterHub.ItemRule[9];
            for (int i = 0; i < this.filter.length; ++i) {
                this.filter[i] = TileEntityRouterHub.ItemRule.readFromNBT(NBT.func_74775_l("slot_" + i));
            }
            if (NBT.func_74764_b("hub")) {
                this.hub = Coordinate.readFromNBT((String)"hub", (NBTTagCompound)NBT);
            }
            this.side = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("side")];
            this.isBlacklist = NBT.func_74767_n("black");
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            for (int i = 0; i < this.filter.length; ++i) {
                if (this.filter[i] == null) continue;
                NBT.func_74782_a("slot_" + i, (NBTBase)this.filter[i].writeToNBT());
            }
            if (this.hub != null) {
                this.hub.writeToNBT("hub", NBT);
            }
            NBT.func_74768_a("side", this.getSide().ordinal());
            NBT.func_74757_a("black", this.isBlacklist);
        }

        public final Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public final void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static interface RouterFilter {
        public void setFilterMode(int var1, MESystemReader.MatchMode var2);

        public void setFilterItem(int var1, ItemStack var2);

        public TileEntityRouterHub.ItemRule getFilter(int var1);
    }
}

