/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHoverBlock
extends Block {
    public BlockHoverBlock(Material mat) {
        super(mat);
        this.func_149722_s();
        this.func_149647_a((CreativeTabs)(DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() ? ChromatiCraft.tabChroma : null));
        this.func_149752_b(600000.0f);
        this.func_149675_a(true);
    }

    public boolean decay(int meta) {
        return meta >= 8;
    }

    public boolean doDecay(int meta) {
        return meta >= 12;
    }

    public boolean isAir(IBlockAccess iba, int x, int y, int z) {
        return true;
    }

    public void func_149666_a(Item item, CreativeTabs cr, List li) {
        for (int i = 0; i < HoverType.list.length; ++i) {
            HoverType h = HoverType.list[i];
            li.add(new ItemStack((Block)this, 1, h.getPermanentMeta()));
            li.add(new ItemStack((Block)this, 1, h.getDecayMeta()));
        }
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:basic/hover");
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        int meta = world.func_72805_g(x, y, z);
        if (this.decay(meta)) {
            if (this.doDecay(meta)) {
                world.func_147468_f(x, y, z);
            } else {
                world.func_72921_c(x, y, z, meta + 4, 3);
                world.func_147464_a(x, y, z, (Block)this, 20 + r.nextInt(60));
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, 80);
    }

    public int func_149741_i(int meta) {
        int color = HoverType.getFromMeta((int)meta).renderColor;
        if (this.doDecay(meta)) {
            color = ReikaColorAPI.getModifiedSat((int)color, (float)0.75f);
        }
        return color;
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return this.func_149741_i(iba.func_72805_g(x, y, z));
    }

    public void func_149734_b(World world, int x, int y, int z, Random r) {
        ReikaParticleHelper.PORTAL.spawnAroundBlock(world, x, y, z, 4);
        ReikaParticleHelper.PORTAL.spawnAroundBlock(world, x, y - 1, z, 2);
    }

    public Item func_149650_a(int meta, Random r, int fortune) {
        return null;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (e instanceof EntityPlayer) {
            int meta = world.func_72805_g(x, y, z);
            HoverType.getFromMeta(meta).updateEntity((EntityPlayer)e);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149678_a(int meta, boolean hitLiquid) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 0;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int s) {
        return s > 1 && iba.func_147439_a(x, y, z) != this;
    }

    public static enum HoverType {
        STATIONARY("Brake", 0xFFFF00, 0.0),
        DAMPER("Damper", 0xFF00FF, -0.25),
        ELEVATE("Elevator", 0x2288FF, 0.125),
        FASTELEVATE("Rapid Elevator", 65280, 0.75);

        public final int renderColor;
        public final double velocityFactor;
        public final String desc;
        public static final HoverType[] list;

        private HoverType(String s, int c, double v) {
            this.renderColor = c;
            this.velocityFactor = v;
            this.desc = s;
        }

        public int getPermanentMeta() {
            return this.ordinal();
        }

        public int getDecayMeta() {
            return this.ordinal() + 8;
        }

        public int getDecayingMeta() {
            return this.ordinal() + 8 + 4;
        }

        public boolean movesUpwards() {
            return this.velocityFactor > 0.0;
        }

        public void updateEntity(EntityPlayer e) {
            double dv = e.field_70181_x - this.velocityFactor - 0.3;
            if (dv < 0.0) {
                e.field_70181_x = dv > 0.0625 ? this.velocityFactor : (e.field_70181_x -= 0.25 * dv);
                e.field_70143_R = 0.0f;
            }
        }

        public static HoverType getFromMeta(int meta) {
            return list[meta % 4];
        }

        static {
            list = HoverType.values();
        }
    }
}

