/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Base.BlockAttachableMini;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.ThermalTile;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.RotaryCraft.API.Interfaces.BasicTemperatureMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHeatLamp
extends BlockAttachableMini {
    public BlockHeatLamp(Material mat) {
        super(mat);
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ((BlockTieredOre)ChromaBlocks.TIEREDORE.getBlockInstance()).getGeodeIcon(6);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void createFX(World world, double dx, double dy, double dz, Random r) {
        EntityFX fx = new EntityCenterBlurFX(CrystalElement.ORANGE, world, dx, dy, dz, 0.0, 0.0, 0.0).setScale(2.0f + r.nextFloat() * 2.0f);
        if (r.nextInt(4) == 0) {
            fx = new EntityLaserFX(CrystalElement.ORANGE, world, dx, dy, dz, 0.0, 0.0, 0.0).setScale(2.0f + r.nextFloat() * 2.0f);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityHeatLamp();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    @Override
    public int getColor() {
        return 0xFFAA00;
    }

    public static class TileEntityHeatLamp
    extends TileEntity
    implements GuiController {
        public int temperature;
        public static final int MAXTEMP = 615;

        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            this.temperature = Math.max(0, Math.min(615, this.temperature));
            ForgeDirection dir = ((BlockHeatLamp)this.func_145838_q()).getSide((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).getOpposite();
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof ThermalTile) {
                ThermalTile tl = (ThermalTile)te;
                if (this.canHeat(tl)) {
                    if (this.temperature > tl.getTemperature()) {
                        tl.setTemperature(tl.getTemperature() + 1);
                        if (ModList.ROTARYCRAFT.isLoaded() && te instanceof BasicTemperatureMachine) {
                            ((BasicTemperatureMachine)te).resetAmbientTemperatureTimer();
                        }
                    }
                } else {
                    ((BlockHeatLamp)this.func_145838_q()).drop(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (te instanceof TileEntityFurnace) {
                TileEntityFurnace tf = (TileEntityFurnace)te;
                double c = Math.min(1.0, 1.25 * (double)this.temperature / 1000.0);
                if (ReikaRandomHelper.doWithChance((double)c)) {
                    if (tf.field_145956_a == 0 && ReikaRandomHelper.doWithChance((double)c)) {
                        tf.field_145956_a = 20;
                    }
                    te.func_145845_h();
                }
            }
        }

        private boolean canHeat(ThermalTile tl) {
            if (ModList.ROTARYCRAFT.isLoaded() && this.isRotaryHeatTile(tl)) {
                return false;
            }
            return !ModList.REACTORCRAFT.isLoaded() || !this.isReactorTile(tl);
        }

        @DependentMethodStripper.ModDependent(value=ModList.ROTARYCRAFT)
        private boolean isRotaryHeatTile(ThermalTile tl) {
            return tl instanceof TemperatureTE && !((TemperatureTE)tl).allowExternalHeating();
        }

        @DependentMethodStripper.ModDependent(value=ModList.REACTORCRAFT)
        private boolean isReactorTile(ThermalTile tl) {
            return tl instanceof ReactorCoreTE;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("temperature", this.temperature);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.temperature = NBT.func_74762_e("temperature");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
    }
}

