/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Base.BlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityMagicPlant;
import Reika.ChromatiCraft.ChromaClient;
import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockDecoPlant
extends BlockChromaTile
implements IPlantable {
    private final IIcon[] front_icons = new IIcon[16];
    private final IIcon[] back_icons = new IIcon[16];

    public BlockDecoPlant(Material xMaterial) {
        super(xMaterial);
        this.field_149762_H = field_149779_h;
        this.field_149782_v = 0.0f;
        this.field_149781_w = 0.5f;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 15;
            }
            case 1: {
                return 6;
            }
            case 4: {
                return 12;
            }
        }
        return 0;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
    }

    public final boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        super.func_149695_a(world, x, y, z, par5);
        this.checkFlowerChange(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        this.checkFlowerChange(world, x, y, z);
    }

    private final void checkFlowerChange(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return ((TileEntityMagicPlant)world.func_147438_o(x, y, z)).isPlantable(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.1875);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.1875);
                double ry = (double)y + 0.25 + r.nextDouble() * 0.75;
                ReikaParticleHelper.FLAME.spawnAt(world, rx, ry, rz);
                break;
            }
            case 1: {
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.375);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.375);
                double ry = (double)y + 0.25 + r.nextDouble() * 0.75 + 0.5;
                ReikaParticleHelper.ENCHANTMENT.spawnAt(world, rx, ry, rz);
                break;
            }
            case 4: {
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.375);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.375);
                double ry = (double)y + 0.25 + r.nextDouble() * 0.75;
                ReikaParticleHelper.spawnColoredParticleAt((World)world, (double)rx, (double)ry, (double)rz, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case 5: {
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.5);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.5);
                double ry = (double)y + r.nextDouble();
                ReikaParticleHelper.spawnColoredParticleAt((World)world, (double)rx, (double)ry, (double)rz, (double)1.0, (double)1.0, (double)0.0);
                break;
            }
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return ReikaJavaLibrary.makeListFrom((Object)ChromaTiles.getTileFromIDandMetadata((Block)this, meta).getCraftedProduct());
    }

    public int func_149645_b() {
        return ChromaCommon.plantRender2;
    }

    public boolean canRenderInPass(int pass) {
        ChromaClient.plant2.renderPass = pass;
        return pass <= 0;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public IIcon getOverlay(int meta) {
        return this.front_icons[meta];
    }

    public IIcon getBacking(int meta) {
        return this.back_icons[meta];
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        return this.getBacking(meta);
    }

    @Override
    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < 16; ++i) {
            this.front_icons[i] = ico.func_94245_a("chromaticraft:plant/decoplant_" + i + "_front");
            this.back_icons[i] = ico.func_94245_a("chromaticraft:plant/decoplant_" + i + "_back");
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                return EnumPlantType.Water;
            }
            case 2: {
                return EnumPlantType.Cave;
            }
            case 4: {
                return EnumPlantType.Crop;
            }
        }
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                if (!(e instanceof EntityLivingBase)) break;
                e.func_70015_d(2);
                break;
            }
            case 1: {
                if (!(e instanceof EntityLivingBase)) break;
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(ChromatiCraft.betterRegen.field_76415_H, 20, 0));
                break;
            }
            case 5: {
                e.func_70097_a(DamageSource.field_76367_g, 1.0f);
                if (!(e instanceof EntityLivingBase)) break;
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 20, 1));
                break;
            }
        }
    }
}

