/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.BlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrystalTile
extends BlockChromaTile {
    public BlockCrystalTile(Material mat) {
        super(mat);
        this.func_149715_a(1.0f);
        this.func_149752_b(6000.0f);
        this.func_149711_c(4.5f);
        this.field_149762_H = new Block.SoundType("stone", 1.0f, 0.5f);
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 15;
    }

    public ArrayList<ItemStack> getPieces(World world, int x, int y, int z) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (c == null) {
            return li;
        }
        switch (c) {
            case GUARDIAN: {
                if (!ReikaRandomHelper.doWithChance((double)25.0)) break;
                li.add(ChromaStacks.crystalStar);
                break;
            }
            case DIMENSIONCORE: {
                if (ReikaRandomHelper.doWithChance((double)25.0)) {
                    li.add(ChromaStacks.crystalStar);
                }
                if (ReikaRandomHelper.doWithChance((double)25.0)) {
                    li.add(ChromaStacks.voidCore);
                }
                if (ReikaRandomHelper.doWithChance((double)25.0)) {
                    li.add(ChromaStacks.energyCore);
                }
                if (ReikaRandomHelper.doWithChance((double)25.0)) {
                    li.add(ChromaStacks.crystalFocus);
                }
                if (!ReikaRandomHelper.doWithChance((double)50.0)) break;
                li.add(ChromaStacks.beaconDust);
                break;
            }
        }
        return li;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return ReikaAABBHelper.getSizedBlockAABB((int)x, (int)y, (int)z, (float)this.getSize((IBlockAccess)world, x, y, z));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return ReikaAABBHelper.getSizedBlockAABB((int)x, (int)y, (int)z, (float)this.getSize((IBlockAccess)world, x, y, z));
    }

    public float getSize(IBlockAccess iba, int x, int y, int z) {
        switch (iba.func_72805_g(x, y, z)) {
            case 2: {
                return 0.75f;
            }
        }
        return 1.0f;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.func_149691_a(s, iba.func_72805_g(x, y, z));
    }

    public boolean canHarvest(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (world.func_147439_a(x, y, z) != this) {
            return false;
        }
        ItemStack is = player.func_71045_bC();
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return this.getPieces(world, x, y, z);
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (this.canHarvest(world, player, x, y, z) && !world.field_72995_K) {
            this.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
        return world.func_147468_f(x, y, z);
    }

    @Override
    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (c == null) {
            return;
        }
        if (c != ChromaTiles.PYLON) {
            boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)ep);
            TileEntityChromaticBase te = (TileEntityChromaticBase)world.func_147438_o(x, y, z);
            if (!te.isUnHarvestable()) {
                if (silk || !c.needsSilkTouch()) {
                    ItemStack is = this.getHarvestedItemStack(world, x, y, z, meta, c);
                    if (c.hasNBTVariants()) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        ((NBTTile)((Object)te)).getTagsToWriteToStack(nbt);
                        is.field_77990_d = (NBTTagCompound)(!nbt.func_82582_d() ? nbt.func_74737_b() : null);
                    }
                    ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
                } else {
                    ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), this.getPieces(world, x, y, z));
                }
            }
        }
    }

    protected ItemStack getHarvestedItemStack(World world, int x, int y, int z, int meta, ChromaTiles c) {
        return c.getCraftedProduct();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int s) {
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            return true;
        }
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        int dx = x;
        int dy = y;
        int dz = z;
        Block id = world.func_147439_a(dx, dy, dz);
        if (id == Blocks.field_150350_a) {
            return true;
        }
        if (id == this) {
            return false;
        }
        return !id.func_149662_c();
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return 0;
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        switch (meta) {
            case 0: {
                return ChromaIcons.GUARDIANOUTER.getIcon();
            }
            case 2: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }
}

