/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.ChromaCommon;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.ConnectedTextureGlass;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockCrystalTank
extends Block
implements IWailaDataProvider,
ConnectedTextureGlass {
    private final ArrayList<Integer> allDirs = new ArrayList();
    private IIcon[] edges = new IIcon[10];

    public BlockCrystalTank(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.func_149711_c(1.0f);
        this.func_149752_b(600.0f);
        for (int i = 1; i < 10; ++i) {
            this.allDirs.add(i);
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new CrystalTankAuxTile();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ItemStack is = ep.func_71045_bC();
        CrystalTankAuxTile te = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        TileEntityCrystalTank tk = te.getTankController();
        if (tk == null) {
            return false;
        }
        if (is != null && is.field_77994_a == 1) {
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
            if (fs != null) {
                int drain = tk.fill(null, fs, false);
                if (drain == fs.amount) {
                    tk.fill(null, fs, true);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        ItemStack is2 = FluidContainerRegistry.drainFluidContainer((ItemStack)is);
                        ep.func_70062_b(0, is2);
                    }
                }
                return true;
            }
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)is)) {
                ItemStack fill;
                FluidStack rem = tk.drain(null, tk.getLevel(), false);
                if (rem != null && (fill = FluidContainerRegistry.fillFluidContainer((FluidStack)rem, (ItemStack)is)) != null) {
                    FluidStack removed = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fill);
                    tk.drain(null, removed.amount, true);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        ep.func_70062_b(0, fill);
                    }
                }
                return true;
            }
        }
        if (ChromaBlocks.TANK.match(is)) {
            return false;
        }
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, tk.field_145851_c, tk.field_145848_d, tk.field_145849_e);
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        CrystalTankAuxTile tile = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        TileEntityCrystalTank te = tile.getTankController();
        return te != null && te.getFluid() != null ? te.getFluid().getLuminosity() : 0;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.edges[0];
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:basic/tank2");
        for (int i = 0; i < 10; ++i) {
            this.edges[i] = ico.func_94245_a("chromaticraft:tank/tank_" + i);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ChromaCommon.tankRender;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        CrystalTankAuxTile tile;
        CrystalTankAuxTile te = new CrystalTankAuxTile();
        world.func_147455_a(x, y, z, (TileEntity)te);
        TileEntityCrystalTank con = null;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz);
            if (c == ChromaTiles.TANK) {
                TileEntityCrystalTank tank = (TileEntityCrystalTank)world.func_147438_o(dx, dy, dz);
                te.setTile(tank);
                world.func_72921_c(x, y, z, 1, 3);
                te.addToTank();
                con = tank;
                continue;
            }
            if (world.func_147439_a(dx, dy, dz) != this || !(tile = (CrystalTankAuxTile)world.func_147438_o(dx, dy, dz)).hasTile()) continue;
            te.setTile(tile.getTankController());
            world.func_72921_c(x, y, z, 1, 3);
            te.addToTank();
            con = tile.getTankController();
        }
        if (con != null) {
            BlockArray blocks = new BlockArray();
            blocks.recursiveAddWithBounds(world, x, y, z, (Block)this, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                int dx = c.xCoord;
                int dy = c.yCoord;
                int dz = c.zCoord;
                tile = (CrystalTankAuxTile)world.func_147438_o(dx, dy, dz);
                tile.setTile(con);
                world.func_72921_c(dx, dy, dz, 1, 3);
                tile.addToTank();
            }
        }
    }

    private void confirmHasController(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        Set li = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ChromaTiles.TANK)});
        blocks.recursiveAddMultipleWithBounds(world, x, y, z, li, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
        Object con = null;
        int count = 0;
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            ChromaTiles ct = ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz);
            if (ct != ChromaTiles.TANK) continue;
            ++count;
        }
        if (count != 1) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof CrystalTankAuxTile) {
                ((CrystalTankAuxTile)te).removeFromTank();
            }
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                int dx = c.xCoord;
                int dy = c.yCoord;
                int dz = c.zCoord;
                TileEntity te2 = world.func_147438_o(dx, dy, dz);
                if (!(te2 instanceof CrystalTankAuxTile)) continue;
                ((CrystalTankAuxTile)te2).removeFromTank();
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        if (te != null) {
            te.removeFromTank();
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            this.confirmHasController(world, dx, dy, dz);
        }
        super.func_149749_a(world, x, y, z, old, oldmeta);
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaBody(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)acc.getTileEntity();
        TileEntityCrystalTank tank = te.getTankController();
        if (tank != null) {
            tank.syncAllData(false);
            int amt = tank.getLevel();
            int capacity = tank.getCapacity();
            Fluid f = tank.getFluid();
            if (amt > 0 && f != null) {
                currenttip.add(String.format("Tank: %dmB/%dmB of %s", amt, capacity, f.getLocalizedName()));
            } else {
                currenttip.add(String.format("Tank: Empty (Capacity %dmB)", capacity));
            }
        } else {
            currenttip.add("No Tank");
        }
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public List<String> getWailaTail(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value=ModList.WAILA)
    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        return iba.func_147439_a(dx, dy, dz) != this && ChromaTiles.getTile(iba, dx, dy, dz) != ChromaTiles.TANK;
    }

    public ArrayList<Integer> getEdgesForFace(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.addAll(this.allDirs);
        if (world.func_72805_g(x, y, z) == 0) {
            return li;
        }
        if (face.offsetX != 0) {
            if (world.func_147439_a(x, y, z + 1) == this || ChromaTiles.getTile(world, x, y, z + 1) == ChromaTiles.TANK) {
                li.remove(new Integer(2));
            }
            if (world.func_147439_a(x, y, z - 1) == this || ChromaTiles.getTile(world, x, y, z - 1) == ChromaTiles.TANK) {
                li.remove(new Integer(8));
            }
            if (world.func_147439_a(x, y + 1, z) == this || ChromaTiles.getTile(world, x, y + 1, z) == ChromaTiles.TANK) {
                li.remove(new Integer(4));
            }
            if (world.func_147439_a(x, y - 1, z) == this || ChromaTiles.getTile(world, x, y - 1, z) == ChromaTiles.TANK) {
                li.remove(new Integer(6));
            }
            if (world.func_147439_a(x, y + 1, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(new Integer(1));
            }
            if (world.func_147439_a(x, y - 1, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(new Integer(9));
            }
            if (world.func_147439_a(x, y + 1, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(new Integer(7));
            }
            if (world.func_147439_a(x, y - 1, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(new Integer(3));
            }
        }
        if (face.offsetY != 0) {
            if (world.func_147439_a(x, y, z + 1) == this || ChromaTiles.getTile(world, x, y, z + 1) == ChromaTiles.TANK) {
                li.remove(new Integer(2));
            }
            if (world.func_147439_a(x, y, z - 1) == this || ChromaTiles.getTile(world, x, y, z - 1) == ChromaTiles.TANK) {
                li.remove(new Integer(8));
            }
            if (world.func_147439_a(x + 1, y, z) == this || ChromaTiles.getTile(world, x + 1, y, z) == ChromaTiles.TANK) {
                li.remove(new Integer(4));
            }
            if (world.func_147439_a(x - 1, y, z) == this || ChromaTiles.getTile(world, x - 1, y, z) == ChromaTiles.TANK) {
                li.remove(new Integer(6));
            }
            if (world.func_147439_a(x + 1, y, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(new Integer(1));
            }
            if (world.func_147439_a(x - 1, y, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(new Integer(9));
            }
            if (world.func_147439_a(x + 1, y, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(new Integer(7));
            }
            if (world.func_147439_a(x - 1, y, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(new Integer(3));
            }
        }
        if (face.offsetZ != 0) {
            if (world.func_147439_a(x, y + 1, z) == this || ChromaTiles.getTile(world, x, y + 1, z) == ChromaTiles.TANK) {
                li.remove(new Integer(4));
            }
            if (world.func_147439_a(x, y - 1, z) == this || ChromaTiles.getTile(world, x, y - 1, z) == ChromaTiles.TANK) {
                li.remove(new Integer(6));
            }
            if (world.func_147439_a(x + 1, y, z) == this || ChromaTiles.getTile(world, x + 1, y, z) == ChromaTiles.TANK) {
                li.remove(new Integer(2));
            }
            if (world.func_147439_a(x - 1, y, z) == this || ChromaTiles.getTile(world, x - 1, y, z) == ChromaTiles.TANK) {
                li.remove(new Integer(8));
            }
            if (world.func_147439_a(x + 1, y + 1, z) == this && !li.contains(2) && !li.contains(4)) {
                li.remove(new Integer(1));
            }
            if (world.func_147439_a(x - 1, y - 1, z) == this && !li.contains(8) && !li.contains(6)) {
                li.remove(new Integer(9));
            }
            if (world.func_147439_a(x + 1, y - 1, z) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(new Integer(3));
            }
            if (world.func_147439_a(x - 1, y + 1, z) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(new Integer(7));
            }
        }
        if (!(li.contains(2) || li.contains(4) || li.contains(6) || li.contains(8) || (x + z) % 2 == 0)) {
            li.remove(new Integer(5));
        }
        return li;
    }

    public IIcon getIconForEdge(IBlockAccess world, int x, int y, int z, int edge) {
        return this.edges[edge];
    }

    public IIcon getIconForEdge(int itemMeta, int edge) {
        return this.edges[edge];
    }

    public boolean renderCentralTextureForItem(int meta) {
        return false;
    }

    public final boolean func_149740_M() {
        return true;
    }

    public final int func_149736_g(World world, int x, int y, int z, int par5) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        TileEntityCrystalTank con = te.getTankController();
        return con != null ? con.getRedstoneOverride() : 0;
    }

    public static class CrystalTankAuxTile
    extends TileEntity
    implements IFluidHandler {
        private int tileX = Integer.MIN_VALUE;
        private int tileY = Integer.MIN_VALUE;
        private int tileZ = Integer.MIN_VALUE;

        public boolean canUpdate() {
            return false;
        }

        public void setTile(TileEntityCrystalTank te) {
            this.tileX = te.field_145851_c;
            this.tileY = te.field_145848_d;
            this.tileZ = te.field_145849_e;
        }

        public void addToTank() {
            TileEntityCrystalTank te = this.getTankController();
            if (te != null) {
                te.addCoordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        public void removeFromTank() {
            TileEntityCrystalTank te = this.getTankController();
            if (te != null) {
                te.removeCoordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.reset();
        }

        public void reset() {
            this.tileZ = Integer.MIN_VALUE;
            this.tileY = Integer.MIN_VALUE;
            this.tileX = Integer.MIN_VALUE;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 3);
        }

        public boolean hasTile() {
            return this.tileY != Integer.MIN_VALUE && this.getTankController() != null;
        }

        public TileEntityCrystalTank getTankController() {
            TileEntity te = this.field_145850_b.func_147438_o(this.tileX, this.tileY, this.tileZ);
            return te instanceof TileEntityCrystalTank ? (TileEntityCrystalTank)te : null;
        }

        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.fill(from, resource, doFill) : 0;
        }

        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.drain(from, resource, doDrain) : null;
        }

        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.drain(from, maxDrain, doDrain) : null;
        }

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null && te.canFill(from, fluid);
        }

        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null && te.canDrain(from, fluid);
        }

        public FluidTankInfo[] getTankInfo(ForgeDirection from) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.getTankInfo(from) : new FluidTankInfo[]{};
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("tx", this.tileX);
            NBT.func_74768_a("ty", this.tileY);
            NBT.func_74768_a("tz", this.tileZ);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.tileX = NBT.func_74762_e("tx");
            this.tileY = NBT.func_74762_e("ty");
            this.tileZ = NBT.func_74762_e("tz");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
        }
    }
}

