/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ProgressionTrigger;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Block.BlockCrystalTile;
import Reika.ChromatiCraft.Magic.Interfaces.NaturalNetworkTile;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntitySkypeater;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.TileEntity.TileEntityPersonalCharger;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.TileEntity.PlayerBreakHook;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrystalPylon
extends BlockCrystalTile
implements ProgressionTrigger,
SemiUnbreakable {
    public BlockCrystalPylon(Material mat) {
        super(mat);
    }

    @Override
    public int func_149701_w() {
        return 1;
    }

    @Override
    public final int getLightValue(IBlockAccess iba, int x, int y, int z) {
        TileEntity te = iba.func_147438_o(x, y, z);
        int color = te instanceof TileEntityCrystalPylon ? ((TileEntityCrystalPylon)te).getColor().getColor() : 0xFFFFFF;
        color = te instanceof TileEntityDimensionCore ? ((TileEntityDimensionCore)te).getColor().getColor() : color;
        color = te instanceof TileEntityPersonalCharger ? ((TileEntityPersonalCharger)te).getColor().getColor() : color;
        int b = te instanceof TileEntityStructControl ? ((TileEntityStructControl)te).getBrightness() : 15;
        b = te instanceof TileEntitySkypeater ? 0 : b;
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)b) : b;
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (c == null) {
            return null;
        }
        switch (c) {
            case PYLON: 
            case STRUCTCONTROL: 
            case AURAPOINT: 
            case DIMENSIONCORE: 
            case PERSONAL: 
            case SKYPEATER: {
                return null;
            }
        }
        return this.getBlockAABB(x, y, z);
    }

    @Override
    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntityBase te = (TileEntityBase)world.func_147438_o(x, y, z);
        if (te instanceof NaturalNetworkTile) {
            return -1.0f;
        }
        if (te instanceof PlayerBreakHook && !((PlayerBreakHook)te).isBreakable(ep)) {
            return -1.0f;
        }
        if (te instanceof TileEntityStructControl) {
            return super.func_149737_a(ep, world, x, y, z) * 32.0f;
        }
        if (te instanceof TileEntityDimensionCore) {
            return super.func_149737_a(ep, world, x, y, z) * 8.0f;
        }
        return super.func_149737_a(ep, world, x, y, z);
    }

    @Override
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.func_149691_a(s, iba.func_72805_g(x, y, z));
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        switch (meta) {
            case 0: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 1: {
                return ChromaIcons.REPEATER.getIcon();
            }
            case 2: {
                return ChromaIcons.MULTIREPEATER.getIcon();
            }
            case 3: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 4: {
                return ChromaIcons.CHROMA.getIcon();
            }
            case 5: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 6: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 7: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 8: {
                return ChromaIcons.BROADCAST.getIcon();
            }
            case 9: {
                return ChromaIcons.WEAKREPEATER.getIcon();
            }
            case 11: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    public ProgressionManager.ProgressStage[] getTriggers(EntityPlayer ep, World world, int x, int y, int z) {
        ProgressionManager.ProgressStage[] progressStageArray;
        boolean pylon;
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        boolean bl = pylon = c == ChromaTiles.PYLON && ((TileEntityCrystalPylon)world.func_147438_o(x, y, z)).canConduct();
        if (pylon) {
            ProgressionManager.ProgressStage[] progressStageArray2 = new ProgressionManager.ProgressStage[1];
            progressStageArray = progressStageArray2;
            progressStageArray2[0] = ProgressionManager.ProgressStage.PYLON;
        } else {
            progressStageArray = null;
        }
        return progressStageArray;
    }

    public boolean isUnbreakable(World world, int x, int y, int z, int meta) {
        TileEntityBase te = (TileEntityBase)world.func_147438_o(x, y, z);
        if (te instanceof NaturalNetworkTile) {
            return true;
        }
        if (te instanceof PlayerBreakHook) {
            return !((PlayerBreakHook)te).isBreakable(null);
        }
        return false;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return ChromaTiles.getTile((IBlockAccess)world, x, y, z) == ChromaTiles.WEAKREPEATER && side == ForgeDirection.UP;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        ChromaTiles c = ChromaTiles.getTile(world, x, y, z);
        switch (c) {
            case REPEATER: 
            case COMPOUND: 
            case WEAKREPEATER: {
                return dir == ForgeDirection.UP;
            }
        }
        return false;
    }
}

