/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.ChromaTeleporter;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityBallLightningFX;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockChromaPortal
extends Block {
    private static final HashSet<Coordinate> portalCheck = new HashSet();

    public BlockChromaPortal(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.func_149752_b(50000.0f);
        this.func_149722_s();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityCrystalPortal();
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        TileEntityCrystalPortal te;
        if (ChromaItems.TOOL.matchWith(ep.func_71045_bC()) && (te = (TileEntityCrystalPortal)world.func_147438_o(x, y, z)).ownedBy(ep)) {
            for (int i = -2; i <= 2; ++i) {
                for (int k = -2; k <= 2; ++k) {
                    if (world.func_147439_a(x + i, y, z + k) != Blocks.field_150480_ab) continue;
                    world.func_147449_b(x + i, y, z + k, Blocks.field_150350_a);
                }
            }
            BlockArray bk = new BlockArray();
            bk.recursiveAddWithBounds(world, x, y, z, (Block)this, x - 16, y - 8, z - 16, x + 16, y + 8, z + 16);
            for (Coordinate loc : bk.keySet()) {
                loc.setBlock(world, Blocks.field_150350_a);
                ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)new ItemStack((Block)this));
            }
            ChromaSounds.RIFT.playSoundAtBlock(te);
            ChromaSounds.POWERDOWN.playSoundAtBlock(te);
        }
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        portalCheck.add(new Coordinate(x, y, z));
        for (int i = 2; i < 6; ++i) {
            int ddz;
            int ddx;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dz = z + dir.offsetZ;
            if (world.func_147439_a(dx, y, dz) == this || world.func_147439_a(ddx = x - dir.offsetX, y, ddz = z - dir.offsetZ) != this || portalCheck.contains(new Coordinate(ddx, y, ddz))) continue;
            this.func_149670_a(world, ddx, y, ddz, e);
            portalCheck.remove(new Coordinate(x, y, z));
            return;
        }
        portalCheck.remove(new Coordinate(x, y, z));
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityCrystalPortal && !world.field_72995_K) {
            TileEntityCrystalPortal te = (TileEntityCrystalPortal)tile;
            if (e instanceof EntityPlayer) {
                if (te.complete) {
                    EntityPlayer ep = (EntityPlayer)e;
                    if (te.canPlayerUse(ep)) {
                        int dim = te.getTargetDimension();
                        ReikaEntityHelper.transferEntityToDimension((Entity)e, (int)dim, (Teleporter)new ChromaTeleporter(dim));
                        if (ProgressionManager.ProgressStage.DIMENSION.stepPlayerTo(ep)) {
                            ReikaSoundHelper.broadcastSound((SoundEnum)ChromaSounds.GOTODIM, (String)"ChromaData", (float)1.0f, (float)1.0f);
                        } else {
                            ChromaSounds.GOTODIM.playSoundAtBlockNoAttenuation(te, 1.0f, 1.0f, 32);
                            ReikaSoundHelper.playSound((SoundEnum)ChromaSounds.GOTODIM, (String)"ChromaData", (World)ep.field_70170_p, (double)0.0, (double)1024.0, (double)0.0, (float)1.0f, (float)1.0f, (boolean)false);
                            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.DIMSOUND.ordinal(), (PacketTarget)PacketTarget.allPlayers, (int[])new int[0]);
                        }
                    } else {
                        this.denyEntity(e);
                    }
                } else {
                    this.denyEntity(e);
                }
            } else {
                this.denyEntity(e);
            }
        }
    }

    private void denyEntity(Entity e) {
        e.field_70181_x = 1.5;
        e.field_70143_R = Math.max(e.field_70143_R, 500.0f);
        e.func_70024_g(ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25), 0.0, ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.25));
        e.field_70133_I = true;
        ChromaSounds.POWERDOWN.playSound(e);
    }

    public static boolean isPortalFunctional() {
        return ChunkProviderChroma.areGeneratorsReady() && ChromatiCraft.instance.isDimensionLoadable();
    }

    public static class TileEntityCrystalPortal
    extends TileEntity {
        private boolean complete;
        private int charge;
        public final int MINCHARGE = 300;
        private int ticks = 0;
        private UUID placerUUID;

        public void func_145845_h() {
            if (this.ticks == 0) {
                this.onFirstTick();
            }
            ++this.ticks;
            if (DragonAPICore.debugtest) {
                // empty if block
            }
            if (this.complete) {
                if (this.charge < 300 || !ChunkProviderChroma.areGeneratorsReady()) {
                    ++this.charge;
                    if (this.field_145850_b.field_72995_K) {
                        this.chargingParticles();
                    }
                }
            } else {
                this.charge = 0;
            }
            int pos = this.getPortalPosition((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.field_145850_b.field_72995_K && pos == 5 && this.isFull9x9()) {
                if (this.field_145850_b.field_72995_K) {
                    this.idleParticles();
                }
                if (this.complete && this.charge >= 300 && this.field_145850_b.field_72995_K) {
                    this.activeParticles();
                }
            }
            if (pos == 5 && this.isFull9x9()) {
                if (this.ticks % 20 == 0) {
                    this.validateStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.complete && this.ticks % 90 == 0) {
                    ChromaSounds.PORTAL.playSoundAtBlock(this);
                }
            }
        }

        public boolean ownedBy(EntityPlayer ep) {
            return this.placerUUID == null || this.placerUUID.equals(ep.func_110124_au());
        }

        public int getTargetDimension() {
            return this.func_145832_p() == 15 ? 0 : ExtraChromaIDs.DIMID.getValue();
        }

        public boolean canPlayerUse(EntityPlayer ep) {
            return BlockChromaPortal.isPortalFunctional() && this.charge >= 300 && ProgressionManager.instance.playerHasPrerequisites(ep, ProgressionManager.ProgressStage.DIMENSION);
        }

        public int getTicks() {
            return this.ticks;
        }

        public int getCharge() {
            return this.charge;
        }

        public boolean isComplete() {
            return this.complete;
        }

        @SideOnly(value=Side.CLIENT)
        private void idleParticles() {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145851_c + 0.5), (double)1.5);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145849_e + 0.5), (double)1.5);
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625));
            int color = CrystalElement.getBlendedColor(this.ticks, 40);
            int l = ReikaRandomHelper.getRandomPlusMinus((int)80, (int)40);
            EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, px, (double)this.field_145848_d + 1.25, pz, 0.0, 0.0, 0.0).setGravity(g).setLife(l).setColor(color);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }

        @SideOnly(value=Side.CLIENT)
        private void chargingParticles() {
            int dz;
            int z;
            int y;
            int dx;
            int x;
            if (this.field_145850_b.field_73012_v.nextInt(4) == 0 && this.field_145850_b.func_147439_a(x = this.field_145851_c + (dx = this.field_145850_b.field_73012_v.nextBoolean() ? 3 : -3), y = this.field_145848_d + 5, z = this.field_145849_e + (dz = this.field_145850_b.field_73012_v.nextBoolean() ? 3 : -3)) == ChromaBlocks.PYLONSTRUCT.getBlockInstance() && this.field_145850_b.func_72805_g(x, y, z) == 5) {
                double px = (double)x + this.field_145850_b.field_73012_v.nextDouble();
                double py = (double)y + this.field_145850_b.field_73012_v.nextDouble();
                double pz = (double)z + this.field_145850_b.field_73012_v.nextDouble();
                EntityBallLightningFX fx = new EntityBallLightningFX(this.field_145850_b, px, py, pz, CrystalElement.elements[this.ticks / 8 % 16]);
                fx.field_70145_X = false;
                double v = 0.125;
                double vx = v * (double)(-Math.signum(dx));
                double vy = -0.125;
                double vz = v * (double)(-Math.signum(dz));
                fx.field_70159_w = vx;
                fx.field_70181_x = vy;
                fx.field_70179_y = vz;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void activeParticles() {
            CrystalElement e = CrystalElement.elements[this.ticks / 8 % 16];
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625));
            EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 8.25, (double)this.field_145849_e + 0.5, vx, 0.0, vz).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            int dx = this.field_145850_b.field_73012_v.nextBoolean() ? 3 : -3;
            int dz = this.field_145850_b.field_73012_v.nextBoolean() ? 3 : -3;
            double x = (double)(this.field_145851_c + dx) + this.field_145850_b.field_73012_v.nextDouble();
            double y = (double)(this.field_145848_d + 5) + this.field_145850_b.field_73012_v.nextDouble();
            double z = (double)(this.field_145849_e + dz) + this.field_145850_b.field_73012_v.nextDouble();
            double v = 0.0625;
            vx = x < (double)this.field_145851_c ? v : -v;
            double d = vz = z < (double)this.field_145849_e ? v : -v;
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                vx = 0.0;
            } else {
                vz = 0.0;
            }
            EntityCenterBlurFX fx2 = new EntityCenterBlurFX(e, this.field_145850_b, x, y, z, vx, 0.0, vz).setScale(2.0f).setNoSlowdown();
            fx2.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            dx = this.field_145850_b.field_73012_v.nextBoolean() ? 7 : -7;
            int n = dz = this.field_145850_b.field_73012_v.nextBoolean() ? 7 : -7;
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                dx = (int)((float)dx + Math.signum(dx) * -4.0f);
            } else {
                dz = (int)((float)dz + Math.signum(dz) * -4.0f);
            }
            x = (double)(this.field_145851_c + dx) + this.field_145850_b.field_73012_v.nextDouble();
            y = (double)(this.field_145848_d + 5) + this.field_145850_b.field_73012_v.nextDouble();
            z = (double)(this.field_145849_e + dz) + this.field_145850_b.field_73012_v.nextDouble();
            v = 0.0625;
            vx = x < (double)this.field_145851_c ? v : -v;
            double d2 = vz = z < (double)this.field_145849_e ? v : -v;
            if (this.field_145850_b.field_73012_v.nextBoolean()) {
                vx = 0.0;
            } else {
                vz = 0.0;
            }
            boolean longAxis = Math.abs(dx) == 7 && vx != 0.0 || Math.abs(dz) == 7 && vz != 0.0;
            int l = !longAxis ? 100 : 60;
            EntityRuneFX fx3 = new EntityRuneFX(this.field_145850_b, x, y, z, vx, 0.0, vz, e).setScale(2.0f).setLife(l);
            fx3.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx3);
        }

        public boolean canUpdate() {
            return true;
        }

        private void onFirstTick() {
            this.validateStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public void validateStructure(World world, int x, int y, int z) {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean last = this.complete;
            if (this.func_145832_p() == 15) {
                this.complete = true;
            } else {
                this.complete = ChromaStructures.getPortalStructure(world, x, y, z, false).matchInWorld();
                this.complete &= this.getEntities(world, x, y, z);
            }
            if (last != this.complete) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        private boolean getEntities(World world, int x, int y, int z) {
            int[][] pos = new int[][]{{-5, 5, -9}, {-5, 5, 9}, {5, 5, -9}, {5, 5, 9}, {-9, 5, -5}, {-9, 5, 5}, {9, 5, -5}, {9, 5, 5}};
            for (int i = 0; i < pos.length; ++i) {
                int[] loc = pos[i];
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)(x + loc[0]), (int)(y + loc[1]), (int)(z + loc[2]));
                if (world.func_72872_a(EntityEnderCrystal.class, box).size() == 1) continue;
                return false;
            }
            return true;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("built", this.complete);
            NBT.func_74768_a("charge", this.charge);
            if (this.placerUUID != null) {
                NBT.func_74778_a("owner", this.placerUUID.toString());
            }
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.complete = NBT.func_74767_n("built");
            this.charge = NBT.func_74762_e("charge");
            String s = NBT.func_74779_i("owner");
            if (s != null && !s.isEmpty()) {
                this.placerUUID = UUID.fromString(s);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean shouldRenderInPass(int pass) {
            return pass <= 1;
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(8.0, 8.0, 8.0);
        }

        public int getPortalPosition(IBlockAccess world, int x, int y, int z) {
            if (world.func_147439_a(x - 1, y, z) != ChromaBlocks.PORTAL.getBlockInstance()) {
                if (world.func_147439_a(x, y, z - 1) != ChromaBlocks.PORTAL.getBlockInstance()) {
                    return 7;
                }
                if (world.func_147439_a(x, y, z + 1) != ChromaBlocks.PORTAL.getBlockInstance()) {
                    return 1;
                }
                return 4;
            }
            if (world.func_147439_a(x + 1, y, z) != ChromaBlocks.PORTAL.getBlockInstance()) {
                if (world.func_147439_a(x, y, z - 1) != ChromaBlocks.PORTAL.getBlockInstance()) {
                    return 9;
                }
                if (world.func_147439_a(x, y, z + 1) != ChromaBlocks.PORTAL.getBlockInstance()) {
                    return 3;
                }
                return 6;
            }
            if (world.func_147439_a(x, y, z - 1) != ChromaBlocks.PORTAL.getBlockInstance()) {
                return 8;
            }
            if (world.func_147439_a(x, y, z + 1) != ChromaBlocks.PORTAL.getBlockInstance()) {
                return 2;
            }
            return 5;
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean isFull9x9() {
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d, this.field_145849_e + k) == ChromaBlocks.PORTAL.getBlockInstance()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

