/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class TileEntityCrystalBase
extends TileEntityChromaticBase
implements CrystalNetworkTile {
    private UUID uniqueID = CrystalNetworker.instance.getNewUniqueID();

    protected void onFirstTick(World world, int x, int y, int z) {
        this.cachePosition();
    }

    @Override
    public final void cachePosition() {
        CrystalNetworker.instance.addTile(this);
    }

    @Override
    public final void removeFromCache() {
        CrystalNetworker.instance.removeTile(this);
    }

    @Override
    public final double getDistanceSqTo(double x, double y, double z) {
        double dx = x - (double)this.field_145851_c;
        double dy = y - (double)this.field_145848_d;
        double dz = z - (double)this.field_145849_e;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getX() {
        return this.field_145851_c;
    }

    @Override
    public final int getY() {
        return this.field_145848_d;
    }

    @Override
    public final int getZ() {
        return this.field_145849_e;
    }

    public int getUpdatePacketRadius() {
        return 512;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74778_a("netuid", this.uniqueID.toString());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.uniqueID = NBT.func_74764_b("netuid") ? UUID.fromString(NBT.func_74779_i("netuid")) : CrystalNetworker.instance.getNewUniqueID();
    }

    @Override
    public final UUID getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public final UUID getPlacerUUID() {
        EntityPlayer ep = this.getPlacer();
        return ep != null ? ep.func_110124_au() : null;
    }

    public double getIncomingBeamRadius() {
        return 0.35;
    }

    public double getOutgoingBeamRadius() {
        return 0.35;
    }

    public void onPathCompleted(CrystalFlow p) {
    }

    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
    }

    public void onPathConnected(CrystalPath p) {
    }

    public boolean canConductInterdimensionally() {
        return false;
    }
}

