/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Instantiable.StepTimer;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityAreaDistributor
extends TileEntityChromaticBase
implements RangeUpgradeable {
    public static final int SCAN_RADIUS_XZ = 16;
    private int scanRange;
    private final StepTimer cacheTimer = new StepTimer(40);
    private final HashSet<WorldLocation> storages = new HashSet();
    private final HashSet<WorldLocation> inputs = new HashSet();
    private final TimerMap<WorldLocation> particleCooldowns = new TimerMap();

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.cacheTimer.update();
        if (this.cacheTimer.checkCap() || this.getTicksExisted() == 0) {
            this.scanAndCache(world, x, y, z);
        }
        if (world.field_72995_K) {
            this.particleCooldowns.tick();
        }
    }

    protected final void addInput(WorldLocation loc) {
        this.inputs.add(loc);
        this.storages.remove(loc);
    }

    private void addStorage(WorldLocation loc) {
        if (!this.inputs.contains(loc)) {
            this.storages.add(loc);
        }
    }

    protected final Iterator<WorldLocation> getTargets() {
        return this.storages.iterator();
    }

    private void scanAndCache(World world, int x, int y, int z) {
        int r = this.scanRange;
        int r2 = r / 2;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int j = -r2; j <= 0; ++j) {
                    TileEntity te = world.func_147438_o(x + i, y + j, z + k);
                    if (!this.isValidTarget(te)) continue;
                    this.addStorage(new WorldLocation(te));
                }
            }
        }
        this.scanRange = 16;
    }

    protected abstract boolean isValidTarget(TileEntity var1);

    protected final boolean trySendParticle(WorldLocation loc) {
        if (!this.particleCooldowns.containsKey((Object)loc)) {
            this.particleCooldowns.put((Object)loc, 3 + rand.nextInt(8));
            return true;
        }
        return false;
    }

    @Override
    public final void upgradeRange(double r) {
        this.scanRange = (int)(16.0 * r);
    }

    @Override
    public final int getRange() {
        return this.scanRange;
    }
}

