/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityWirelessPowered;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAdjacencyUpgrade
extends TileEntityWirelessPowered
implements NBTTile,
SneakPop {
    public static final int MAX_TIER = 8;
    private int tier;
    private boolean particles = true;
    private int soundtick = 0;

    public final int getTier() {
        return this.tier;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return e == this.getColor() ? 6000 + (1 + this.tier) * (1 + this.tier) * 1000 : 0;
    }

    @Override
    protected int getReceiveRange(CrystalElement e) {
        return e == this.getColor() ? 16 : 0;
    }

    public final boolean hasSufficientEnergy() {
        return this.energy.getValue(this.getColor()) >= this.getConsumedEnergy();
    }

    public final int getConsumedEnergy() {
        return ChromaOptions.POWEREDACCEL.getState() ? Math.max(1, ReikaMathLibrary.intpow2((int)(this.tier + 1), (int)2) / 4) : 0;
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        if (!this.canRun(world, x, y, z)) {
            this.soundtick = 0;
            return;
        }
        if (this.particles && world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
        ++this.soundtick;
        float f = 1.0f + (float)(1 + this.getTier()) / 8.0f;
        int l = (int)(221.0f / f);
        if (this.soundtick % l == 0) {
            ChromaSounds.DRONE.playSoundAtBlock(world, x, y, z, 0.25f, f);
        }
        if (ChromaOptions.POWEREDACCEL.getState() && this.getTicksExisted() % 8 == 0) {
            CrystalElement e = this.getColor();
            if (this.energy.getValue(e) < this.getMaxStorage(e)) {
                this.requestEnergy(this.getColor(), this.getMaxStorage(e) - this.energy.getValue(e));
            }
            if (this.hasSufficientEnergy()) {
                this.energy.subtract(e, this.getConsumedEnergy());
            } else {
                return;
            }
        }
        if (this.ticksIndividually()) {
            ForgeDirection dir;
            long time = System.nanoTime();
            for (int i = 0; i < 6 && this.tickDirection(world, x, y, z, dir = this.dirs[i], time); ++i) {
            }
        } else {
            this.doCollectiveTick(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        int p2 = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(1 + p2) == 0) {
            int p = this.getTier() > 0 ? (this.getTier() + 1) / 2 : (rand.nextBoolean() ? 1 : 0);
            for (int i = 0; i < p; ++i) {
                double dx = rand.nextDouble();
                double dy = rand.nextDouble();
                double dz = rand.nextDouble();
                double v = 0.125;
                double vx = v * (dx - 0.5);
                double vy = v * (dy - 0.5);
                double vz = v * (dz - 0.5);
                dx = (double)(x - 2) + dx * 4.0;
                dy = (double)(y - 2) + dy * 4.0;
                dz = (double)(z - 2) + dz * 4.0;
                vx = -(dx - (double)x) / 8.0;
                vy = -(dy - (double)y) / 8.0;
                vz = -(dz - (double)z) / 8.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySparkleFX(world, dx + 0.5, dy + 0.5, dz + 0.5, vx, vy, vz));
            }
        }
    }

    protected abstract boolean tickDirection(World var1, int var2, int var3, int var4, ForgeDirection var5, long var6);

    public boolean canRun(World world, int x, int y, int z) {
        return !this.hasRedstoneSignal();
    }

    protected boolean ticksIndividually() {
        return true;
    }

    protected void doCollectiveTick(World world, int x, int y, int z) {
    }

    public abstract CrystalElement getColor();

    @Override
    public final void setDataFromItemStackTag(ItemStack is) {
        super.setDataFromItemStackTag(is);
        if (ChromaItems.ADJACENCY.matchWith(is) && is.field_77990_d != null) {
            this.tier = is.field_77990_d.func_74762_e("tier");
        }
    }

    @Override
    public final void getTagsToWriteToStack(NBTTagCompound NBT) {
        super.getTagsToWriteToStack(NBT);
        NBT.func_74768_a("tier", this.getTier());
    }

    @Override
    protected final void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tier = NBT.func_74762_e("tier");
        this.energy.readFromNBT("energy", NBT);
    }

    @Override
    protected final void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("tier", this.tier);
    }

    @Override
    public final void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74757_a("particle", this.particles);
    }

    @Override
    public final void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.particles = NBT.func_74767_n("particle");
    }

    @Override
    public final void drop() {
        ItemStack is = ChromaItems.ADJACENCY.getStackOf(this.getColor());
        is.field_77990_d = new NBTTagCompound();
        this.getTagsToWriteToStack(is.field_77990_d);
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public final boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    @Override
    public final ChromaTiles getTile() {
        return ChromaTiles.ADJACENCY;
    }

    public static HashMap<CrystalElement, Integer> getAdjacentUpgrades(TileEntityBase core) {
        HashMap<CrystalElement, Integer> set = new HashMap<CrystalElement, Integer>();
        for (int i = 0; i < 6; ++i) {
            TileEntity te = core.getAdjacentTileEntity(ForgeDirection.VALID_DIRECTIONS[i]);
            if (!(te instanceof TileEntityAdjacencyUpgrade)) continue;
            TileEntityAdjacencyUpgrade ta = (TileEntityAdjacencyUpgrade)te;
            Integer get = set.get((Object)ta.getColor());
            int has = get != null ? get : 0;
            set.put(ta.getColor(), Math.max(1 + ta.getTier(), has));
        }
        return set;
    }

    public static HashMap<CrystalElement, Integer> getAdjacentUpgrades(World world, int x, int y, int z) {
        HashMap<CrystalElement, Integer> set = new HashMap<CrystalElement, Integer>();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (!(te instanceof TileEntityAdjacencyUpgrade)) continue;
            TileEntityAdjacencyUpgrade ta = (TileEntityAdjacencyUpgrade)te;
            Integer get = set.get((Object)ta.getColor());
            int has = get != null ? get : 0;
            set.put(ta.getColor(), Math.max(1 + ta.getTier(), has));
        }
        return set;
    }
}

