/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.LinkedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Base.BlockTEBase;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LinkedTileBase
extends TileEntityChromaticBase
implements SneakPop,
LinkedTile {
    private WorldLocation target;
    private boolean shouldDrop;
    private boolean primary;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.shouldDrop) {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)this.getTile().getCraftedProduct());
            this.delete();
        }
    }

    @Override
    public final void drop() {
        this.shouldDrop = true;
        LinkedTile te = this.getOther();
        if (te != null) {
            te.markForDrop();
        }
        this.reset();
    }

    public final boolean isLinked() {
        return this.target != null;
    }

    public abstract boolean canLinkTo(World var1, int var2, int var3, int var4);

    @Override
    public final boolean linkTo(World world, int x, int y, int z) {
        if (!world.field_72995_K && this.canLinkTo(world, x, y, z)) {
            this.resetOther();
            this.target = new WorldLocation(world, x, y, z);
            this.createRandomLinkID();
            LinkedTile te = this.getOther();
            te.setTarget(new WorldLocation(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            te.assignLinkID(this);
            this.onLink(true);
            this.onLinkTo(world, x, y, z, te);
            return true;
        }
        return false;
    }

    protected abstract void createRandomLinkID();

    @Override
    public abstract void assignLinkID(LinkedTile var1);

    protected void onLinkTo(World world, int x, int y, int z, LinkedTile te) {
    }

    @Override
    public final void onLink(boolean other) {
        ChromaSounds.RIFT.playSoundAtBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = this.field_145851_c + dir.offsetX;
            int dy = this.field_145848_d + dir.offsetY;
            int dz = this.field_145849_e + dir.offsetZ;
            Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
            if (!(b instanceof BlockTEBase)) continue;
            ((BlockTEBase)b).updateTileCache(this.field_145850_b, dx, dy, dz);
        }
        if (other && this.isLinked()) {
            this.getOther().onLink(false);
        }
    }

    @Override
    public final boolean linkTo(WorldLocation loc) {
        return !loc.equals(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.linkTo(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    @Override
    public final void reset() {
        this.resetOther();
        this.target = null;
        this.onReset();
        this.onLink(true);
    }

    public final void resetOther() {
        LinkedTile te;
        if (this.isLinked() && (te = this.getOther()) != null) {
            te.setTarget(null);
            this.onResetOther(te);
            this.onLink(true);
        }
    }

    protected void onReset() {
    }

    protected void onResetOther(LinkedTile te) {
    }

    private LinkedTile getOther() {
        return this.isLinked() ? (LinkedTile)this.target.getTileEntity() : null;
    }

    public final WorldLocation getLinkTarget() {
        return this.target;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.isLinked()) {
            this.target.writeToNBT("target", NBT);
        }
        NBT.func_74757_a("primary", this.primary);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("target")) {
            this.target = WorldLocation.readFromNBT((String)"target", (NBTTagCompound)NBT);
        }
        this.primary = NBT.func_74767_n("primary");
    }

    @Override
    public final boolean isPrimary() {
        return this.primary;
    }

    public final void setPrimary() {
        this.primary = true;
        this.syncAllData(false);
        LinkedTile te = this.getOther();
        if (te != null) {
            te.setPrimary(false);
            te.syncAllData(false);
        }
    }

    @Override
    public final void setPrimary(boolean flag) {
        if (flag) {
            this.setPrimary();
        } else {
            this.primary = flag;
        }
    }

    @Override
    public final void markForDrop() {
        this.shouldDrop = true;
    }

    @Override
    public final void setTarget(WorldLocation loc) {
        this.target = loc;
    }
}

