/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityCrystalBase;
import Reika.ChromatiCraft.Magic.CrystalTarget;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class CrystalTransmitterBase
extends TileEntityCrystalBase
implements CrystalTransmitter {
    private ArrayList<CrystalTarget> targets = new ArrayList();
    private ArrayList<CrystalTarget.TickingCrystalTarget> tickingTargets = new ArrayList();
    public int renderAlpha;

    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.renderAlpha > 0) {
            this.renderAlpha -= 4;
        }
        if (this.renderAlpha < 0) {
            this.renderAlpha = 0;
        }
    }

    @Override
    public final void addTarget(WorldLocation loc, CrystalElement e, double dx, double dy, double dz, double w) {
        CrystalTarget tg = new CrystalTarget(loc, e, dx, dy, dz, w);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.targets.contains(tg)) {
                this.targets.add(tg);
            }
            this.onTargetChanged();
        }
    }

    @Override
    public final void addSelfTickingTarget(WorldLocation loc, CrystalElement e, double dx, double dy, double dz, double w, int duration) {
        CrystalTarget.TickingCrystalTarget tg = new CrystalTarget.TickingCrystalTarget(loc, e, dx, dy, dz, w, duration);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.targets.contains(tg)) {
                this.targets.add(tg);
                this.tickingTargets.add(tg);
            }
            this.onTargetChanged();
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!this.targets.isEmpty() && world.field_72995_K) {
            ChromaFX.drawLeyLineParticles(world, x, y, z, this.getOutgoingBeamRadius(), this.targets);
        }
        this.tickTargets();
    }

    private void tickTargets() {
        if (!this.field_145850_b.field_72995_K && !this.tickingTargets.isEmpty()) {
            Iterator<CrystalTarget.TickingCrystalTarget> it = this.tickingTargets.iterator();
            while (it.hasNext()) {
                CrystalTarget.TickingCrystalTarget t = it.next();
                if (!t.tick()) continue;
                it.remove();
                this.targets.remove(t);
                this.syncAllData(true);
            }
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.targets.clear();
    }

    private void onTargetChanged() {
        this.renderAlpha = 512;
        this.syncAllData(true);
    }

    @Override
    public final void removeTarget(WorldLocation loc, CrystalElement e) {
        if (!this.field_145850_b.field_72995_K) {
            this.targets.remove(new CrystalTarget(loc, e, 0.0));
            this.onTargetChanged();
        }
    }

    @Override
    public final void clearTargets(boolean unload) {
        if (!this.field_145850_b.field_72995_K) {
            this.targets.clear();
            if (!unload) {
                this.onTargetChanged();
            }
        }
    }

    @Override
    public final Collection<CrystalTarget> getTargets() {
        return Collections.unmodifiableCollection(this.targets);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.targets = new ArrayList();
        int num = NBT.func_74762_e("targetcount");
        for (int i = 0; i < num; ++i) {
            CrystalTarget tg = CrystalTarget.readFromNBT("target" + i, NBT);
            if (tg == null) continue;
            this.targets.add(tg);
        }
        this.renderAlpha = NBT.func_74762_e("alpha");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("targetcount", this.targets.size());
        for (int i = 0; i < this.targets.size(); ++i) {
            this.targets.get(i).writeToNBT("target" + i, NBT);
        }
        NBT.func_74768_a("alpha", this.renderAlpha);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return !this.targets.isEmpty() ? INFINITE_EXTENT_AABB : super.getRenderBoundingBox();
    }

    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }
}

