/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityCrystalBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.LumenRequestingTile;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.StepTimer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class CrystalReceiverBase
extends TileEntityCrystalBase
implements CrystalReceiver,
LumenRequestingTile,
NBTTile {
    protected final ElementTagCompound energy = new ElementTagCompound();
    private int receiveCooldown = this.getCooldownLength();
    protected StepTimer checkTimer = new StepTimer(this.getCooldownLength());
    private long lastRequestDecrTime = -1L;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        boolean flag;
        long time = world.func_82737_E();
        boolean bl = flag = this.lastRequestDecrTime != time;
        if (flag) {
            this.checkTimer.update();
        }
        if (this.receiveCooldown > 0 && flag) {
            --this.receiveCooldown;
        }
        this.lastRequestDecrTime = time;
        if (DragonAPICore.debugtest && !world.field_72995_K) {
            CrystalElement e = CrystalElement.randomElement();
            this.energy.addValueToColor(e, this.getMaxStorage(e) / 4);
            this.clamp(e);
        }
    }

    protected int getCooldownLength() {
        return 40;
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.checkTimer.setTick(rand.nextInt(1 + this.checkTimer.getCap()));
    }

    protected final int getCooldown() {
        return this.receiveCooldown;
    }

    @Override
    public abstract int getMaxStorage(CrystalElement var1);

    public final int getEnergyScaled(CrystalElement e, int a) {
        return a * this.getEnergy(e) / this.getMaxStorage(e);
    }

    protected final boolean requestEnergy(CrystalElement e, int amount) {
        int amt = Math.min(amount, this.getRemainingSpace(e));
        boolean flag = false;
        if (amt > 0) {
            flag = CrystalNetworker.instance.makeRequest(this, e, amount, this.getReceiveRange());
        }
        if (flag) {
            ProgressionManager.ProgressStage.USEENERGY.stepPlayerTo(this.getPlacer());
        }
        return flag;
    }

    protected final boolean requestEnergy(ElementTagCompound tag) {
        boolean flag = false;
        for (CrystalElement e : tag.elementSet()) {
            flag &= this.requestEnergy(e, tag.getValue(e));
        }
        return flag;
    }

    protected final boolean requestEnergyDifference(ElementTagCompound tag) {
        tag.subtract(this.energy);
        return this.requestEnergy(tag);
    }

    public final int getRemainingSpace(CrystalElement e) {
        return this.getMaxStorage(e) - this.getEnergy(e);
    }

    public final float getFillFraction(CrystalElement e) {
        return (float)this.energy.getValue(e) / (float)this.getMaxStorage(e);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy.readFromNBT("energy", NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.energy.writeToNBT("energy", NBT);
    }

    @Override
    public final int receiveElement(CrystalElement e, int amt) {
        int add = Math.min(amt, this.getMaxStorage(e) - amt);
        this.energy.addValueToColor(e, amt);
        this.clamp(e);
        this.receiveCooldown = this.getCooldownLength();
        this.onReceiveEnergy(e, amt);
        return add;
    }

    protected void onReceiveEnergy(CrystalElement e, int amt) {
    }

    @Override
    public final int getEnergy(CrystalElement e) {
        return this.energy.getValue(e);
    }

    protected final void drainEnergy(CrystalElement e, int amt) {
        this.energy.subtract(e, amt);
    }

    protected final void drainEnergy(ElementTagCompound tag) {
        this.energy.subtract(tag);
    }

    protected final void clamp(CrystalElement e) {
        int max = this.getMaxStorage(e);
        if (this.getEnergy(e) > max) {
            this.energy.setTag(e, max);
        }
    }

    public final void setEnergy(CrystalElement e, int lvl) {
        this.energy.setTag(e, lvl);
    }

    @Override
    public ImmutableTriple<Double, Double, Double> getTargetRenderOffset(CrystalElement e) {
        return null;
    }

    @Override
    public final ElementTagCompound getEnergy() {
        return this.energy.copy();
    }

    @Override
    public ElementTagCompound getRequestedTotal() {
        return this.getCapacity();
    }

    protected final ElementTagCompound getCapacity() {
        ElementTagCompound tag = new ElementTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if (!this.isConductingElement(e)) continue;
            tag.setTag(e, this.getMaxStorage(e));
        }
        return tag;
    }

    protected final ElementTagCompound getDifference() {
        ElementTagCompound tag = new ElementTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            tag.setTag(e, this.getMaxStorage(e) - this.getEnergy(e));
        }
        return tag;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.energy.writeToNBT("energy", NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        if (is.field_77990_d == null) {
            return;
        }
        this.energy.readFromNBT("energy", is.field_77990_d);
    }

    @Override
    public boolean canReceiveFrom(CrystalTransmitter r) {
        return true;
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return true;
    }
}

