/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Items.ItemStorageCrystal;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.LumenTile;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityEfficiencyUpgrade;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class ChargedCrystalPowered
extends InventoriedChromaticBase
implements LumenTile,
AdjacentUpdateWatcher {
    private int efficiencyBoost;

    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.calcEfficiency();
        this.syncAllData(false);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.efficiencyBoost = NBT.func_74762_e("eff");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("eff", this.efficiencyBoost);
    }

    public int getEfficiencyBoost() {
        return this.efficiencyBoost;
    }

    protected final float getEnergyCostScale() {
        float f = 1.0f;
        int e = this.getEfficiencyBoost();
        if (e > 0) {
            f = (float)((double)f * TileEntityEfficiencyUpgrade.getCostFactor(e - 1));
        }
        return f *= this.getCostModifier();
    }

    public abstract float getCostModifier();

    private void calcEfficiency() {
        Integer get = TileEntityAdjacencyUpgrade.getAdjacentUpgrades(this).get((Object)CrystalElement.BLACK);
        this.efficiencyBoost = get != null ? get : 0;
    }

    @Override
    public final int getEnergy(CrystalElement e) {
        if (e == null) {
            return 0;
        }
        if (ChromaItems.STORAGE.matchWith(this.inv[0])) {
            ItemStack is = this.inv[0];
            ItemStorageCrystal cfr_ignored_0 = (ItemStorageCrystal)is.func_77973_b();
            return ItemStorageCrystal.getStoredEnergy(is, e);
        }
        return 0;
    }

    protected final int getStoredEnergy() {
        if (ChromaItems.STORAGE.matchWith(this.inv[0])) {
            ItemStack is = this.inv[0];
            ItemStorageCrystal cfr_ignored_0 = (ItemStorageCrystal)is.func_77973_b();
            return ItemStorageCrystal.getTotalEnergy(is);
        }
        return 0;
    }

    protected final void useEnergy(CrystalElement e, int amt) {
        ItemStorageCrystal c = (ItemStorageCrystal)this.inv[0].func_77973_b();
        ItemStorageCrystal.removeEnergy(this.inv[0], e, amt);
    }

    @Override
    public final int getMaxStorage(CrystalElement e) {
        if (ChromaItems.STORAGE.matchWith(this.inv[0])) {
            ItemStack is = this.inv[0];
            ItemStorageCrystal cfr_ignored_0 = (ItemStorageCrystal)is.func_77973_b();
            return ItemStorageCrystal.getCapacity(is);
        }
        return 0;
    }

    protected final void useEnergy(ElementTagCompound tag) {
        for (CrystalElement e : tag.elementSet()) {
            this.useEnergy(e, tag.getValue(e));
        }
    }

    protected final boolean hasEnergy(ElementTagCompound tag) {
        for (CrystalElement e : tag.elementSet()) {
            if (this.hasEnergy(e, tag.getValue(e))) continue;
            return false;
        }
        return true;
    }

    protected final boolean hasEnergy(CrystalElement e, int amt) {
        return this.getEnergy(e) >= amt;
    }

    @Override
    public final ElementTagCompound getEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if (!this.usesColor(e)) continue;
            tag.setTag(e, this.getEnergy(e));
        }
        return tag;
    }

    public abstract boolean usesColor(CrystalElement var1);

    public abstract boolean func_102008_b(int var1, ItemStack var2, int var3);

    public abstract boolean func_94041_b(int var1, ItemStack var2);

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.calcEfficiency();
    }
}

