/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Dimension.Structure.Locks.BlockColoredLock;
import Reika.ChromatiCraft.Block.Dimension.Structure.Locks.BlockLockKey;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.LocksGenerator;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Instantiable.Worldgen.OriginBlockCache;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LockLevel
extends StructurePiece
implements Comparable<LockLevel> {
    public final BlockLockKey.LockChannel level;
    private boolean[] mirror;
    protected ForgeDirection facing;
    private OriginBlockCache currentGenerator;
    private final EnumMap<LockColor, CrystalElement> shuffleMap = new EnumMap(LockColor.class);
    public boolean isSolved = false;

    protected LockLevel(LocksGenerator s, BlockLockKey.LockChannel level) {
        super(s);
        this.level = level;
    }

    protected abstract void generate(OriginBlockCache var1, int var2, int var3, int var4);

    @Override
    public final void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
        OriginBlockCache cache;
        int f = this.getWidth() / 4;
        int dx = x + f * this.facing.offsetZ;
        int dz = z + f * this.facing.offsetX;
        this.currentGenerator = cache = new OriginBlockCache(dx, y, dz, ForgeDirection.SOUTH);
        this.generate(cache, x, y, z);
        cache.align(this.facing);
        if (this.mirror[0]) {
            cache.flipX();
        }
        if (this.mirror[1]) {
            cache.flipZ();
        }
        cache.addToGenCache(world);
        this.currentGenerator = null;
    }

    protected final void generateWhiteRune(int x, int y, int z) {
        this.currentGenerator.setBlock(x, y, z, ChromaBlocks.RUNE.getBlockInstance(), CrystalElement.WHITE.ordinal());
    }

    protected final void generateRune(int x, int y, int z, LockColor color) {
        this.currentGenerator.setBlock(x, y, z, ChromaBlocks.RUNE.getBlockInstance(), this.shuffleMap.get((Object)color).ordinal());
    }

    protected final void generateKey(int x, int y, int z) {
        this.currentGenerator.setTileEntity(x, y, z, ChromaBlocks.LOCKKEY.getBlockInstance(), this.level.ordinal(), (ChunkSplicedGenerationCache.TileCallback)new DimensionStructureGenerator.UUIDPlace(this.parent.id));
    }

    protected final void generateTimer(int x, int y, int z) {
        this.currentGenerator.setTileEntity(x, y, z, ChromaBlocks.LOCKFREEZE.getBlockInstance(), this.level.ordinal(), (ChunkSplicedGenerationCache.TileCallback)new DimensionStructureGenerator.UUIDPlace(this.parent.id));
    }

    protected final void generateLock(int x, int y, int z, LockColor ... colors) {
        CrystalElement[] elements = new CrystalElement[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            elements[i] = this.shuffleMap.get((Object)colors[i]);
        }
        this.currentGenerator.setTileEntity(x, y, z, ChromaBlocks.COLORLOCK.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new LockColorSet((LocksGenerator)this.parent, this.level.ordinal(), this.parent.id, elements));
    }

    protected final void generateGate(int x, int y, int z) {
        this.currentGenerator.setTileEntity(x, y, z, ChromaBlocks.COLORLOCK.getBlockInstance(), 1, (ChunkSplicedGenerationCache.TileCallback)new LockColorSet((LocksGenerator)this.parent, this.level.ordinal(), this.parent.id, new CrystalElement[0]));
    }

    public final LockLevel mirrorX() {
        this.mirror[0] = true;
        return this;
    }

    public final LockLevel mirrorZ() {
        this.mirror[1] = true;
        return this;
    }

    public final LockLevel setDirection(ForgeDirection dir) {
        this.facing = dir;
        return this;
    }

    protected final boolean isMirroredX() {
        return this.mirror[0];
    }

    protected final boolean isMirroredZ() {
        return this.mirror[1];
    }

    public abstract int getWidth();

    public abstract int getLength();

    public abstract int getInitialOffset();

    public abstract int getEnterExitDL();

    public abstract int getEnterExitDT();

    public abstract int getDifficultyRating();

    public abstract int getFeatureRating();

    public int getWeightValue() {
        return this.getFeatureRating() * 100 + this.getDifficultyRating();
    }

    public final boolean canGenerate() {
        return this.getDifficultyRating() <= 2 + ChromaOptions.getStructureDifficulty();
    }

    @Override
    public final int compareTo(LockLevel l) {
        return this.getWeightValue() - l.getWeightValue();
    }

    public final void permute(Random rand) {
        this.shuffleMap.clear();
        ArrayList set = ReikaJavaLibrary.makeListFrom((Object[])CrystalElement.elements);
        set.remove((Object)CrystalElement.WHITE);
        for (int i = 0; i < LockColor.list.length; ++i) {
            LockColor in = LockColor.list[i];
            int outindex = rand.nextInt(set.size());
            CrystalElement out = (CrystalElement)((Object)set.get(outindex));
            set.remove(outindex);
            Collection<CrystalElement> mix = this.getConfusableColors(out);
            for (CrystalElement e : mix) {
                set.remove((Object)e);
            }
            this.shuffleMap.put(in, out);
        }
        this.mirror = new boolean[2];
    }

    private Collection<CrystalElement> getConfusableColors(CrystalElement out) {
        ArrayList<CrystalElement> li = new ArrayList<CrystalElement>();
        switch (out) {
            case WHITE: {
                li.add(CrystalElement.LIGHTGRAY);
                break;
            }
            case BLACK: {
                li.add(CrystalElement.GRAY);
                break;
            }
            case GRAY: {
                li.add(CrystalElement.BLACK);
                li.add(CrystalElement.LIGHTGRAY);
                break;
            }
            case LIGHTGRAY: {
                li.add(CrystalElement.GRAY);
                li.add(CrystalElement.WHITE);
                break;
            }
        }
        return li;
    }

    protected static enum LockColor {
        RED,
        BLUE,
        YELLOW,
        GREEN,
        PURPLE;

        private static final LockColor[] list;

        static {
            list = LockColor.values();
        }
    }

    private static class LockColorSet
    implements ChunkSplicedGenerationCache.TileCallback {
        private final LocksGenerator generator;
        private final CrystalElement[] colors;
        private final int channel;
        private final UUID uid;

        private LockColorSet(LocksGenerator gen, int ch, UUID id, CrystalElement ... c) {
            this.colors = c;
            this.channel = ch;
            this.uid = id;
            this.generator = gen;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity tile) {
            if (tile instanceof BlockColoredLock.TileEntityColorLock) {
                BlockColoredLock.TileEntityColorLock te = (BlockColoredLock.TileEntityColorLock)tile;
                for (CrystalElement e : this.colors) {
                    te.addColor(e);
                }
                te.setChannel(this.channel);
                te.uid = this.uid;
                this.generator.addLock(x, y, z);
            }
        }
    }
}

