/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TankRunes {
    private final ArrayList<TankRune> runes = new ArrayList();
    private static final ArrayList<ForgeDirection> dirSet = ReikaJavaLibrary.makeListFrom((Object[])new Object[]{ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.WEST});

    public void addRune(float x, float y, float z, CrystalElement e) {
        TankRune r = new TankRune(e);
        r.px = x;
        r.py = y;
        r.pz = z;
        this.runes.add(r);
    }

    public void updateAndRender(Tessellator v5, TileEntityCrystalTank te, float ptick) {
        if (!this.runes.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glDepthMask((boolean)false);
            ReikaTextureHelper.bindTerrainTexture();
            v5.func_78382_b();
            v5.func_78380_c(240);
            v5.func_78378_d(0xFFFFFF);
            Iterator<TankRune> it = this.runes.iterator();
            BlockArray blocks = te.getBlocks();
            float sp = Math.min(0.005f, 0.5f / (float)ReikaRenderHelper.getFPS()) * 3.0f;
            while (it.hasNext()) {
                TankRune r = it.next();
                if (!r.updateAndRender(v5, te, blocks, sp, ptick)) continue;
                it.remove();
            }
            v5.func_78381_a();
            GL11.glPopAttrib();
        }
    }

    private static class TankRune {
        private final CrystalElement color;
        private float px;
        private float py;
        private float pz;

        private TankRune(CrystalElement e) {
            this.color = e;
        }

        private boolean updateAndRender(Tessellator v5, TileEntityCrystalTank te, BlockArray blocks, double sp, float ptick) {
            int x = Math.round(this.px);
            int y = Math.round(this.py);
            int z = Math.round(this.pz);
            HashSet li = new HashSet(dirSet);
            for (int k = 2; k < 6; ++k) {
                int dx = x + ForgeDirection.VALID_DIRECTIONS[k].offsetX;
                int dy = y + ForgeDirection.VALID_DIRECTIONS[k].offsetY;
                int dz = z + ForgeDirection.VALID_DIRECTIONS[k].offsetZ;
                Block b = te.field_145850_b.func_147439_a(dx, dy, dz);
                if (b != ChromaBlocks.TANK.getBlockInstance()) continue;
                li.remove(ForgeDirection.VALID_DIRECTIONS[k]);
            }
            IIcon ico = this.color.getGlowRune();
            float u = ico.func_94209_e();
            float du = ico.func_94212_f();
            float v = ico.func_94206_g();
            float dv = ico.func_94210_h();
            double o = 0.004;
            double dx = this.px - (float)te.field_145851_c;
            double dy = this.py - (float)te.field_145848_d;
            double dz = this.pz - (float)te.field_145849_e;
            for (int i = 0; i < 4; ++i) {
                if (li.contains(ForgeDirection.SOUTH)) {
                    v5.func_78374_a(dx - 0.0 - o, dy - 0.0 - o, dz + 1.0 + o, (double)u, (double)dv);
                    v5.func_78374_a(dx + 1.0 + o, dy - 0.0 - o, dz + 1.0 + o, (double)du, (double)dv);
                    v5.func_78374_a(dx + 1.0 + o, dy + 1.0 + o, dz + 1.0 + o, (double)du, (double)v);
                    v5.func_78374_a(dx - 0.0 - o, dy + 1.0 + o, dz + 1.0 + o, (double)u, (double)v);
                }
                if (li.contains(ForgeDirection.NORTH)) {
                    v5.func_78374_a(dx - 0.0 - o, dy + 1.0 + o, dz - 0.0 - o, (double)du, (double)v);
                    v5.func_78374_a(dx + 1.0 + o, dy + 1.0 + o, dz - 0.0 - o, (double)u, (double)v);
                    v5.func_78374_a(dx + 1.0 + o, dy - 0.0 - o, dz - 0.0 - o, (double)u, (double)dv);
                    v5.func_78374_a(dx - 0.0 - o, dy - 0.0 - o, dz - 0.0 - o, (double)du, (double)dv);
                }
                if (li.contains(ForgeDirection.WEST)) {
                    v5.func_78374_a(dx - 0.0 - o, dy - 0.0 - o, dz - 0.0 - o, (double)u, (double)dv);
                    v5.func_78374_a(dx - 0.0 - o, dy - 0.0 - o, dz + 1.0 + o, (double)du, (double)dv);
                    v5.func_78374_a(dx - 0.0 - o, dy + 1.0 + o, dz + 1.0 + o, (double)du, (double)v);
                    v5.func_78374_a(dx - 0.0 - o, dy + 1.0 + o, dz - 0.0 - o, (double)u, (double)v);
                }
                if (!li.contains(ForgeDirection.EAST)) continue;
                v5.func_78374_a(dx + 1.0 + o, dy - 0.0 - o, dz + 1.0 - o, (double)u, (double)dv);
                v5.func_78374_a(dx + 1.0 + o, dy - 0.0 - o, dz - 0.0 + o, (double)du, (double)dv);
                v5.func_78374_a(dx + 1.0 + o, dy + 1.0 + o, dz - 0.0 + o, (double)du, (double)v);
                v5.func_78374_a(dx + 1.0 + o, dy + 1.0 + o, dz + 1.0 - o, (double)u, (double)v);
            }
            this.py = (float)((double)this.py - sp);
            int y2 = MathHelper.func_76128_c((double)this.py);
            return !blocks.hasBlock(x, y2, z);
        }
    }
}

