/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Instantiable.Event.Client.EntityRenderingLoopEvent;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class OreOverlayRenderer {
    public static final OreOverlayRenderer instance = new OreOverlayRenderer();
    private final TimerMap<WorldLocation> coords = new TimerMap();
    private static final int DURATION = 160;

    private OreOverlayRenderer() {
    }

    public void addCoordinate(World world, int x, int y, int z) {
        this.coords.put((Object)new WorldLocation(world, x, y, z), 160);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tick(TickEvent.ClientTickEvent evt) {
        this.coords.tick();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void render(EntityRenderingLoopEvent evt) {
        if (!this.coords.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            ReikaRenderHelper.disableEntityLighting();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glDisable((int)3008);
            ReikaTextureHelper.bindTerrainTexture();
            int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            for (WorldLocation loc : this.coords.keySet()) {
                if (loc.dimensionID != dim) continue;
                this.renderPoint(loc, this.coords.get((Object)loc), (EntityPlayer)ep);
            }
            GL11.glPopAttrib();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPoint(WorldLocation loc, int ticks, EntityPlayer ep) {
        GL11.glPushMatrix();
        RenderManager rm = RenderManager.field_78727_a;
        GL11.glTranslated((double)((double)loc.xCoord + 0.5 - RenderManager.field_78725_b), (double)((double)loc.yCoord + 0.5 - RenderManager.field_78726_c), (double)((double)loc.zCoord + 0.5 - RenderManager.field_78723_d));
        GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator v5 = Tessellator.field_78398_a;
        IIcon ico = ChromaIcons.FADE_CLOUD.getIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        v5.func_78382_b();
        v5.func_78380_c(240);
        float f1 = (float)ticks / 160.0f;
        float f = Math.min(1.0f, f1 + 0.375f);
        double s = 1.5 * Math.sqrt(f);
        int c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)f1);
        v5.func_78378_d(c);
        v5.func_78374_a(-s, s, 0.0, (double)u, (double)dv);
        v5.func_78374_a(s, s, 0.0, (double)du, (double)dv);
        v5.func_78374_a(s, -s, 0.0, (double)du, (double)v);
        v5.func_78374_a(-s, -s, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        GL11.glPopMatrix();
    }
}

