/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Lore.KeyAssemblyPuzzle;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Instantiable.Math.HexGrid;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class FullScreenOverlayRenderer {
    static final FullScreenOverlayRenderer instance = new FullScreenOverlayRenderer();
    private static final int WASHOUT_LENGTH = 312;
    private static final int WASHOUT_FACTOR = 2;
    private static final int FLASH_FADE = 4;
    private boolean rehideGui;
    private int washout;
    private CrystalElement washoutColor;
    private final EnumMap<CrystalElement, Float> factors = new EnumMap(CrystalElement.class);
    private static final int GROUP_LIFESPAN = 100;
    private final Collection<TileGroupRender> renderingGroups = new ArrayList<TileGroupRender>();

    private FullScreenOverlayRenderer() {
    }

    void triggerWashout(CrystalElement e) {
        this.rehideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
        this.washout = Math.max(this.washout, 308);
        this.washoutColor = e;
    }

    boolean isWashoutActive() {
        return this.washout > 0;
    }

    void renderWashout(RenderGameOverlayEvent.Pre evt, int tick) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        int mx = Minecraft.func_71410_x().field_71443_c / evt.resolution.func_78325_e();
        int my = Minecraft.func_71410_x().field_71440_d / evt.resolution.func_78325_e();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        int a = (int)(this.washout > 308 ? 255.0f * (float)(312 - this.washout) / 4.0f : 255.0f * Math.min(1.0f, (float)this.washout / 255.0f));
        int c1 = ReikaColorAPI.mixColors((int)this.washoutColor.getColor(), (int)0xFFFFFF, (float)0.5f);
        int c = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)c1, (float)Math.min(0.95f, (float)a / 255.0f));
        v5.func_78384_a(c, Math.min(255, a));
        v5.func_78377_a(0.0, 0.0, 0.0);
        v5.func_78377_a((double)mx, 0.0, 0.0);
        v5.func_78377_a((double)mx, (double)my, 0.0);
        v5.func_78377_a(0.0, (double)my, 0.0);
        v5.func_78381_a();
        if (!Minecraft.func_71410_x().func_147113_T()) {
            if (this.washout >= 308 || tick % 2 == 0) {
                this.washout -= Math.max(1, 90 / Math.max(1, ReikaRenderHelper.getFPS()));
            }
            if (this.washout == 0 && this.rehideGui) {
                Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
            }
        }
        GL11.glPopAttrib();
    }

    void triggerPylonEffect(CrystalElement e) {
        this.factors.put(e, Float.valueOf(2.0f));
    }

    void renderPylonAura(EntityPlayer ep, int gsc) {
        GL11.glPushAttrib((int)1048575);
        String tex = "Textures/aura-bar-half-grid.png";
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)tex);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        Tessellator v5 = Tessellator.field_78398_a;
        double w = Minecraft.func_71410_x().field_71443_c / gsc;
        double h = Minecraft.func_71410_x().field_71440_d / gsc;
        double z = -1000.0;
        for (int i = 0; i < 16; ++i) {
            double dd;
            PylonGenerator.PylonEntry c;
            CrystalElement e = CrystalElement.elements[i];
            boolean containsColor = this.factors.containsKey((Object)e);
            PylonGenerator.PylonEntry pylonEntry = c = containsColor ? null : PylonGenerator.instance.getNearestPylonSpawn(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, e);
            double d = containsColor ? 0.0 : (dd = c != null ? c.location.getDistanceTo(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v) : Double.POSITIVE_INFINITY);
            if (!containsColor && !(dd < 32.0)) continue;
            int step = 40;
            int frame = (int)((float)(System.currentTimeMillis() / (long)step % 20L) + (float)e.ordinal() * 1.25f) % 20;
            int imgw = 4;
            int imgh = 5;
            double u = (double)(frame % imgw) / (double)imgw;
            double du = u + 1.0 / (double)imgw;
            double v = (double)(frame / imgw) / (double)imgh;
            double dv = v + 1.0 / (double)imgh;
            int alpha = 255;
            float cache = containsColor ? this.factors.get((Object)e).floatValue() : 0.0f;
            float bright = Math.min(1.0f, (float)(1.5 - dd / 24.0));
            float res = Math.max(cache, bright);
            if (containsColor) {
                if ((double)cache > 0.01) {
                    this.factors.put(e, Float.valueOf(cache * 0.975f));
                } else {
                    this.factors.remove((Object)e);
                }
            }
            if (!(res > 0.0f)) continue;
            int color = ReikaColorAPI.getColorWithBrightnessMultiplier((int)e.getColor(), (float)Math.min(1.0f, res));
            v5.func_78382_b();
            v5.func_78380_c(240);
            v5.func_78384_a(color, alpha);
            v5.func_78374_a(0.0, h, z, u, dv);
            v5.func_78374_a(w, h, z, du, dv);
            v5.func_78374_a(w, 0.0, z, du, v);
            v5.func_78374_a(0.0, 0.0, z, u, v);
            v5.func_78381_a();
        }
        GL11.glAlphaFunc((int)516, (float)0.1f);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopAttrib();
    }

    boolean isPylonOverlayForced() {
        return !this.factors.isEmpty();
    }

    void addLoreNote(EntityPlayer ep, Towers t) {
        Collection<KeyAssemblyPuzzle.TileGroup> groups = LoreManager.instance.getGroupsForTower(ep, t);
        for (KeyAssemblyPuzzle.TileGroup g : groups) {
            this.renderingGroups.add(new TileGroupRender(g));
        }
    }

    boolean renderLoreHexes(RenderGameOverlayEvent.Pre evt, int tick) {
        if (!this.renderingGroups.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            float maxa = 0.0f;
            for (TileGroupRender t : this.renderingGroups) {
                maxa = Math.max(maxa, t.getAlpha());
            }
            GL11.glPushAttrib((int)1048575);
            maxa = Math.min(maxa * 2.0f, 1.0f);
            double dz = -500.0;
            GL11.glTranslated((double)0.0, (double)0.0, (double)dz);
            int c1 = -1072689136;
            int c2 = -804253680;
            c1 = (int)(maxa * (float)ReikaColorAPI.getAlpha((int)c1)) << 24 | c1 & 0xFFFFFF;
            c2 = (int)(maxa * (float)ReikaColorAPI.getAlpha((int)c2)) << 24 | c2 & 0xFFFFFF;
            ReikaGuiAPI.instance.func_73733_a(0, 0, evt.resolution.func_78326_a(), evt.resolution.func_78328_b(), c1, c2);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-dz));
            GL11.glPopAttrib();
            GL11.glPushMatrix();
            int i = -this.renderingGroups.size() / 2;
            double s = 2.0;
            GL11.glTranslated((double)(evt.resolution.func_78327_c() / 2.0), (double)(evt.resolution.func_78324_d() / 2.0), (double)800.0);
            GL11.glTranslated((double)(-7.5 * s - 0.5), (double)(-7.5 * s + 2.0), (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)s);
            KeyAssemblyPuzzle p = LoreManager.instance.getPuzzle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            Iterator<TileGroupRender> it = this.renderingGroups.iterator();
            while (it.hasNext()) {
                TileGroupRender t = it.next();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(i * 60), (double)0.0, (double)0.0);
                t.age++;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)t.getAlpha());
                HexGrid.Point pt = t.group.getCenter(p);
                GL11.glTranslated((double)(-pt.x), (double)(-pt.y), (double)0.0);
                for (HexGrid.Hex h : t.group.getHexes()) {
                    GL11.glPushMatrix();
                    KeyAssemblyPuzzle.HexCell c = p.getCell(h);
                    HexGrid.Point pt2 = p.getHexLocation(h);
                    GL11.glTranslated((double)pt2.x, (double)pt2.y, (double)0.0);
                    c.render(p, Tessellator.field_78398_a, false, 1.0f);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
                ++i;
                if (t.age < 100) continue;
                it.remove();
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            return true;
        }
        return false;
    }

    public boolean isRenderingHexGroups() {
        return !this.renderingGroups.isEmpty();
    }

    private static class TileGroupRender {
        private final KeyAssemblyPuzzle.TileGroup group;
        private int age;

        private TileGroupRender(KeyAssemblyPuzzle.TileGroup g) {
            this.group = g;
        }

        private float getAlpha() {
            if (this.age < 12) {
                return (float)this.age * 8.0f / 100.0f;
            }
            if (this.age > 50) {
                return 1.0f - ((float)this.age - 50.0f) / 50.0f;
            }
            return 1.0f;
        }
    }
}

