/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Auxiliary.Render.FullScreenOverlayRenderer;
import Reika.ChromatiCraft.Auxiliary.Render.MouseoverOverlayRenderer;
import Reika.ChromatiCraft.Auxiliary.Render.ProgressOverlayRenderer;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.ItemWandBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemKillAuraGun;
import Reika.ChromatiCraft.Items.Tools.ItemOrePick;
import Reika.ChromatiCraft.Items.Tools.Wands.ItemTransitionWand;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Instantiable.Event.Client.EntityRenderingLoopEvent;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ChromaOverlays {
    public static final ChromaOverlays instance = new ChromaOverlays();
    private boolean holding = false;
    private int tick = 0;
    private static final int PING_LENGTH = 512;
    private static final int FADEIN = 16;
    private static final int FADEOUT = 64;
    private final EnumMap<CrystalElement, Integer> pings = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, Integer> pingAng = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, Integer> pingDist = new EnumMap(CrystalElement.class);
    private final ArrayList<FlareMessage> flareMessages = new ArrayList();
    private String structureText = null;
    private long structureTextTick = -1L;
    static final double FRONT_TRANSLATE = 930.0;

    private ChromaOverlays() {
    }

    @SubscribeEvent
    public void renderInWorld(EntityRenderingLoopEvent evt) {
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public void renderHUD(RenderGameOverlayEvent.Pre evt) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        ++this.tick;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ItemStack is = ep.func_71045_bC();
        boolean renderCursor = true;
        if (FullScreenOverlayRenderer.instance.isRenderingHexGroups()) {
            renderCursor = false;
        }
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET) {
            if (FullScreenOverlayRenderer.instance.isWashoutActive()) {
                FullScreenOverlayRenderer.instance.renderWashout(evt, this.tick);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
                return;
            }
            boolean bl = renderCursor = !FullScreenOverlayRenderer.instance.renderLoreHexes(evt, this.tick);
            if (!renderCursor) {
                evt.setCanceled(true);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
                return;
            }
        }
        int gsc = evt.resolution.func_78325_e();
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET) {
            if (ChromaItems.TOOL.matchWith(is)) {
                MouseoverOverlayRenderer.instance.renderTileOverlays((EntityPlayer)ep, gsc);
            }
            if (this.isEnergyDisplayTool(is)) {
                if (!this.holding) {
                    this.syncBuffer((EntityPlayer)ep);
                }
                this.holding = true;
                this.renderElementPie((EntityPlayer)ep, gsc);
            } else {
                this.holding = false;
            }
            if (ChromaItems.OREPICK.matchWith(is)) {
                this.renderOreHUD((EntityPlayer)ep, evt.resolution, is);
            } else if (ChromaItems.TRANSITION.matchWith(is)) {
                this.renderTransitionHUD((EntityPlayer)ep, evt.resolution, is);
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)930.0);
            this.renderAbilityStatus((EntityPlayer)ep, gsc);
            GL11.glPopMatrix();
            if (PylonGenerator.instance.canGenerateIn(ep.field_70170_p) || FullScreenOverlayRenderer.instance.isPylonOverlayForced()) {
                FullScreenOverlayRenderer.instance.renderPylonAura((EntityPlayer)ep, gsc);
            }
            this.renderPingOverlays((EntityPlayer)ep, gsc);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.0, (double)930.0);
            ProgressOverlayRenderer.instance.renderProgressOverlays((EntityPlayer)ep, gsc);
            this.renderStructureText((EntityPlayer)ep, gsc);
            this.renderFlareMessages(gsc);
            GL11.glPopMatrix();
        } else if (evt.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (ChromaItems.TOOL.matchWith(is) || !renderCursor)) {
            if (renderCursor) {
                this.renderCustomCrosshair(evt.resolution);
            }
            evt.setCanceled(true);
        } else if (evt.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && ChromaItems.KILLAURAGUN.matchWith(is)) {
            this.renderKillAuraCrosshair(evt, gsc);
        } else if (evt.type == RenderGameOverlayEvent.ElementType.HEALTH && Chromabilities.HEALTH.enabledOn((EntityPlayer)ep)) {
            this.renderBoostedHealthBar(evt, (EntityPlayer)ep);
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public boolean isWashoutActive() {
        return FullScreenOverlayRenderer.instance.isWashoutActive();
    }

    public void triggerPylonEffect(CrystalElement color) {
        FullScreenOverlayRenderer.instance.triggerPylonEffect(color);
    }

    public void triggerWashout(CrystalElement e) {
        FullScreenOverlayRenderer.instance.triggerWashout(e);
    }

    private boolean isEnergyDisplayTool(ItemStack is) {
        return is != null && (ChromaItems.TOOL.matchWith(is) || is.func_77973_b() instanceof ItemWandBase);
    }

    private void renderStructureText(EntityPlayer ep, int gsc) {
        if (this.structureText != null) {
            int x = Minecraft.func_71410_x().field_71443_c / 2 / gsc;
            int y = Minecraft.func_71410_x().field_71440_d / 2 / gsc;
            float frac = ((float)(ep.field_70170_p.func_82737_E() - this.structureTextTick) + ReikaRenderHelper.getPartialTickTime()) / 50.0f;
            ChromaFontRenderer.FontType.GUI.renderer.drawTitleScroll(this.structureText, x, y, frac, -7829368, -13594369, -16777216, -1);
            if (frac >= 2.0f) {
                this.structureText = null;
            }
        }
    }

    private void renderFlareMessages(int gsc) {
        int x = 16 / gsc;
        ((Object)((Object)ChromaFontRenderer.FontType.GUI.renderer)).getClass();
        int dy = 9 + 2;
        int n = Minecraft.func_71410_x().field_71440_d;
        ((Object)((Object)ChromaFontRenderer.FontType.GUI.renderer)).getClass();
        int y = (n - 9 - 16) / gsc - dy * this.flareMessages.size();
        Iterator<FlareMessage> it = this.flareMessages.iterator();
        int i = 0;
        while (it.hasNext()) {
            FlareMessage f = it.next();
            f.render(gsc, x, y + i * dy * gsc, 0xFFFFFF);
            y -= dy;
            if (f.update()) {
                it.remove();
            }
            ++i;
        }
    }

    private void renderPingOverlays(EntityPlayer ep, int gsc) {
        GL11.glPushAttrib((int)1048575);
        HashMap<CrystalElement, Integer> map = new HashMap<CrystalElement, Integer>();
        int i = 0;
        int k = 0;
        boolean renderCircle = false;
        for (int c = 0; c < 16; ++c) {
            CrystalElement e = CrystalElement.elements[c];
            Integer tick = this.pings.get((Object)e);
            if (tick == null) continue;
            float alpha = tick >= 496 ? (float)(512 - tick) / 16.0f : (tick < 64 ? (float)tick.intValue() / 64.0f : 1.0f);
            GL11.glColor4f((float)alpha, (float)alpha, (float)alpha, (float)alpha);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            ChromaFontRenderer fr = ChromaFontRenderer.FontType.HUD.renderer;
            int w = Minecraft.func_71410_x().field_71443_c / gsc;
            int h = Minecraft.func_71410_x().field_71440_d / gsc;
            int x = w / 2;
            int y = h / 2;
            double r = (double)(h / 2) * 0.75;
            int s = 16;
            int d = 40;
            if (!renderCircle) {
                Tessellator v5 = Tessellator.field_78398_a;
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/dimping.png");
                v5.func_78382_b();
                v5.func_78380_c(240);
                v5.func_78378_d(0xA0A0A0);
                v5.func_78374_a((double)x - r, (double)y + r, 0.0, 0.0, 1.0);
                v5.func_78374_a((double)x + r, (double)y + r, 0.0, 1.0, 1.0);
                v5.func_78374_a((double)x + r, (double)y - r, 0.0, 1.0, 0.0);
                v5.func_78374_a((double)x - r, (double)y - r, 0.0, 0.0, 0.0);
                v5.func_78381_a();
                renderCircle = true;
            }
            ReikaTextureHelper.bindTerrainTexture();
            double ang = this.pingAng.get((Object)e).intValue();
            double dist = this.pingDist.get((Object)e).intValue();
            double dr = MathHelper.func_151237_a((double)(r * Math.pow(dist, 1.5) / 1000000.0), (double)2.0, (double)r);
            double ax = dr * Math.cos(Math.toRadians(ang)) - (double)(s / 2);
            double ay = dr * Math.sin(Math.toRadians(ang)) - (double)(s / 2);
            int dx = x + (int)ax;
            int dy = y + (int)ay;
            ReikaGuiAPI.instance.func_94065_a(dx, dy, e.getGlowRune(), s, s);
            if (ProgressionManager.instance.hasPlayerCompletedStructureColor(ep, e)) {
                ReikaGuiAPI.instance.func_94065_a(dx + 8, dy + 10, ChromaIcons.CHECK.getIcon(), s / 2, s / 2);
            }
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            int ox = dx + s / 2;
            int oy = dy + s / 2;
            if (tick > 1) {
                map.put(e, tick - 1);
            } else {
                this.pingDist.remove((Object)e);
                this.pingAng.remove((Object)e);
            }
            if (++i < 4) continue;
            i = 0;
            ++k;
        }
        GL11.glPopAttrib();
        this.pings.clear();
        this.pings.putAll(map);
    }

    public void addPingOverlay(CrystalElement e, int dist, int ang) {
        this.pings.put(e, 512);
        this.pingDist.put(e, dist);
        this.pingAng.put(e, ang);
        for (CrystalElement key : this.pings.keySet()) {
            this.pings.put(key, Math.max(this.pings.get((Object)key), 496));
        }
    }

    public void addStructureText(DimensionStructureGenerator.DimensionStructureType type) {
        String s;
        this.structureText = s = type.getDisplayText();
        this.structureTextTick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    public void addFlareMessage(String s) {
        this.flareMessages.add(new FlareMessage(s));
    }

    private void renderTransitionHUD(EntityPlayer ep, ScaledResolution sr, ItemStack is) {
        ItemTransitionWand itw = (ItemTransitionWand)is.func_77973_b();
        ItemStack place = itw.getStoredItem(is);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/transitionhud.png");
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        int x = 2;
        int y = 2;
        int w = 256;
        int h = 32;
        v5.func_78374_a((double)x, (double)(y + h), 0.0, 0.0, 1.0);
        v5.func_78374_a((double)(x + w), (double)(y + h), 0.0, 1.0, 1.0);
        v5.func_78374_a((double)(x + w), (double)y, 0.0, 1.0, 0.0);
        v5.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        v5.func_78381_a();
        x = 8;
        y = 8;
        ReikaGuiAPI.instance.drawItemStack(new RenderItem(), place, x, y);
        ItemTransitionWand.TransitionMode mode = itw.getMode(is);
        ChromaFontRenderer.FontType.HUD.renderer.func_85187_a(mode.desc, x + 20, y + 4, 0xFFFFFF, true);
        GL11.glDisable((int)2896);
    }

    private void renderOreHUD(EntityPlayer ep, ScaledResolution sr, ItemStack is) {
        OreType otype = ItemOrePick.getOreTypeByMetadata(is);
        if (otype == null) {
            return;
        }
        ItemStack ore = otype.getFirstOreBlock();
        IIcon ico = Block.func_149634_a((Item)ore.func_77973_b()).func_149691_a(0, ore.func_77960_j());
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        Tessellator v5 = Tessellator.field_78398_a;
        int s = 16;
        int x = sr.func_78326_a() / 2 - s * 5 / 4;
        int y = sr.func_78328_b() / 2 - s * 5 / 4;
        ReikaTextureHelper.bindTerrainTexture();
        v5.func_78382_b();
        v5.func_78374_a((double)x, (double)(y + s), 0.0, (double)u, (double)dv);
        v5.func_78374_a((double)(x + s), (double)(y + s), 0.0, (double)du, (double)dv);
        v5.func_78374_a((double)(x + s), (double)y, 0.0, (double)du, (double)v);
        v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
        v5.func_78381_a();
    }

    private void renderCustomCrosshair(ScaledResolution res) {
        ReikaTextureHelper.bindFinalTexture(ChromatiCraft.class, (String)"Textures/crosshair.png");
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        Tessellator v5 = Tessellator.field_78398_a;
        int w = 16;
        int x = res.func_78326_a() / 2;
        int y = res.func_78328_b() / 2;
        v5.func_78382_b();
        double u = (double)(System.currentTimeMillis() / 16L % 64L) / 64.0;
        double du = u + 0.015625;
        double v = (double)(System.currentTimeMillis() / 128L % 16L) / 16.0;
        double dv = v + 0.0625;
        v5.func_78374_a((double)(x - w / 2), (double)(y + w / 2), 0.0, u, dv);
        v5.func_78374_a((double)(x + w / 2), (double)(y + w / 2), 0.0, du, dv);
        v5.func_78374_a((double)(x + w / 2), (double)(y - w / 2), 0.0, du, v);
        v5.func_78374_a((double)(x - w / 2), (double)(y - w / 2), 0.0, u, v);
        v5.func_78381_a();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
    }

    private void renderKillAuraCrosshair(RenderGameOverlayEvent.Pre evt, int gsc) {
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        Tessellator v5 = Tessellator.field_78398_a;
        double w = Minecraft.func_71410_x().field_71443_c / gsc;
        double h = Minecraft.func_71410_x().field_71440_d / gsc;
        double z = -1000.0;
        int n = 4;
        int tick = ItemKillAuraGun.getUseTick();
        double t = (double)n * (double)tick / 100.0;
        int p = MathHelper.func_76143_f((double)t);
        int m = (int)t;
        for (int i = -1; i <= p; ++i) {
            GL11.glPushMatrix();
            double a = 0.0;
            if (i == 1 || i == -1) {
                int t2 = ItemKillAuraGun.getUnboundedUseTick();
                if (t2 > 100) {
                    t2 = 100 + t2 % 100;
                }
                a = -Math.pow((double)t2 * 0.5, 2.0);
            }
            if (a != 0.0) {
                GL11.glTranslated((double)(w / 2.0), (double)(h / 2.0), (double)0.0);
                GL11.glRotated((double)a, (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)(-w / 2.0), (double)(-h / 2.0), (double)0.0);
            }
            String i2 = String.valueOf(i);
            if (i == -1) {
                i2 = "0b";
            }
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)("Textures/killlaura_" + i2 + ".png"));
            int alpha = 255;
            float f = (float)(t - (double)m);
            int color = i <= m ? 0xFFFFFF : ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)f);
            v5.func_78382_b();
            v5.func_78380_c(240);
            v5.func_78384_a(color, alpha);
            v5.func_78374_a(0.0, h, z, 0.0, 1.0);
            v5.func_78374_a(w, h, z, 1.0, 1.0);
            v5.func_78374_a(w, 0.0, z, 1.0, 0.0);
            v5.func_78374_a(0.0, 0.0, z, 0.0, 0.0);
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glAlphaFunc((int)516, (float)0.1f);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        evt.setCanceled(true);
        GL11.glPopAttrib();
    }

    private void renderBoostedHealthBar(RenderGameOverlayEvent.Pre evt, EntityPlayer ep) {
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/health.png");
        Tessellator v5 = Tessellator.field_78398_a;
        int h = 9;
        int w = 4;
        int left = evt.resolution.func_78326_a() / 2 - 91;
        int top = evt.resolution.func_78328_b() - GuiIngameForge.left_height;
        int regen = -1;
        if (ep.func_70644_a(Potion.field_76428_l)) {
            int rl = ep.func_70660_b(Potion.field_76428_l).func_76458_c();
            regen = (int)((double)this.tick / 300.0 * (1.0 + 0.33 * (double)rl) % 30.0);
        }
        v5.func_78382_b();
        boolean highlight = ep.field_70172_ad >= 10 && ep.field_70172_ad / 3 % 2 == 1;
        for (int i = 29; i >= 0; --i) {
            boolean heart;
            double u = 0.125 + (double)(i * 3) / 128.0;
            double du = u + (double)w / 128.0;
            double v = 0.0703125;
            if (ep.func_110138_aP() - 1.0f < (float)(i * 2)) {
                v = 0.2109375;
            }
            double dv = v + (double)h / 128.0;
            if (highlight) {
                v += 0.140625;
            }
            int x = left + i * 3;
            int dx = x + w;
            int y = top + 0;
            if (i == regen) {
                y -= 2;
            }
            int dy = y + h;
            v5.func_78374_a((double)x, (double)dy, 0.0, u, dv);
            v5.func_78374_a((double)dx, (double)dy, 0.0, du, dv);
            v5.func_78374_a((double)dx, (double)y, 0.0, du, v);
            v5.func_78374_a((double)x, (double)y, 0.0, u, v);
            boolean bl = heart = ep.func_110143_aJ() - 1.0f >= (float)(i * 2);
            if (!heart) continue;
            boolean half = ep.func_110143_aJ() - 1.0f == (float)(i * 2);
            x = left + i * 3 + 1;
            dx = x + w - 2;
            y = top + 1;
            if (i == regen) {
                y -= 2;
            }
            dy = y + h - 2;
            u = 0.1328125 + (double)(i * 3) / 128.0;
            du = u + (double)(w - 2) / 128.0;
            v = 0.0078125;
            if (ep.func_70644_a(Potion.field_76436_u)) {
                v = 0.2890625;
            } else if (ep.func_70644_a(Potion.field_82731_v)) {
                v = 0.359375;
            }
            dv = v + (double)(h - 2) / 128.0;
            if (half) {
                dx = x + (w - 2) / 2;
                du = u + (double)(w - 2) / 256.0;
            }
            v5.func_78374_a((double)x, (double)dy, 0.0, u, dv);
            v5.func_78374_a((double)dx, (double)dy, 0.0, du, dv);
            v5.func_78374_a((double)dx, (double)y, 0.0, du, v);
            v5.func_78374_a((double)x, (double)y, 0.0, u, v);
        }
        v5.func_78381_a();
        GuiIngameForge.left_height += h + 1;
        ReikaTextureHelper.bindHUDTexture();
        evt.setCanceled(true);
    }

    private void syncBuffer(EntityPlayer ep) {
        ReikaPlayerAPI.syncCustomDataFromClient((EntityPlayer)ep);
    }

    private void renderAbilityStatus(EntityPlayer ep, int gsc) {
        ArrayList<AbilityAPI.Ability> li = Chromabilities.getFrom(ep);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = 0;
        for (AbilityAPI.Ability c : li) {
            ReikaTextureHelper.bindTexture((Class)c.getTextureReferenceClass(), (String)c.getTexturePath(false));
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            v5.func_78378_d(0xFFFFFF);
            int x = Minecraft.func_71410_x().field_71443_c / gsc - 20;
            int y = Minecraft.func_71410_x().field_71440_d / gsc / 2 - 8 - (int)((float)li.size() / 2.0f * 20.0f) + i * 20;
            v5.func_78374_a((double)(x + 0), (double)(y + 16), 0.0, 0.0, 1.0);
            v5.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, 1.0, 1.0);
            v5.func_78374_a((double)(x + 16), (double)(y + 0), 0.0, 1.0, 0.0);
            v5.func_78374_a((double)(x + 0), (double)(y + 0), 0.0, 0.0, 0.0);
            v5.func_78381_a();
            ElementTagCompound tag = Chromabilities.getTickCost(c, ep);
            if (tag != null) {
                ReikaTextureHelper.bindTerrainTexture();
                int k = 0;
                int s = tag.tagCount();
                GL11.glDisable((int)3553);
                v5.func_78382_b();
                v5.func_78378_d(0x666666);
                int px = x - s * 8;
                int py = y + 4;
                v5.func_78377_a((double)(px - 1), (double)(py + 8 + 1), 0.0);
                v5.func_78377_a((double)x, (double)(py + 8 + 1), 0.0);
                v5.func_78377_a((double)x, (double)(py - 1), 0.0);
                v5.func_78377_a((double)(px - 1), (double)(py - 1), 0.0);
                v5.func_78378_d(0);
                v5.func_78377_a((double)px, (double)(py + 8), 0.0);
                v5.func_78377_a((double)x, (double)(py + 8), 0.0);
                v5.func_78377_a((double)x, (double)py, 0.0);
                v5.func_78377_a((double)px, (double)py, 0.0);
                v5.func_78381_a();
                GL11.glEnable((int)3553);
                for (CrystalElement e : tag.elementSet()) {
                    IIcon ico = e.getFaceRune();
                    float u = ico.func_94209_e();
                    float v = ico.func_94206_g();
                    float du = ico.func_94212_f();
                    float dv = ico.func_94210_h();
                    v5.func_78382_b();
                    int dx = x - (k + 1) * 8;
                    int dy = y + 4;
                    v5.func_78374_a((double)(dx + 0), (double)(dy + 8), 0.0, (double)u, (double)dv);
                    v5.func_78374_a((double)(dx + 8), (double)(dy + 8), 0.0, (double)du, (double)dv);
                    v5.func_78374_a((double)(dx + 8), (double)(dy + 0), 0.0, (double)du, (double)v);
                    v5.func_78374_a((double)(dx + 0), (double)(dy + 0), 0.0, (double)u, (double)v);
                    v5.func_78381_a();
                    ++k;
                }
            }
            ++i;
        }
    }

    private int getPieX(int r, int space, int gsc) {
        return ChromaOptions.PIELOC.getValue() < 2 ? r + space : Minecraft.func_71410_x().field_71443_c / gsc - r - space;
    }

    private int getPieY(int r, int space, int gsc) {
        return ChromaOptions.PIELOC.getValue() % 2 == 0 ? r + space : Minecraft.func_71410_x().field_71440_d / gsc - r - space - 16;
    }

    private void renderElementPie(EntityPlayer ep, int gsc) {
        int r;
        GL11.glEnable((int)3042);
        Tessellator v5 = Tessellator.field_78398_a;
        int w = 4;
        int rb = r = Keyboard.isKeyDown((int)42) ? 48 : 32;
        int sp = 4;
        int ox = this.getPieX(r, sp, gsc);
        int oy = this.getPieY(r, sp, gsc);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/wheelback_2.png");
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78374_a((double)(ox - r * 2), (double)(oy + r * 2), 0.0, 0.0, 1.0);
        v5.func_78374_a((double)(ox + r * 2), (double)(oy + r * 2), 0.0, 1.0, 1.0);
        v5.func_78374_a((double)(ox + r * 2), (double)(oy - r * 2), 0.0, 1.0, 0.0);
        v5.func_78374_a((double)(ox - r * 2), (double)(oy - r * 2), 0.0, 0.0, 0.0);
        v5.func_78381_a();
        GL11.glDisable((int)3553);
        float flag = PlayerElementBuffer.instance.getAndDecrUpgradeTick(ep);
        if (flag > 0.0f) {
            v5.func_78371_b(2);
            v5.func_78378_d(0xFFFFFF);
            v5.func_78380_c(240);
            double tr = (float)(r * 2) * (1.0f - flag);
            if (tr <= (double)r) {
                for (double a = 0.0; a <= 360.0; a += 5.0) {
                    double x = (double)ox + tr * Math.cos(Math.toRadians(a));
                    double y = (double)oy + tr * Math.sin(Math.toRadians(a));
                    v5.func_78377_a(x, y, 0.0);
                }
            }
            v5.func_78381_a();
        }
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            double min = (double)e.ordinal() * 22.5;
            double max = (double)(e.ordinal() + 1) * 22.5;
            v5.func_78371_b(5);
            int color = e.getColor();
            if (flag > 0.0f) {
                int red = ReikaColorAPI.getRed((int)color);
                int green = ReikaColorAPI.getGreen((int)color);
                int blue = ReikaColorAPI.getBlue((int)color);
                float[] hsb = Color.RGBtoHSB(red, green, blue, null);
                int deg = (int)(System.currentTimeMillis() / 2L % 360L);
                hsb[2] = (float)((double)hsb[2] * (0.75 + 0.25 * Math.sin(Math.toRadians(deg))));
                color = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            }
            v5.func_78378_d(color);
            v5.func_78380_c(240);
            int amt = PlayerElementBuffer.instance.getPlayerContent(ep, e);
            int cap = PlayerElementBuffer.instance.getElementCap(ep);
            double b = 2.0;
            double dr = (double)r * Math.pow((double)amt / (double)cap, 0.675);
            for (double a = min; a <= max; a += 2.0) {
                double x = (double)ox + dr * Math.cos(Math.toRadians(a));
                double y = (double)oy + dr * Math.sin(Math.toRadians(a));
                v5.func_78377_a(x, y, 0.0);
                v5.func_78377_a((double)ox, (double)oy, 0.0);
            }
            v5.func_78381_a();
            IIcon ico = e.getOutlineRune();
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            int s = 8;
            double rr = 0.8125 * (double)r;
            double dx = (double)(ox - s / 2) + rr * Math.cos(Math.toRadians(11.125 + (double)i * 22.5));
            double dy = (double)(oy - s / 2) + rr * Math.sin(Math.toRadians(11.125 + (double)i * 22.5));
            GL11.glEnable((int)3553);
            ReikaTextureHelper.bindTerrainTexture();
            v5.func_78382_b();
            v5.func_78374_a(dx + 0.0, dy + (double)s, 0.0, (double)u, (double)dv);
            v5.func_78374_a(dx + (double)s, dy + (double)s, 0.0, (double)du, (double)dv);
            v5.func_78374_a(dx + (double)s, dy + 0.0, 0.0, (double)du, (double)v);
            v5.func_78374_a(dx + 0.0, dy + 0.0, 0.0, (double)u, (double)v);
            v5.func_78381_a();
            GL11.glDisable((int)3553);
        }
        float wide = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)2.0f);
        v5.func_78371_b(1);
        v5.func_78378_d(0);
        v5.func_78380_c(240);
        for (double a = 0.0; a < 360.0; a += 22.5) {
            double x = (double)ox + (double)rb * Math.cos(Math.toRadians(a));
            double y = (double)oy + (double)rb * Math.sin(Math.toRadians(a));
            v5.func_78377_a(x, y, 0.0);
            v5.func_78377_a((double)ox, (double)oy, 0.0);
        }
        v5.func_78381_a();
        GL11.glLineWidth((float)wide);
        GL11.glEnable((int)3553);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/wheelfront2.png");
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78374_a((double)(ox - r * 2), (double)(oy + r * 2), 0.0, 0.0, 1.0);
        v5.func_78374_a((double)(ox + r * 2), (double)(oy + r * 2), 0.0, 1.0, 1.0);
        v5.func_78374_a((double)(ox + r * 2), (double)(oy - r * 2), 0.0, 1.0, 0.0);
        v5.func_78374_a((double)(ox - r * 2), (double)(oy - r * 2), 0.0, 0.0, 0.0);
        v5.func_78381_a();
        int cap = PlayerElementBuffer.instance.getElementCap(ep);
        String s = "Cap: " + cap;
        FontRenderer f = Minecraft.func_71410_x().field_71466_p;
        ReikaGuiAPI.instance.func_73732_a(f, s, ox, oy + r + f.field_78288_b - 4, 0xFFFFFF);
    }

    public void addProgressionNote(ChromaResearchManager.ProgressElement p) {
        ProgressOverlayRenderer.instance.addProgressionNote(p);
    }

    public void addLoreNote(EntityPlayer ep, Towers t) {
        FullScreenOverlayRenderer.instance.addLoreNote(ep, t);
    }

    private static class FlareMessage {
        private static final int OBF_FRAMES = 25;
        private static final int FRAMES_PER_CHAR = 2;
        private static final int DEOBF_FRAMES = 200;
        private final String text;
        private int age = 0;
        private final int deobfTicks;
        private int charSplit = -1;
        private final int lifespan;

        private FlareMessage(String s) {
            this.text = s;
            this.deobfTicks = 25 + 2 * this.text.length();
            this.lifespan = this.deobfTicks + 200;
        }

        private boolean update() {
            ++this.age;
            if (this.age >= 25) {
                this.charSplit = this.age >= this.deobfTicks ? this.text.length() : (this.age - 25) / 2;
                return this.age >= this.lifespan;
            }
            return false;
        }

        private void render(int gsc, int x, int y, int color) {
            int c = 0xFFFFFF;
            if (this.charSplit >= 0) {
                if (this.charSplit >= this.text.length()) {
                    float f = (float)(this.age - this.deobfTicks) / (float)(this.lifespan - this.deobfTicks);
                    if ((double)f >= 0.5) {
                        c = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)0, (float)(1.0f - (f - 0.5f) * 2.0f));
                        c = 0xFF000000 | c;
                    }
                    ChromaFontRenderer.FontType.GUI.renderer.func_78276_b(this.text, x, y, c);
                } else {
                    String s1 = this.text.substring(0, this.charSplit);
                    String s2 = this.text.substring(this.charSplit);
                    ChromaFontRenderer.FontType.GUI.renderer.func_78276_b(s1, x, y, c);
                    int x2 = x + ChromaFontRenderer.FontType.GUI.renderer.func_78256_a(s1);
                    ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78276_b(s2, x2, y, c);
                }
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78276_b(this.text, x, y, c);
            }
        }
    }
}

