/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.IO.DelegateFontRenderer;
import Reika.DragonAPI.IO.ReikaImageLoader;
import Reika.DragonAPI.Instantiable.Rendering.BasicFontRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ChromaFontRenderer
extends BasicFontRenderer {
    private final FontType type;
    private final int[] offsets = new int[this.field_78286_d.length];
    private long lastReload = 0L;
    private char preChar;
    private char postChar;

    private ChromaFontRenderer(FontType f) {
        super(false);
        this.type = f;
    }

    protected float renderCharFraction(int charIndex, boolean italic, float fraction) {
        if (this.type == FontType.OBFUSCATED) {
            charIndex += this.offsets[charIndex];
            int min = ChromaFontRenderer.getCharGridIndex((char)' ');
            int max = ChromaFontRenderer.getCharGridIndex((char)'~');
            if (this.preChar != '\u0000') {
                charIndex -= ChromaFontRenderer.getCharGridIndex((char)this.preChar);
            }
            if (this.postChar != '\u0000') {
                charIndex += ChromaFontRenderer.getCharGridIndex((char)this.postChar);
            }
            charIndex += this.currentString.hashCode();
            charIndex = min + (this.field_78286_d.length + charIndex % this.field_78286_d.length) % (max - min + 1);
        }
        return super.renderCharFraction(charIndex, italic, fraction);
    }

    protected void bindTexture() {
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.type.texture);
    }

    protected boolean needsGLBlending() {
        return true;
    }

    protected boolean renderCharInString(String sg, int idx, boolean shadow) {
        if (this.type == FontType.OBFUSCATED) {
            this.preChar = idx > 0 ? sg.charAt(idx - 1) : (char)'\u0000';
            this.postChar = idx < sg.length() - 1 ? sg.charAt(idx + 1) : (char)'\u0000';
        }
        return super.renderCharInString(sg, idx, shadow);
    }

    protected void onReload() {
        super.onReload();
        this.rerandomize();
    }

    public void rerandomize() {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)4);
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent evt) {
        this.rerandomize();
    }

    protected void func_111272_d() {
        if (System.currentTimeMillis() - this.lastReload < 250L) {
            return;
        }
        BufferedImage buf = ReikaImageLoader.readImage(ChromatiCraft.class, (String)this.type.texture, null);
        int w = buf.getWidth();
        int h = buf.getHeight();
        int[] rgb = new int[w * h];
        buf.getRGB(0, 0, w, h, rgb, 0, w);
        int slotHeight = h / 16;
        int slotWidth = w / 16;
        int b0 = 1;
        float f = 8.0f / (float)slotWidth;
        for (int index = 0; index < 256; ++index) {
            int xOffset;
            int col = index % 16;
            int row = index / 16;
            if (index == 32) {
                this.field_78286_d[index] = 3 + b0;
            }
            for (xOffset = slotWidth - 1; xOffset >= 0; --xOffset) {
                int xPos = col * slotWidth + xOffset;
                boolean flag = true;
                for (int yOffset = 0; yOffset < slotHeight && flag; ++yOffset) {
                    int yPosByCol = (row * slotWidth + yOffset) * w;
                    int color = rgb[xPos + yPosByCol];
                    if ((color >> 24 & 0xFF) == 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            this.field_78286_d[index] = (int)(0.5 + (double)((float)(++xOffset) * f)) + b0;
        }
        this.lastReload = System.currentTimeMillis();
    }

    public void drawTitleScroll(String sg, int x, int y, float fraction, int c1, int c2, int cflash1, int cflash2) {
        boolean over = fraction >= 1.0f + 1.0f / (float)sg.length();
        fraction = Math.min(1.0f, fraction);
        float s = 2.0f;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glScaled((double)s, (double)s, (double)s);
        ChromaFontRenderer fr = FontType.GUI.renderer;
        float sx = (float)x / s - (float)fr.func_78256_a(sg) / 2.0f;
        float f = (float)y / s;
        ((Object)((Object)fr)).getClass();
        float sy = f - 9.0f / 2.0f;
        for (int d = 2; d <= 6; ++d) {
            int fade = 112 / d << 24;
            int c1o = c1 & 0xFFFFFF | fade;
            int c2o = c2 & 0xFFFFFF | fade;
            int cflash1o = cflash1 & 0xFFFFFF | fade;
            int cflash2o = c2 & 0xFFFFFF | fade;
            this.drawTitleText(sg, sx + (float)d / s, sy + (float)d / s, fraction, over, c1o, c2o, cflash1o, cflash2o);
        }
        this.drawTitleText(sg, sx, sy, fraction, over, c1, c2, cflash1, cflash2);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void drawTitleText(String sg, float sx, float sy, float fraction, boolean over, int c1, int c2, int cflash1, int cflash2) {
        int ret;
        int a;
        float px;
        int c;
        int i;
        ChromaFontRenderer fr = FontType.GUI.renderer;
        HashSet<Integer> spaces = new HashSet<Integer>();
        int o = 0;
        for (int i2 = 0; i2 < sg.length(); ++i2) {
            char c3 = sg.charAt(i2);
            if (c3 != ' ') continue;
            spaces.add(i2 - o - 1);
            ++o;
        }
        sg = ReikaStringParser.stripSpaces((String)sg);
        int len = sg.length();
        int pos1 = (double)fraction < 0.5 ? (int)(fraction * 2.0f * (float)len) : len;
        int pos2 = (double)fraction >= 0.5 ? (int)(((double)fraction - 0.5) * 2.0 * (double)len) : 0;
        for (i = 0; i < pos1; ++i) {
            c = i == pos1 - 1 && (double)fraction < 0.5 ? cflash1 : c1;
            px = i == 0 ? sx : sx + (float)fr.func_78256_a(sg.substring(0, i));
            for (a = i - 1; a >= 0; --a) {
                if (!spaces.contains(a)) continue;
                px += (float)fr.func_78263_a(' ');
            }
            ret = fr.drawStringFloatPos(String.valueOf(sg.charAt(i)), px, sy, c, false);
        }
        for (i = 0; i < pos2; ++i) {
            c = i == pos2 - 1 && !over ? cflash2 : c2;
            px = i == 0 ? sx : sx + (float)fr.func_78256_a(sg.substring(0, i));
            for (a = i - 1; a >= 0; --a) {
                if (!spaces.contains(a)) continue;
                px += (float)fr.func_78263_a(' ');
            }
            ret = fr.drawStringFloatPos(String.valueOf(sg.charAt(i)), px, sy, c, false);
        }
    }

    public static enum FontType {
        GUI("gui_font.png"),
        LEXICON("lexicon_font.png"),
        HUD("hud_font.png"),
        OBFUSCATED("obf_font.png");

        private final String texture;
        public final String id;
        public final ChromaFontRenderer renderer;

        private FontType(String s) {
            this.texture = "Textures/Font/" + s;
            this.renderer = new ChromaFontRenderer(this);
            this.id = DelegateFontRenderer.getRegisteredInstance().addRenderer((BasicFontRenderer)this.renderer);
        }

        public int drawString(String s, int x, int y, int color) {
            return this.drawString(s, x, y, color, false);
        }

        public int drawString(String s, int x, int y, int color, boolean shadow) {
            return this.renderer.func_85187_a(s, x, y, color, shadow);
        }

        public void drawSplitString(String s, int x, int y, int split, int color) {
            this.renderer.func_78279_b(s, x, y, split, color);
        }
    }
}

