/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.BranchingTree;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TransmutationRecipes {
    public static final TransmutationRecipes instance = new TransmutationRecipes();
    private final BranchingTree<ItemMatch, ItemStack> recipes = new BranchingTree();

    private TransmutationRecipes() {
    }

    private void addRecipe(ItemStack out, ElementTagCompound energy, Object ... inputs) {
        Object[] branches = new ItemMatch[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            branches[i] = this.parseItem(inputs[i]);
        }
        this.recipes.addPath((Object)out, branches);
    }

    private ItemMatch parseItem(Object o) {
        if (o instanceof String) {
            return new ItemMatch((ItemStack)o);
        }
        if (o instanceof Block) {
            return new ItemMatch(new ItemStack((Block)o));
        }
        if (o instanceof Item) {
            return new ItemMatch(new ItemStack((Item)o));
        }
        if (o instanceof ItemStack) {
            return new ItemMatch((ItemStack)o);
        }
        throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Illegal input item " + o + " for transmutation recipe");
    }

    public ElementTagCompound getEnergyValue(ItemStack is) {
        if (ChromaItems.BERRY.matchWith(is)) {
            return new ElementTagCompound(CrystalElement.elements[is.func_77960_j()], 1);
        }
        if (ChromaItems.SHARD.matchWith(is)) {
            return new ElementTagCompound(CrystalElement.elements[is.func_77960_j() % 16], is.func_77960_j() >= 16 ? 36 : 6);
        }
        if (ChromaItems.SEED.matchWith(is)) {
            return new ElementTagCompound(CrystalElement.elements[is.func_77960_j() % 16], 2);
        }
        return null;
    }
}

