/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Auxiliary.Interfaces.EnergyLinkingRecipe;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Registry.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class RepeaterRecipe
extends CastingRecipe.MultiBlockCastingRecipe
implements EnergyLinkingRecipe {
    private final ChromaTiles tile;

    public RepeaterRecipe(ChromaTiles c, ItemStack main) {
        super(c.getCraftedProduct(), main);
        this.tile = c;
        this.addRune(CrystalElement.BLACK, 0, -1, 5);
        this.addRune(CrystalElement.BLACK, 0, -1, -5);
        this.addRune(CrystalElement.BLACK, 5, -1, 0);
        this.addRune(CrystalElement.BLACK, -5, -1, 0);
        this.addRune(CrystalElement.WHITE, 5, -1, 5);
        this.addRune(CrystalElement.WHITE, -5, -1, -5);
        this.addRune(CrystalElement.WHITE, 5, -1, -5);
        this.addRune(CrystalElement.WHITE, -5, -1, 5);
        this.addRune(CrystalElement.RED, -5, -1, -4);
        this.addRune(CrystalElement.RED, 5, -1, 4);
        this.addRune(CrystalElement.BLUE, 5, -1, -4);
        this.addRune(CrystalElement.BLUE, -5, -1, 4);
        this.addRune(CrystalElement.GREEN, -4, -1, -5);
        this.addRune(CrystalElement.GREEN, 4, -1, 5);
        this.addRune(CrystalElement.YELLOW, 4, -1, -5);
        this.addRune(CrystalElement.YELLOW, -4, -1, 5);
    }

    @Override
    public final boolean canRunRecipe(EntityPlayer ep) {
        return super.canRunRecipe(ep) && ChromaResearchManager.instance.getPlayerResearchLevel(ep).ordinal() >= ChromaResearchManager.ResearchLevel.NETWORKING.ordinal() && ProgressionManager.ProgressStage.BLOWREPEATER.isPlayerAtStage(ep);
    }

    @Override
    public final NBTTagCompound handleNBTResult(TileEntityCastingTable te, EntityPlayer ep, NBTTagCompound tag) {
        if (this.tile.isTurbochargeableRepeater()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74757_a("boosted", false);
        }
        return tag;
    }

    @Override
    public void onCrafted(TileEntityCastingTable te, EntityPlayer ep, int amount) {
        super.onCrafted(te, ep, amount);
        ProgressionManager.ProgressStage.REPEATER.stepPlayerTo(ep);
    }

    @Override
    public final float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        switch (this.tile) {
            case REPEATER: {
                return 1.5f;
            }
            case COMPOUND: {
                return 2.0f;
            }
            case BROADCAST: {
                return 3.0f;
            }
        }
        return 1.0f;
    }
}

