/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Base.BlockChromaTiered;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.ReversibleMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PlantDropManager {
    public static final PlantDropManager instance = new PlantDropManager();
    private final ReversibleMultiMap<BlockKey, KeyedItemStack> data = new ReversibleMultiMap((MultiMap.CollectionFactory)new MultiMap.HashSetFactory());

    private PlantDropManager() {
    }

    public void registerDrops(Block b, int meta, ItemStack is) {
        this.data.addValue((Object)new BlockKey(b, meta), (Object)this.getKey(is));
    }

    public Collection<BlockKey> getPlantForDrops(ItemStack result, EntityPlayer ep) {
        ArrayList c = this.data.getBackward((Object)this.getKey(result));
        if (c != null && ep != null) {
            c = new ArrayList(c);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                BlockKey b = (BlockKey)it.next();
                if (!(b.blockID instanceof BlockChromaTiered) || ((BlockChromaTiered)b.blockID).getProgressStage(b.metadata).isPlayerAtStage(ep)) continue;
                it.remove();
            }
        }
        return c != null ? Collections.unmodifiableCollection(c) : null;
    }

    private KeyedItemStack getKey(ItemStack result) {
        return new KeyedItemStack(result).setSimpleHash(true).lock();
    }

    public Collection<ItemStack> getDropsForPlant(Block b, int meta, EntityPlayer ep) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (ep != null && b instanceof BlockChromaTiered && !((BlockChromaTiered)b).getProgressStage(meta).isPlayerAtStage(ep)) {
            return li;
        }
        Collection c = this.data.getForward((Object)new BlockKey(b, meta));
        if (c != null) {
            for (KeyedItemStack is : c) {
                li.add(is.getItemStack());
            }
        }
        return li;
    }

    public Collection<BlockKey> getAllBlocks() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public Collection<ItemStack> getAllDrops() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (KeyedItemStack is : this.data.values()) {
            li.add(is.getItemStack());
        }
        return li;
    }
}

