/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ItemMagicRegistry;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BloodMagicHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;

public class FabricationRecipes {
    private static final FabricationRecipes instance = new FabricationRecipes();
    private final HashMap<KeyedItemStack, ElementTagCompound> data = new HashMap();
    public static final float SCALE = 0.8f;
    public static final float INITFACTOR = 0.5f;
    public static final int FACTOR = 400;
    public static final int POWER = 5;
    private int max;

    public static FabricationRecipes recipes() {
        return instance;
    }

    private FabricationRecipes() {
        ItemStack item;
        Collection<KeyedItemStack> c = ItemMagicRegistry.instance.keySet();
        for (KeyedItemStack k : c) {
            ElementTagCompound tag = ItemMagicRegistry.instance.getItemValue(k);
            tag = this.processTag(tag);
            k.setSimpleHash(true);
            this.data.put(k, tag);
            this.max = Math.max(this.max, tag.getMaximumValue());
        }
        ElementTagCompound tag = new ElementTagCompound();
        tag.addTag(CrystalElement.RED, 5000);
        tag.addTag(CrystalElement.BROWN, 500);
        tag.addTag(CrystalElement.BLACK, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.STONE.ordinal()), tag);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.COBBLE.ordinal()), tag);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACK.ordinal()), tag);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACKS.ordinal()), tag);
        ElementTagCompound tag2 = tag.copy();
        tag2.addTag(CrystalElement.WHITE, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.GLASS.ordinal()), tag2);
        tag2 = tag.copy();
        tag2.addTag(CrystalElement.WHITE, 500);
        tag2.addTag(CrystalElement.BLUE, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.LIGHT.ordinal()), tag2);
        tag2 = tag.copy();
        tag2.addTag(CrystalElement.GREEN, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.MOSS.ordinal()), tag2);
        tag2 = tag.copy();
        tag2.addTag(CrystalElement.BLUE, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CLOAK.ordinal()), tag2);
        tag = new ElementTagCompound();
        tag.addTag(CrystalElement.BROWN, 500);
        tag.addTag(CrystalElement.BLACK, 10000);
        tag.addTag(CrystalElement.YELLOW, 25000);
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GLOWBEAM.ordinal()), tag);
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GLOWCOL.ordinal()), tag);
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.FOCUS.ordinal()), tag);
        if (ModList.THAUMCRAFT.isLoaded() && (item = ReikaItemHelper.lookupItem((ModList)ModList.THAUMCRAFT, (String)"ItemEldritchObject", (int)3)) != null) {
            tag = new ElementTagCompound();
            HashSet<CrystalElement> set = new HashSet<CrystalElement>();
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.AIR, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.FIRE, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.WATER, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.ENTROPY, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.EARTH, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.ORDER, true));
            for (CrystalElement e : set) {
                tag.addTag(e, 1000000);
            }
            tag.addTag(CrystalElement.PINK, 100000);
            tag.addTag(CrystalElement.BLACK, 100000);
            this.addRecipe(item, tag);
        }
        if (ModList.BOTANIA.isLoaded() && (item = ReikaItemHelper.lookupItem((ModList)ModList.BOTANIA, (String)"manaResource", (int)5)) != null) {
            tag = new ElementTagCompound();
            tag.addValueToColor(CrystalElement.PINK, 40000);
            tag.addValueToColor(CrystalElement.BLACK, 20000);
            tag.addValueToColor(CrystalElement.GREEN, 20000);
            this.addRecipe(item, tag);
        }
        if (ModList.BLOODMAGIC.isLoaded()) {
            item = BloodMagicHandler.getInstance().demonShardID;
            if (item != null) {
                tag = new ElementTagCompound();
                tag.addValueToColor(CrystalElement.PINK, 80000);
                tag.addValueToColor(CrystalElement.BLACK, 20000);
                tag.addValueToColor(CrystalElement.MAGENTA, 40000);
                tag.addValueToColor(CrystalElement.LIGHTGRAY, 20000);
                this.addRecipe(new ItemStack((Item)item), tag);
            }
            if ((item = BloodMagicHandler.getInstance().resourceID) != null) {
                tag = new ElementTagCompound();
                tag.addValueToColor(CrystalElement.PINK, 20000);
                tag.addValueToColor(CrystalElement.BLACK, 5000);
                tag.addValueToColor(CrystalElement.MAGENTA, 10000);
                tag.addValueToColor(CrystalElement.LIGHTGRAY, 5000);
                this.addRecipe(new ItemStack((Item)item, 1, 29), tag);
                this.addRecipe(new ItemStack((Item)item, 1, 28), tag);
            }
        }
        if (ModList.THAUMICTINKER.isLoaded()) {
            ElementTagCompound nether = new ElementTagCompound();
            nether.addValueToColor(CrystalElement.ORANGE, 25000);
            nether.addValueToColor(CrystalElement.PINK, 25000);
            nether.addValueToColor(CrystalElement.BLACK, 10000);
            ElementTagCompound end = new ElementTagCompound();
            end.addValueToColor(CrystalElement.LIGHTGRAY, 25000);
            end.addValueToColor(CrystalElement.PINK, 25000);
            end.addValueToColor(CrystalElement.BLACK, 10000);
            this.addRecipe(ReikaItemHelper.lookupItem((ModList)ModList.THAUMICTINKER, (String)"kamiResource", (int)6), nether);
            this.addRecipe(ReikaItemHelper.lookupItem((ModList)ModList.THAUMICTINKER, (String)"kamiResource", (int)7), end);
        }
        if (ModList.APPENG.isLoaded() && (item = GameRegistry.findBlock((String)ModList.APPENG.modLabel, (String)"tile.BlockSkyStone")) != null) {
            tag = new ElementTagCompound();
            tag.addValueToColor(CrystalElement.BROWN, 500);
            tag.addValueToColor(CrystalElement.LIME, 200);
            tag.addValueToColor(CrystalElement.WHITE, 100);
            this.addRecipe(new ItemStack((Block)item, 1, 0), tag);
        }
        if (ModList.FORBIDDENMAGIC.isLoaded() && (item = ReikaItemHelper.lookupItem((String)"ForbiddenMagic:NetherShard:1")) != null) {
            tag = new ElementTagCompound();
            tag.addValueToColor(CrystalElement.PINK, 500);
            tag.addValueToColor(CrystalElement.ORANGE, 1000);
            tag.addValueToColor(CrystalElement.LIGHTGRAY, 100);
            this.addRecipe(item, tag);
        }
        if (ModList.TWILIGHT.isLoaded()) {
            item = ReikaItemHelper.lookupItem((String)"TwilightForest:item.charmOfLife1");
            if (item != null) {
                tag = new ElementTagCompound();
                tag.addValueToColor(CrystalElement.MAGENTA, 2500);
                tag.addValueToColor(CrystalElement.BLACK, 1000);
                this.addRecipe(item, tag);
            }
            if ((item = ReikaItemHelper.lookupItem((String)"TwilightForest:tile.TFFirefly")) != null) {
                tag = new ElementTagCompound();
                tag.addValueToColor(CrystalElement.BLUE, 300);
                tag.addValueToColor(CrystalElement.GREEN, 60);
                this.addRecipe(item, tag);
            }
            if ((item = ReikaItemHelper.lookupItem((String)"TwilightForest:item.borerEssence")) != null) {
                tag = new ElementTagCompound();
                tag.addValueToColor(CrystalElement.PINK, 500);
                tag.addValueToColor(CrystalElement.BROWN, 100);
                tag.addValueToColor(CrystalElement.LIGHTGRAY, 50);
                this.addRecipe(item, tag);
            }
        }
    }

    private void addOreDictRecipe(String ore, ElementTagCompound tag) {
        ArrayList li = OreDictionary.getOres((String)ore);
        for (ItemStack is : li) {
            this.addRecipe(is, tag.copy());
        }
    }

    public ElementTagCompound processTag(ElementTagCompound tag) {
        tag = tag.copy();
        tag.scale(0.5f);
        tag.power(5.0);
        tag.scale(400.0f);
        return tag;
    }

    private void addRecipe(ItemStack is, ElementTagCompound tag) {
        this.data.put(new KeyedItemStack(is).setSimpleHash(true), tag);
        this.max = Math.max(this.max, tag.getMaximumValue());
    }

    public Collection<ItemStack> getItemsFabricableWith(ElementTagCompound tag) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (KeyedItemStack ks : this.data.keySet()) {
            ElementTagCompound val = this.data.get(ks).copy().scale(0.8f);
            if (!tag.containsAtLeast(val)) continue;
            items.add(ks.getItemStack());
        }
        return items;
    }

    public boolean isItemFabricable(ItemStack is) {
        KeyedItemStack ks = new KeyedItemStack(is).setSimpleHash(true);
        return this.data.containsKey(ks);
    }

    public boolean isItemFabricable(ItemStack is, ElementTagCompound tag) {
        KeyedItemStack ks = new KeyedItemStack(is).setSimpleHash(true);
        return this.data.containsKey(ks) && tag.containsAtLeast(this.getItemCost(ks));
    }

    public ElementTagCompound getItemCost(ItemStack is) {
        return this.getItemCost(new KeyedItemStack(is).setSimpleHash(true));
    }

    private ElementTagCompound getItemCost(KeyedItemStack is) {
        ElementTagCompound tag = this.data.get(is);
        return tag != null ? tag.copy().scale(1.25f) : null;
    }

    public int getMaximumCost() {
        return this.max;
    }

    public Collection<KeyedItemStack> getFabricableItems() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }
}

