/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles.RecipeCrystalRepeater;
import Reika.ChromatiCraft.Block.Decoration.BlockEtherealLight;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PylonTurboRecipe
extends CastingRecipe.PylonCastingRecipe {
    public PylonTurboRecipe(ItemStack out, ItemStack main, RecipeCrystalRepeater repeater) {
        super(out, main);
        this.addAuxItem(ChromaStacks.iridChunk, 0, -4);
        this.addAuxItem(Blocks.field_150343_Z, 0, -2);
        this.addAuxItem(ChromaStacks.purityDust, 2, 0);
        this.addAuxItem(ChromaStacks.purityDust, -2, 0);
        this.addAuxItem(ChromaStacks.glowbeans, 4, 0);
        this.addAuxItem(ChromaStacks.glowbeans, -4, 0);
        this.addAuxItem(Items.field_151114_aO, 4, 2);
        this.addAuxItem(Items.field_151114_aO, -4, 2);
        this.addAuxItem(ChromaStacks.chargedWhiteShard, 2, -2);
        this.addAuxItem(ChromaStacks.chargedWhiteShard, -2, -2);
        this.addAuxItem(ChromaStacks.focusDust, 2, -4);
        this.addAuxItem(ChromaStacks.focusDust, -2, -4);
        this.addAuxItem(ChromaBlocks.PYLONSTRUCT.getStackOf(), -2, 2);
        this.addAuxItem(ChromaBlocks.PYLONSTRUCT.getStackOf(), 0, 2);
        this.addAuxItem(ChromaBlocks.PYLONSTRUCT.getStackOf(), 2, 2);
        this.addAuxItem(ChromaBlocks.PYLONSTRUCT.getStackOf(), 0, 4);
        this.addAuxItem(Items.field_151042_j, -4, 4);
        this.addAuxItem(Items.field_151042_j, 4, 4);
        this.addAuxItem(Items.field_151043_k, -2, 4);
        this.addAuxItem(Items.field_151043_k, 2, 4);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            this.addAuraRequirement(e, 50000);
            this.addRuneRingRune(e);
        }
        this.addAuraRequirement(CrystalElement.PURPLE, 250000);
        this.addAuraRequirement(CrystalElement.BLACK, 150000);
        this.addAuraRequirement(CrystalElement.BLUE, 100000);
        this.addAuraRequirement(CrystalElement.YELLOW, 200000);
        this.addAuraRequirement(CrystalElement.WHITE, 75000);
        this.addRunes(repeater.getRunes());
    }

    @Override
    public int getNumberProduced() {
        return 9;
    }

    @Override
    public int getTypicalCraftedAmount() {
        return 16;
    }

    @Override
    public int getDuration() {
        return super.getDuration() * 24;
    }

    @Override
    public int getPenaltyThreshold() {
        return this.getTypicalCraftedAmount();
    }

    @Override
    public float getPenaltyMultiplier() {
        return 0.0f;
    }

    @Override
    public boolean canBeStacked() {
        return true;
    }

    @Override
    public void onRecipeTick(TileEntityCastingTable te) {
        if (!te.field_145850_b.field_72995_K) {
            int tick = te.getCraftingTick();
            for (int i = 0; i < EffectType.list.length; ++i) {
                EffectType e = EffectType.list[i];
                if (!e.getChance(te.getRandom(), tick)) continue;
                e.doEffect(te);
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PYLONTURBORECIPE.ordinal(), (TileEntity)te, (int)64, (int[])new int[]{i});
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onClientSideRandomTick(TileEntityCastingTable te, int effect) {
        EffectType.list[effect].doEffect(te);
    }

    @SideOnly(value=Side.CLIENT)
    private static void genParticleRing(TileEntityCastingTable te) {
        double x = (double)te.field_145851_c + 0.5;
        double y = (double)te.field_145848_d + 0.5;
        double z = (double)te.field_145849_e + 0.5;
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ORB, (double)x, (double)y, (double)z, (float)1.0f, (float)1.0f);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ORB, (double)x, (double)y, (double)z, (float)1.0f, (float)0.5f);
        for (double a = 0.0; a < 360.0; a += 2.0) {
            float s = (float)ReikaRandomHelper.getRandomBetween((double)2.0, (double)5.0);
            EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(te.field_145850_b, x, y, z, a, 0.0).setScale(s).setNoSlowdown();
            int c = CrystalElement.getBlendedColor((int)a, 22);
            fx.setColor(c);
            fx.particleVelocity = 0.25;
            fx.freedom *= 2.0;
            fx.angleVelocity *= 8.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private static void glowArea(TileEntityCastingTable te) {
        for (int i = 2; i < 6; ++i) {
            for (int k = 1; k < 8; ++k) {
                Coordinate c = new Coordinate((TileEntity)te).offset(ForgeDirection.VALID_DIRECTIONS[i], k);
                if (!c.getBlock(te.field_145850_b).isAir((IBlockAccess)te.field_145850_b, c.xCoord, c.yCoord, c.zCoord)) continue;
                c.setBlock(te.field_145850_b, ChromaBlocks.LIGHT.getBlockInstance(), BlockEtherealLight.Flags.DECAY.getFlag());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void glowAreaClient(TileEntityCastingTable te) {
        double x = (double)te.field_145851_c + 0.5;
        double y = (double)te.field_145848_d + 0.5;
        double z = (double)te.field_145849_e + 0.5;
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.FIRE, (double)x, (double)y, (double)z, (float)1.0f, (float)2.0f);
        Random rand = te.getRandom();
        int n = 64 + rand.nextInt(128);
        for (int i = 0; i < n; ++i) {
            float s = (float)ReikaRandomHelper.getRandomBetween((double)5.0, (double)10.0);
            int c = ReikaColorAPI.mixColors((int)CrystalElement.BLUE.getColor(), (int)0xFFFFFF, (float)rand.nextFloat());
            double px = ReikaRandomHelper.getRandomPlusMinus((double)x, (double)12.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)y, (double)0.5);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)z, (double)12.0);
            int l = 20 + rand.nextInt(60);
            float g = 2.0f * (float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.25);
            double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
            EntityBlurFX fx = new EntityBlurFX(te.field_145850_b, px, py, pz, 0.0, v, 0.0).setRapidExpand().setScale(s).setColor(c).setLife(l).setIcon(ChromaIcons.FADE_RAY).setColliding().setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void generateSkyParticle(TileEntityCastingTable te) {
        double x = (double)te.field_145851_c + 0.5;
        double y = (double)te.field_145848_d + 0.5;
        double z = (double)te.field_145849_e + 0.5;
        double r = 1.5;
        double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DISCHARGE, (double)x, (double)y, (double)z, (float)1.0f, (float)0.5f);
        int l = 150;
        int c1 = CrystalElement.YELLOW.getColor();
        int c3 = CrystalElement.WHITE.getColor();
        int c2 = ReikaColorAPI.mixColors((int)c1, (int)c3, (float)0.5f);
        for (double d = -r; d <= r; d += 0.03125) {
            double dy = y + d;
            double ms = 6.0;
            double s = ms - Math.abs(d) * ms / r;
            double s2 = s * 0.5;
            double s3 = s * 0.25;
            EntityBlurFX fx = new EntityBlurFX(te.field_145850_b, x, dy, z, 0.0, v, 0.0).setNoSlowdown().setRapidExpand().setScale((float)s).setColor(c1).setLife(l).setIcon(ChromaIcons.FADE_STAR);
            EntityBlurFX fx2 = new EntityBlurFX(te.field_145850_b, x, dy, z, 0.0, v, 0.0).setNoSlowdown().setRapidExpand().setScale((float)s2).setColor(c2).setLife(l).setIcon(ChromaIcons.FADE_STAR).lockTo(fx);
            EntityBlurFX fx3 = new EntityBlurFX(te.field_145850_b, x, dy, z, 0.0, v, 0.0).setNoSlowdown().setRapidExpand().setScale((float)s3).setColor(c3).setLife(l).setIcon(ChromaIcons.FADE_STAR).lockTo(fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx3);
        }
        EntityBlurFX fx = new EntityBlurFX(te.field_145850_b, x, y, z).setRapidExpand().setScale(24.0f).setColor(c1).setLife(l).setIcon(ChromaIcons.RINGFLARE);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        return is == null ? 8.0f : (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.lumenCore) ? 4.0f : 2.0f);
    }

    @Override
    public int getEnhancedTableAccelerationFactor() {
        return 8;
    }

    private static enum EffectType {
        PARTICLERING(false),
        GLOWAREA(true),
        SKYPARTICLE(false);

        public final boolean runServerside;
        private static final EffectType[] list;

        private EffectType(boolean b) {
            this.runServerside = b;
        }

        public boolean getChance(Random rand, int tick) {
            switch (this) {
                case PARTICLERING: {
                    return rand.nextInt(10 + tick / 8) == 0;
                }
                case GLOWAREA: {
                    return rand.nextInt(20 + tick / 2) == 0;
                }
                case SKYPARTICLE: {
                    return rand.nextInt(10 + tick % 64) == 0;
                }
            }
            return false;
        }

        public void doEffect(TileEntityCastingTable te) {
            if (!te.field_145850_b.field_72995_K && !this.runServerside) {
                return;
            }
            switch (this) {
                case PARTICLERING: {
                    PylonTurboRecipe.genParticleRing(te);
                    break;
                }
                case GLOWAREA: {
                    if (te.field_145850_b.field_72995_K) {
                        PylonTurboRecipe.glowAreaClient(te);
                        break;
                    }
                    PylonTurboRecipe.glowArea(te);
                    break;
                }
                case SKYPARTICLE: {
                    PylonTurboRecipe.generateSkyParticle(te);
                }
            }
        }

        static {
            list = EffectType.values();
        }
    }
}

