/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class IridescentCrystalRecipe
extends CastingRecipe.PylonCastingRecipe {
    public IridescentCrystalRecipe(ItemStack out, ItemStack main) {
        super(out, main);
        this.addAuxItem(ChromaStacks.iridChunk, -2, 0);
        this.addAuxItem(ChromaStacks.iridChunk, -4, 0);
        this.addAuxItem(ChromaStacks.iridChunk, 2, 0);
        this.addAuxItem(ChromaStacks.iridChunk, 4, 0);
        this.addAuxItem(ChromaStacks.iridChunk, 0, -2);
        this.addAuxItem(ChromaStacks.iridChunk, 0, -4);
        this.addAuxItem(Blocks.field_150343_Z, -4, 2);
        this.addAuxItem(Blocks.field_150343_Z, -2, 2);
        this.addAuxItem(Blocks.field_150343_Z, 0, 2);
        this.addAuxItem(Blocks.field_150343_Z, 2, 2);
        this.addAuxItem(Blocks.field_150343_Z, 4, 2);
        this.addAuxItem(Blocks.field_150426_aN, 2, -2);
        this.addAuxItem(Blocks.field_150426_aN, -2, -2);
        this.addAuraRequirement(CrystalElement.YELLOW, 15000);
        this.addAuraRequirement(CrystalElement.BLACK, 25000);
        this.addAuraRequirement(CrystalElement.PURPLE, 10000);
    }

    @Override
    public int getDuration() {
        return 4 * super.getDuration();
    }

    @Override
    public void onCrafted(TileEntityCastingTable te, EntityPlayer ep, int amount) {
        super.onCrafted(te, ep, amount);
    }

    @Override
    public int getTypicalCraftedAmount() {
        return 128;
    }

    @Override
    public boolean canBeStacked() {
        return true;
    }

    @Override
    public float getConsecutiveStackingTimeFactor(TileEntityCastingTable te) {
        return 0.975f;
    }

    @Override
    public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        return is == null ? 4.0f : 2.0f;
    }

    @Override
    public void onRecipeTick(TileEntityCastingTable te) {
        int tick = te.getCraftingTick();
        if (te.field_145850_b.field_72995_K) {
            this.doParticleFX(te, tick);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticleFX(TileEntityCastingTable te, int tick) {
        double px = (double)te.field_145851_c + te.getRandom().nextDouble();
        double pz = (double)te.field_145849_e + te.getRandom().nextDouble();
        double vy = 0.125;
        double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        float g = (float)ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.125);
        EntityBlurFX fx = new EntityBlurFX(te.field_145850_b, px, te.field_145848_d + 1, pz, vx, vy, vz).setIcon(ChromaIcons.CHROMA).setBasicBlend().setGravity(g);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        int t = this.getDuration() - tick;
        if (t % 18 == 0) {
            CrystalElement e = CrystalElement.elements[t / 18 % 16];
            for (int i = 0; i < 64; ++i) {
                px = (double)te.field_145851_c + te.getRandom().nextDouble();
                pz = (double)te.field_145849_e + te.getRandom().nextDouble();
                vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
                vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
                fx = new EntityBlurFX(te.field_145850_b, px, te.field_145848_d + 1, pz, vx, vy, vz).setIcon(ChromaIcons.FADE_STAR).setColor(e.getColor());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            float f = (float)CrystalMusicManager.instance.getDingPitchScale(e);
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.BUFFERWARNING_EMPTY, (double)((double)te.field_145851_c + 0.5), (double)((double)te.field_145848_d + 0.5), (double)((double)te.field_145849_e + 0.5), (float)1.0f, (float)f);
        }
    }
}

