/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class FocusCrystalRecipes {
    private static final boolean exponentialCosts = true;
    private static final ItemStack basicCrystal = TileEntityFocusCrystal.CrystalTier.FLAWED.getCraftedItem();
    private static final ItemStack defaultCrystal = TileEntityFocusCrystal.CrystalTier.DEFAULT.getCraftedItem();
    private static final ItemStack refinedCrystal = TileEntityFocusCrystal.CrystalTier.REFINED.getCraftedItem();
    private static final ItemStack exquisiteCrystal = TileEntityFocusCrystal.CrystalTier.EXQUISITE.getCraftedItem();
    private static final ItemStack defaultSlab = ReikaItemHelper.stoneSlab;
    private static final ItemStack refinedSlab = ChromaBlocks.PYLONSTRUCT.getStackOf();
    private static final ItemStack exquisiteSlab = ReikaItemHelper.chiseledQuartz;
    private static final ItemStack defaultDust = ChromaStacks.focusDust;
    private static final ItemStack refinedDust = ChromaStacks.purityDust;
    private static final ItemStack exquisiteDust = ChromaStacks.lumaDust;

    @SideOnly(value=Side.CLIENT)
    public static IIcon getBaseRenderIcon(TileEntityFocusCrystal.CrystalTier tier) {
        ItemStack is = null;
        switch (tier) {
            case DEFAULT: {
                is = defaultSlab;
                break;
            }
            case EXQUISITE: {
                is = exquisiteSlab;
                break;
            }
            case REFINED: {
                is = refinedSlab;
                break;
            }
        }
        return is != null ? Block.func_149634_a((Item)is.func_77973_b()).func_149691_a(1, is.func_77960_j()) : null;
    }

    private static IRecipe getBasicRecipe() {
        return new ShapedOreRecipe(basicCrystal, new Object[]{" S ", " E ", " s ", Character.valueOf('S'), "stone", Character.valueOf('E'), Items.field_151166_bC, Character.valueOf('s'), Blocks.field_150333_U});
    }

    private static IRecipe getDefaultRecipe() {
        return ReikaRecipeHelper.getShapedRecipeFor((ItemStack)defaultCrystal, (Object[])new Object[]{" A ", "BCB", "SAS", Character.valueOf('S'), defaultSlab, Character.valueOf('A'), basicCrystal, Character.valueOf('B'), defaultDust, Character.valueOf('C'), ChromaStacks.bindingCrystal});
    }

    public static class ExquisiteFocusCrystalRecipe
    extends CastingRecipe.PylonCastingRecipe {
        public ExquisiteFocusCrystalRecipe(CastingRecipe.TempleCastingRecipe r) {
            super(exquisiteCrystal, ChromaStacks.bindingCrystal);
            this.addRunes(r.getRunes());
            this.addAuxItem(refinedCrystal, 0, -2);
            this.addAuxItem(refinedCrystal, 0, 2);
            this.addAuxItem(exquisiteDust, -2, 0);
            this.addAuxItem(exquisiteDust, 2, 0);
            this.addAuxItem(exquisiteDust, 0, -4);
            this.addAuxItem(exquisiteDust, -4, 0);
            this.addAuxItem(exquisiteDust, 4, 0);
            this.addAuxItem(exquisiteSlab, -2, 4);
            this.addAuxItem(exquisiteSlab, 0, 4);
            this.addAuxItem(exquisiteSlab, 2, 4);
            this.addAuraRequirement(CrystalElement.WHITE, 1000);
            this.addAuraRequirement(CrystalElement.BLACK, 5000);
            this.addAuraRequirement(CrystalElement.LIGHTBLUE, 10000);
        }

        @Override
        public int getTypicalCraftedAmount() {
            return 16;
        }

        @Override
        public float getConsecutiveStackingTimeFactor(TileEntityCastingTable te) {
            return 0.8f;
        }

        @Override
        public boolean canBeStacked() {
            return true;
        }

        @Override
        public void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.FOCUSCRYSTAL);
            c.add(ProgressionManager.ProgressStage.RUNEUSE);
            c.add(ProgressionManager.ProgressStage.LINK);
            c.add(ProgressionManager.ProgressStage.DIMENSION);
        }
    }

    public static class RefinedFocusCrystalRecipe
    extends CastingRecipe.MultiBlockCastingRecipe {
        public RefinedFocusCrystalRecipe(CastingRecipe.TempleCastingRecipe r) {
            super(refinedCrystal, ChromaStacks.bindingCrystal);
            this.addRunes(r.getRunes());
            this.addAuxItem(defaultCrystal, 0, -2);
            this.addAuxItem(defaultCrystal, 0, 2);
            this.addAuxItem(refinedDust, -2, 0);
            this.addAuxItem(refinedDust, 2, 0);
            this.addAuxItem(refinedDust, 0, -4);
            this.addAuxItem(refinedDust, -4, 0);
            this.addAuxItem(refinedDust, 4, 0);
            this.addAuxItem(refinedSlab, -2, 4);
            this.addAuxItem(refinedSlab, 0, 4);
            this.addAuxItem(refinedSlab, 2, 4);
            this.addAuxItem(ChromaStacks.avolite, 2, -2);
            this.addAuxItem(ChromaStacks.avolite, -2, -2);
        }

        @Override
        public int getTypicalCraftedAmount() {
            return 16 * ReikaMathLibrary.intpow2((int)2, (int)1);
        }

        @Override
        public void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.FOCUSCRYSTAL);
            c.add(ProgressionManager.ProgressStage.RUNEUSE);
            c.add(ProgressionManager.ProgressStage.LINK);
            c.add(ProgressionManager.ProgressStage.POWERCRYSTAL);
        }
    }

    public static class DefaultFocusCrystalRecipe
    extends CastingRecipe.TempleCastingRecipe {
        public DefaultFocusCrystalRecipe() {
            super(defaultCrystal, FocusCrystalRecipes.getDefaultRecipe());
            this.addRune(CrystalElement.BLACK, 3, -1, -3);
            this.addRune(CrystalElement.WHITE, 2, -1, 4);
            this.addRune(CrystalElement.LIGHTBLUE, -3, -1, -2);
        }

        @Override
        public int getTypicalCraftedAmount() {
            return 16 * ReikaMathLibrary.intpow2((int)2, (int)2);
        }

        @Override
        public void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.FOCUSCRYSTAL);
            c.add(ProgressionManager.ProgressStage.RUNEUSE);
        }
    }

    public static class FlawedFocusCrystalRecipe
    extends CastingRecipe {
        public FlawedFocusCrystalRecipe() {
            super(basicCrystal, FocusCrystalRecipes.getBasicRecipe());
        }

        @Override
        public int getTypicalCraftedAmount() {
            return 16 * ReikaMathLibrary.intpow2((int)2, (int)3);
        }

        @Override
        public void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
            super.getRequiredProgress(c);
            c.add(ProgressionManager.ProgressStage.FOCUSCRYSTAL);
        }
    }
}

