/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;

public class BatteryRecipe
extends CastingRecipe.PylonCastingRecipe {
    public static final int NOTE_SPEED = 8;
    private final ReikaMusicHelper.MusicKey[] melody = new ReikaMusicHelper.MusicKey[]{ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.D4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.D5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.F5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.E5, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.B4, ReikaMusicHelper.MusicKey.G4};
    private final ReikaMusicHelper.MusicKey[] chords = new ReikaMusicHelper.MusicKey[]{ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.D4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.E4};

    public BatteryRecipe(ItemStack out, ItemStack main) {
        super(out, main);
        this.addAuxItem(ChromaTiles.REPEATER.getCraftedProduct(), 0, 2);
        this.addAuxItem(ChromaTiles.REPEATER.getCraftedProduct(), 0, -2);
        this.addAuxItem(ChromaStacks.focusDust, 2, 0);
        this.addAuxItem(ChromaStacks.focusDust, -2, 0);
        this.addAuxItem(ChromaStacks.avolite, -4, 0);
        this.addAuxItem(ChromaStacks.avolite, 4, 0);
        this.addAuxItem(ChromaStacks.avolite, 0, 4);
        this.addAuxItem(ChromaStacks.avolite, 0, -4);
        this.addAuxItem(ChromaStacks.avolite, -2, 2);
        this.addAuxItem(ChromaStacks.avolite, -2, -2);
        this.addAuxItem(ChromaStacks.avolite, 2, -2);
        this.addAuxItem(ChromaStacks.avolite, 2, 2);
        this.addAuxItem(ChromaStacks.chargedWhiteShard, -4, 4);
        this.addAuxItem(ChromaStacks.chargedYellowShard, -4, -4);
        this.addAuxItem(ChromaStacks.chargedBlueShard, 4, -4);
        this.addAuxItem(ChromaStacks.chargedBlackShard, 4, 4);
        this.addAuxItem(ChromaStacks.beaconDust, -4, 2);
        this.addAuxItem(ChromaStacks.beaconDust, -4, -2);
        this.addAuxItem(ChromaStacks.beaconDust, 4, 2);
        this.addAuxItem(ChromaStacks.beaconDust, 4, -2);
        this.addAuxItem(ChromaStacks.beaconDust, -2, 4);
        this.addAuxItem(ChromaStacks.beaconDust, 2, 4);
        this.addAuxItem(ChromaStacks.beaconDust, -2, -4);
        this.addAuxItem(ChromaStacks.beaconDust, 2, -4);
        this.addAuraRequirement(CrystalElement.BLACK, 80000);
        this.addAuraRequirement(CrystalElement.YELLOW, 80000);
        this.addAuraRequirement(CrystalElement.BLUE, 30000);
        this.addAuraRequirement(CrystalElement.PURPLE, 8000);
    }

    @Override
    public int getDuration() {
        return 16 * super.getDuration();
    }

    @Override
    public void onRecipeTick(TileEntityCastingTable te) {
        int tick = te.getCraftingTick();
        if (te.field_145850_b.field_72995_K) {
            this.doFX(te, tick);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doFX(TileEntityCastingTable te, int tick) {
        ReikaMusicHelper.MusicKey m;
        int t = this.getDuration() - tick;
        if (t == 0) {
            return;
        }
        if (t % 8 == 0) {
            m = this.melody[t / 8 % this.melody.length];
            this.playKey(te, m, ChromaSounds.DING);
        }
        if (t % 64 == 0) {
            m = this.chords[t / 64 % this.chords.length];
            this.playKey(te, m, ChromaSounds.ORB);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playKey(TileEntityCastingTable te, ReikaMusicHelper.MusicKey m, ChromaSounds s) {
        float f = 0.0f;
        for (CrystalElement e : CrystalMusicManager.instance.getColorsWithKey(m)) {
            int idx = CrystalMusicManager.instance.getIntervalFor(e, m);
            f = CrystalMusicManager.instance.getScaledDing(e, idx);
            this.spawnParticles(te, e, idx);
        }
        ReikaSoundHelper.playClientSound((SoundEnum)s, (double)((double)te.field_145851_c + 0.5), (double)((double)te.field_145848_d + 0.5), (double)((double)te.field_145849_e + 0.5), (float)1.0f, (float)f);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(TileEntityCastingTable te, CrystalElement e, int idx) {
        double ang = Math.toRadians(22.5 * (double)e.ordinal());
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        double r = 6.0;
        for (double d = 0.0; d < r; d += 0.125) {
            double dl = r / 2.0 - Math.abs(d - r / 2.0);
            double dc = ReikaMathLibrary.cosInterpolation((double)0.0, (double)r, (double)d);
            double dx = (double)te.field_145851_c + 0.5 + c * d;
            double dz = (double)te.field_145849_e + 0.5 + s * d;
            double vy = dc * 0.0625 * 1.5 * (0.75 + (double)idx / 2.0);
            double dy = (double)te.field_145848_d + 0.5;
            float g = 0.0625f * (float)dc;
            EntityBlurFX fx = new EntityBlurFX(te.field_145850_b, dx, dy, dz, 0.0, vy, 0.0).setLife(60).setGravity(g).setColor(e.getColor()).setScale(1.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }
}

