/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.EnergyLinkingRecipe;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RepeaterTurboRecipe
extends CastingRecipe.PylonCastingRecipe
implements EnergyLinkingRecipe {
    public RepeaterTurboRecipe(ChromaTiles rpt, int baseAura) {
        super(RepeaterTurboRecipe.getOutputItem(rpt), rpt.getCraftedProduct());
        this.addAuraRequirement(CrystalElement.BLACK, 5 * baseAura);
        this.addAuraRequirement(CrystalElement.WHITE, 4 * baseAura);
        this.addAuraRequirement(CrystalElement.PURPLE, 8 * baseAura);
        this.addAuraRequirement(CrystalElement.BLUE, 10 * baseAura);
        this.addAuraRequirement(CrystalElement.YELLOW, 15 * baseAura);
        this.addAuraRequirement(CrystalElement.GRAY, 2 * baseAura);
        this.addAuxItem(ChromaStacks.glowbeans, -2, -2);
        this.addAuxItem(ChromaStacks.glowbeans, 2, -2);
        this.addAuxItem(ChromaStacks.glowbeans, -2, 2);
        this.addAuxItem(ChromaStacks.glowbeans, 2, 2);
        this.addAuxItem(ChromaStacks.boostroot, 0, 2);
        this.addAuxItem(ChromaStacks.boostroot, 0, -2);
        this.addAuxItem(ChromaStacks.boostroot, 2, 0);
        this.addAuxItem(ChromaStacks.boostroot, -2, 0);
        this.addAuxItem(ChromaStacks.beaconDust, -4, -4);
        this.addAuxItem(ChromaStacks.beaconDust, 4, 4);
        this.addAuxItem(ChromaStacks.beaconDust, -4, 4);
        this.addAuxItem(ChromaStacks.beaconDust, 4, -4);
        this.addAuxItem(ChromaStacks.focusDust, 0, -4);
        this.addAuxItem(ChromaStacks.focusDust, 4, 0);
        this.addAuxItem(ChromaStacks.focusDust, 0, 4);
        this.addAuxItem(ChromaStacks.focusDust, -4, 0);
        this.addAuxItem(Items.field_151114_aO, -2, -4);
        this.addAuxItem(Items.field_151114_aO, 2, -4);
        this.addAuxItem(Items.field_151114_aO, 4, -2);
        this.addAuxItem(Items.field_151114_aO, 4, 2);
        this.addAuxItem(Items.field_151114_aO, 2, 4);
        this.addAuxItem(Items.field_151114_aO, -2, 4);
        this.addAuxItem(Items.field_151114_aO, -4, 2);
        this.addAuxItem(Items.field_151114_aO, -4, -2);
    }

    private static ItemStack getOutputItem(ChromaTiles rpt) {
        ItemStack is = rpt.getCraftedProduct();
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74757_a("boosted", true);
        return is;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    protected void getRequiredProgress(Collection<ProgressionManager.ProgressStage> c) {
        c.add(ProgressionManager.ProgressStage.TURBOCHARGE);
    }

    @Override
    public int getExperience() {
        return super.getExperience() * 20;
    }

    @Override
    public int getDuration() {
        return super.getDuration() * 8;
    }

    @Override
    public ChromaSounds getSoundOverride(TileEntityCastingTable te, int soundTimer) {
        return soundTimer >= te.getSoundLength() ? ChromaSounds.POWERCRAFT : null;
    }

    @Override
    public void onRecipeTick(TileEntityCastingTable te) {
        int tick = te.getCraftingTick();
        if (te.field_145850_b.field_72995_K) {
            RepeaterTurboRecipe.doParticleFX(te, tick);
        }
    }

    @Override
    public void onCrafted(TileEntityCastingTable te, EntityPlayer ep, int amount) {
        super.onCrafted(te, ep, amount);
        if (te.field_145850_b.field_72995_K) {
            for (int i = 0; i < 16; ++i) {
                int x = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145851_c, (int)8);
                int y = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145848_d, (int)2);
                int z = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145849_e, (int)8);
                ReikaParticleHelper.EXPLODE.spawnAroundBlock(te.field_145850_b, x, y, z, 4);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.TRAP, (double)((double)te.field_145851_c + 0.5), (double)((double)te.field_145848_d + 0.5), (double)((double)te.field_145849_e + 0.5), (float)2.0f, (float)2.0f);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.TRAP, (double)((double)te.field_145851_c + 0.5), (double)((double)te.field_145848_d + 0.5), (double)((double)te.field_145849_e + 0.5), (float)2.0f, (float)1.0f);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.TRAP, (double)((double)te.field_145851_c + 0.5), (double)((double)te.field_145848_d + 0.5), (double)((double)te.field_145849_e + 0.5), (float)2.0f, (float)0.5f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doParticleFX(TileEntityCastingTable te, int tick) {
        for (int i = 0; i < 3; ++i) {
            double x = (double)te.field_145851_c + 0.5;
            double y = (double)te.field_145848_d + 0.5;
            double z = (double)te.field_145849_e + 0.5;
            Random rand = te.getRandom();
            int l = 10 + rand.nextInt(10);
            float s = 2.0f + rand.nextFloat() * 3.0f;
            EntityFloatingSeedsFX fx1 = (EntityFloatingSeedsFX)new EntityFloatingSeedsFX(te.field_145850_b, x, y, z, rand.nextDouble() * 360.0, rand.nextDouble() * 360.0).setScale(s).setColor(CrystalElement.randomElement().getColor()).setLife(l).setIcon(ChromaIcons.FADE_GENTLE);
            fx1.particleVelocity *= 2.0;
            EntityBlurFX fx2 = new EntityBlurFX(te.field_145850_b, x, y, z).setIcon(ChromaIcons.FLARE).setScale(s * 0.75f).lockTo(fx1).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onClientSideRandomTick(TileEntityCastingTable te, int effect) {
    }

    @Override
    public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        return 24.0f;
    }

    @Override
    public int getEnhancedTableAccelerationFactor() {
        return 6;
    }

    @Override
    public boolean canBeStacked() {
        return true;
    }

    @Override
    public float getConsecutiveStackingTimeFactor(TileEntityCastingTable te) {
        return 0.75f;
    }
}

